/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.segment;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TextSegmentTest
implements WithAssertions {
    TextSegmentTest() {
    }

    @Test
    public void test_blank() {
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> TextSegment.from((String)" ")).withMessageContaining("text cannot be null or blank");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> TextSegment.from(null)).withMessageContaining("text cannot be null or blank");
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> TextSegment.from((String)"text", null)).withMessageContaining("metadata cannot be null");
    }

    @Test
    public void test_equals_hashCode() {
        TextSegment ts1 = TextSegment.from((String)"text");
        TextSegment ts2 = TextSegment.from((String)"text");
        Metadata m1 = new Metadata();
        m1.put("abc", "123");
        Metadata m2 = new Metadata();
        m2.put("abc", "123");
        Metadata m3 = new Metadata();
        m3.put("abc", "xyz");
        TextSegment ts3 = TextSegment.from((String)"text", (Metadata)m1);
        TextSegment ts4 = TextSegment.from((String)"text", (Metadata)m1);
        TextSegment ts5 = TextSegment.from((String)"text", (Metadata)m2);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(ts1).isEqualTo((Object)ts1)).hasSameHashCodeAs((Object)ts1)).isEqualTo((Object)ts2)).hasSameHashCodeAs((Object)ts2)).isNotEqualTo((Object)ts3)).doesNotHaveSameHashCodeAs((Object)ts3);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(ts3).isEqualTo((Object)ts3)).hasSameHashCodeAs((Object)ts3)).isEqualTo((Object)ts4)).hasSameHashCodeAs((Object)ts4)).isEqualTo((Object)ts5)).hasSameHashCodeAs((Object)ts5);
    }

    @Test
    public void test_accessors() {
        Metadata metadata = new Metadata();
        metadata.put("abc", "123");
        TextSegment ts = TextSegment.from((String)"text", (Metadata)metadata);
        this.assertThat(ts.text()).isEqualTo("text");
        this.assertThat(ts.metadata()).isEqualTo((Object)metadata);
        this.assertThat(ts.metadata("abc")).isEqualTo("123");
        this.assertThat(ts).hasToString("TextSegment { text = \"text\" metadata = {abc=123} }");
    }

    @Test
    public void test_builders() {
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new TextSegment("abc", new Metadata())).isEqualTo((Object)TextSegment.from((String)"abc"))).isEqualTo((Object)TextSegment.textSegment((String)"abc"))).isEqualTo((Object)TextSegment.from((String)"abc", (Metadata)new Metadata()))).isEqualTo((Object)TextSegment.textSegment((String)"abc", (Metadata)new Metadata()));
        Metadata metadata = new Metadata();
        metadata.put("abc", "123");
        ((ObjectAssert)this.assertThat(new TextSegment("abc", metadata)).isEqualTo((Object)TextSegment.from((String)"abc", (Metadata)metadata))).isEqualTo((Object)TextSegment.textSegment((String)"abc", (Metadata)metadata));
    }
}

