/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessageType;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class AiMessageTest
implements WithAssertions {
    AiMessageTest() {
    }

    @Test
    public void test_accessors() {
        AiMessage m = new AiMessage("text");
        this.assertThat((Comparable)m.type()).isEqualTo((Object)ChatMessageType.AI);
        this.assertThat(m.text()).isEqualTo("text");
        this.assertThat(m.toolExecutionRequests()).isNull();
        this.assertThat(m.hasToolExecutionRequests()).isFalse();
        this.assertThat(m).hasToString("AiMessage { text = \"text\" toolExecutionRequests = null }");
        m = new AiMessage(Arrays.asList(ToolExecutionRequest.builder().id("foo").build(), ToolExecutionRequest.builder().id("bar").build()));
        this.assertThat((Comparable)m.type()).isEqualTo((Object)ChatMessageType.AI);
        this.assertThat(m.text()).isNull();
        this.assertThat(m.toolExecutionRequests()).hasSize(2);
        this.assertThat(m.hasToolExecutionRequests()).isTrue();
        this.assertThat(m).hasToString("AiMessage { text = null toolExecutionRequests = [ToolExecutionRequest { id = \"foo\", name = null, arguments = null }, ToolExecutionRequest { id = \"bar\", name = null, arguments = null }] }");
    }

    @Test
    public void test_equals_and_hashCode() {
        AiMessage m1 = new AiMessage("text");
        AiMessage m2 = new AiMessage("text");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(m1).isEqualTo((Object)m1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)m2)).hasSameHashCodeAs((Object)m2);
        AiMessage m3 = new AiMessage("different");
        ((ObjectAssert)this.assertThat(m1).isNotEqualTo((Object)m3)).doesNotHaveSameHashCodeAs((Object)m3);
        AiMessage m4 = AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{ToolExecutionRequest.builder().id("foo").build(), ToolExecutionRequest.builder().id("bar").build()});
        AiMessage m5 = AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{ToolExecutionRequest.builder().id("foo").build(), ToolExecutionRequest.builder().id("bar").build()});
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(m4).isNotEqualTo((Object)m1)).doesNotHaveSameHashCodeAs((Object)m1)).isEqualTo((Object)m5)).hasSameHashCodeAs((Object)m5);
    }

    @Test
    public void test_from() {
        Object[] requests = new ToolExecutionRequest[]{ToolExecutionRequest.builder().id("foo").build(), ToolExecutionRequest.builder().id("bar").build()};
        AiMessage m = AiMessage.from((ToolExecutionRequest[])requests);
        this.assertThat(m.text()).isNull();
        this.assertThat(m.toolExecutionRequests()).containsOnly(requests);
        m = AiMessage.aiMessage((ToolExecutionRequest[])requests);
        this.assertThat(m.text()).isNull();
        this.assertThat(m.toolExecutionRequests()).containsOnly(requests);
        m = AiMessage.from(Arrays.asList(requests));
        this.assertThat(m.text()).isNull();
        this.assertThat(m.toolExecutionRequests()).containsOnly(requests);
        m = AiMessage.aiMessage(Arrays.asList(requests));
        this.assertThat(m.text()).isNull();
        this.assertThat(m.toolExecutionRequests()).containsOnly(requests);
        m = AiMessage.from((String)"text");
        this.assertThat(m.text()).isEqualTo("text");
        this.assertThat(m.toolExecutionRequests()).isNull();
        m = AiMessage.aiMessage((String)"text");
        this.assertThat(m.text()).isEqualTo("text");
        this.assertThat(m.toolExecutionRequests()).isNull();
    }

    @Test
    void should_allow_blank_content() {
        this.assertThat(AiMessage.from((String)"").text()).isEqualTo("");
        this.assertThat(AiMessage.from((String)" ").text()).isEqualTo(" ");
    }

    @Test
    void should_fail_when_text_is_null() {
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> AiMessage.from((String)null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("text cannot be null");
    }
}

