/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ToolSpecificationTest
implements WithAssertions {
    ToolSpecificationTest() {
    }

    @Test
    public void test_builder() {
        ToolSpecification ts = ToolSpecification.builder().name("name").description("description").parameters(ToolParameters.builder().type("type").properties(Collections.singletonMap("foo", Collections.singletonMap("bar", "baz"))).required(Collections.singletonList("foo")).build()).build();
        this.assertThat(ts.name()).isEqualTo("name");
        this.assertThat(ts.description()).isEqualTo("description");
        this.assertThat(ts.parameters().type()).isEqualTo("type");
    }

    @Test
    public void test_parameter_builder() {
        ToolSpecification ts = ToolSpecification.builder().name("name").description("description").addParameter("req", new JsonSchemaProperty[]{JsonSchemaProperty.BOOLEAN}).addOptionalParameter("foo", new JsonSchemaProperty[]{JsonSchemaProperty.STRING, JsonSchemaProperty.description((String)"description")}).addOptionalParameter("bar", new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER}).build();
        this.assertThat(ts.name()).isEqualTo("name");
        this.assertThat(ts.description()).isEqualTo("description");
        this.assertThat(ts.parameters().type()).isEqualTo("object");
        this.assertThat((Map)ts.parameters().properties().get("req")).containsEntry((Object)"type", (Object)"boolean");
        ((MapAssert)this.assertThat((Map)ts.parameters().properties().get("foo")).containsEntry((Object)"type", (Object)"string")).containsEntry((Object)"description", (Object)"description");
        this.assertThat((Map)ts.parameters().properties().get("bar")).containsEntry((Object)"type", (Object)"integer");
        this.assertThat(ts.parameters().required()).containsOnly((Object[])new String[]{"req"});
    }

    @Test
    public void test_equals_hash() {
        ToolSpecification sp1 = ToolSpecification.builder().name("name").description("description").parameters(ToolParameters.builder().type("type").properties(Collections.singletonMap("foo", Collections.singletonMap("bar", "baz"))).required(Collections.singletonList("foo")).build()).build();
        ToolSpecification sp2 = ToolSpecification.builder().name("name").description("description").parameters(ToolParameters.builder().type("type").properties(Collections.singletonMap("foo", Collections.singletonMap("bar", "baz"))).required(Collections.singletonList("foo")).build()).build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(sp1).isEqualTo((Object)sp1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)sp2)).hasSameHashCodeAs((Object)sp2);
        ((ObjectAssert)this.assertThat(ToolSpecification.builder().name("changed").description("description").parameters(ToolParameters.builder().type("type").properties(Collections.singletonMap("foo", Collections.singletonMap("bar", "baz"))).required(Collections.singletonList("foo")).build()).build()).isNotEqualTo((Object)sp1)).doesNotHaveSameHashCodeAs((Object)sp1);
        ((ObjectAssert)this.assertThat(ToolSpecification.builder().name("name").description("changed").parameters(ToolParameters.builder().type("type").properties(Collections.singletonMap("foo", Collections.singletonMap("bar", "baz"))).required(Collections.singletonList("foo")).build()).build()).isNotEqualTo((Object)sp1)).doesNotHaveSameHashCodeAs((Object)sp1);
        ((ObjectAssert)this.assertThat(ToolSpecification.builder().name("name").description("description").parameters(ToolParameters.builder().type("type").properties(Collections.singletonMap("foo", Collections.singletonMap("bar", "baz"))).required(Collections.singletonList("changed")).build()).build()).isNotEqualTo((Object)sp1)).doesNotHaveSameHashCodeAs((Object)sp1);
    }

    @Test
    public void test_toString() {
        ToolSpecification sp1 = ToolSpecification.builder().name("name").description("description").parameters(ToolParameters.builder().type("type").properties(Collections.singletonMap("foo", Collections.singletonMap("bar", "baz"))).required(Collections.singletonList("foo")).build()).build();
        this.assertThat(sp1.toString()).isEqualTo("ToolSpecification { name = \"name\", description = \"description\", parameters = ToolParameters { type = \"type\", properties = {foo={bar=baz}}, required = [foo] } }");
    }
}

