/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class JsonSchemaPropertyTest
implements WithAssertions {
    JsonSchemaPropertyTest() {
    }

    @Test
    public void test_common() {
        this.assertThat(JsonSchemaProperty.STRING).isEqualTo((Object)JsonSchemaProperty.type((String)"string"));
        this.assertThat(JsonSchemaProperty.INTEGER).isEqualTo((Object)JsonSchemaProperty.type((String)"integer"));
        this.assertThat(JsonSchemaProperty.NUMBER).isEqualTo((Object)JsonSchemaProperty.type((String)"number"));
        this.assertThat(JsonSchemaProperty.OBJECT).isEqualTo((Object)JsonSchemaProperty.type((String)"object"));
        this.assertThat(JsonSchemaProperty.ARRAY).isEqualTo((Object)JsonSchemaProperty.type((String)"array"));
        this.assertThat(JsonSchemaProperty.BOOLEAN).isEqualTo((Object)JsonSchemaProperty.type((String)"boolean"));
        this.assertThat(JsonSchemaProperty.NULL).isEqualTo((Object)JsonSchemaProperty.type((String)"null"));
    }

    @Test
    public void test_equals_hash() {
        JsonSchemaProperty prop1 = new JsonSchemaProperty("key", (Object)"value");
        JsonSchemaProperty prop2 = new JsonSchemaProperty("key", (Object)"value");
        JsonSchemaProperty prop3 = new JsonSchemaProperty("key", (Object)12);
        JsonSchemaProperty prop4 = new JsonSchemaProperty("abc", (Object)"value");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(prop1).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)prop2)).hasSameHashCodeAs((Object)prop2);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(prop1).isNotEqualTo((Object)prop3)).doesNotHaveSameHashCodeAs((Object)prop3)).isNotEqualTo((Object)prop4)).doesNotHaveSameHashCodeAs((Object)prop4);
        ((ObjectAssert)this.assertThat(prop3).isNotEqualTo((Object)prop4)).doesNotHaveSameHashCodeAs((Object)prop4);
        JsonSchemaProperty enum1 = JsonSchemaProperty.enums((String[])new String[]{"value1", "value2"});
        JsonSchemaProperty enum2 = JsonSchemaProperty.enums((String[])new String[]{"value1", "value2"});
        ((ObjectAssert)this.assertThat(enum1).isEqualTo((Object)enum2)).hasSameHashCodeAs((Object)enum2);
    }

    @Test
    public void test_toString() {
        JsonSchemaProperty prop = new JsonSchemaProperty("key", (Object)"value");
        this.assertThat(prop.toString()).isEqualTo("JsonSchemaProperty { key = \"key\", value = value }");
        this.assertThat(JsonSchemaProperty.enums((String[])new String[]{"value1", "value2"}).toString()).isEqualTo("JsonSchemaProperty { key = \"enum\", value = [value1, value2] }");
    }

    @Test
    public void test_type() {
        JsonSchemaProperty prop = JsonSchemaProperty.type((String)"string");
        this.assertThat(prop.key()).isEqualTo("type");
        this.assertThat(prop.value()).isEqualTo((Object)"string");
    }

    @Test
    public void test_from() {
        JsonSchemaProperty prop = JsonSchemaProperty.from((String)"key", (Object)"value");
        this.assertThat(prop.key()).isEqualTo("key");
        this.assertThat(prop.value()).isEqualTo((Object)"value");
    }

    @Test
    public void test_property() {
        this.assertThat(JsonSchemaProperty.property((String)"key", (Object)"value")).isEqualTo((Object)JsonSchemaProperty.from((String)"key", (Object)"value"));
    }

    @Test
    public void test_description() {
        this.assertThat(JsonSchemaProperty.description((String)"value")).isEqualTo((Object)JsonSchemaProperty.from((String)"description", (Object)"value"));
    }

    @Test
    public void test_enums() {
        JsonSchemaProperty prop = JsonSchemaProperty.enums((String[])new String[]{"value1", "value2"});
        this.assertThat(prop.key()).isEqualTo("enum");
        this.assertThat(Arrays.equals((String[])prop.value(), new String[]{"value1", "value2"})).isTrue();
        prop = JsonSchemaProperty.enums((Object[])new Object[]{EnumTest.VALUE1, EnumTest.value2, EnumTest.Value3});
        this.assertThat(prop.key()).isEqualTo("enum");
        this.assertThat(prop.value()).isEqualTo(Arrays.asList("VALUE1", "value2", "Value3"));
        prop = JsonSchemaProperty.enums(EnumTest.class);
        this.assertThat(prop.key()).isEqualTo("enum");
        this.assertThat(prop.value()).isEqualTo(Arrays.asList("VALUE1", "value2", "Value3"));
        this.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> JsonSchemaProperty.enums((Object[])new Object[]{Object.class, Integer.class})).withMessageContaining("should be enum");
        this.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> JsonSchemaProperty.enums(Object.class)).withMessageContaining("should be enum");
    }

    @Test
    public void test_items() {
        JsonSchemaProperty prop = JsonSchemaProperty.items((JsonSchemaProperty)JsonSchemaProperty.STRING);
        this.assertThat(prop.key()).isEqualTo("items");
        this.assertThat(prop.value()).isEqualTo(Collections.singletonMap("type", "string"));
    }

    public static enum EnumTest {
        VALUE1,
        value2,
        Value3;

    }
}

