/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.Exceptions;
import java.util.Collection;

public class ValidationUtils {
    public static <T> T ensureNotNull(T object, String name) {
        if (object == null) {
            throw Exceptions.illegalArgument("%s cannot be null", name);
        }
        return object;
    }

    public static <T extends Collection<?>> T ensureNotEmpty(T collection, String name) {
        if (collection == null || collection.isEmpty()) {
            throw Exceptions.illegalArgument("%s cannot be null or empty", name);
        }
        return collection;
    }

    public static String ensureNotBlank(String string, String name) {
        if (string == null || string.trim().isEmpty()) {
            throw Exceptions.illegalArgument("%s cannot be null or blank", name);
        }
        return string;
    }
}

