/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chatglm;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chatglm.ChatCompletionRequest;
import dev.langchain4j.model.chatglm.ChatCompletionResponse;
import dev.langchain4j.model.chatglm.ChatGlmApi;
import java.io.IOException;
import java.time.Duration;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class ChatGlmClient {
    private final ChatGlmApi chatGLMApi;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public ChatGlmClient(String baseUrl, Duration timeout) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GSON)).build();
        this.chatGLMApi = (ChatGlmApi)retrofit.create(ChatGlmApi.class);
    }

    public ChatCompletionResponse chatCompletion(ChatCompletionRequest request) {
        try {
            Response retrofitResponse = this.chatGLMApi.chatCompletion(request).execute();
            if (retrofitResponse.isSuccessful() && retrofitResponse.body() != null && ((ChatCompletionResponse)retrofitResponse.body()).getStatus() == 200) {
                return (ChatCompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static ChatGlmClientBuilder builder() {
        return new ChatGlmClientBuilder();
    }

    public static class ChatGlmClientBuilder {
        private String baseUrl;
        private Duration timeout;

        ChatGlmClientBuilder() {
        }

        public ChatGlmClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ChatGlmClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public ChatGlmClient build() {
            return new ChatGlmClient(this.baseUrl, this.timeout);
        }

        public String toString() {
            return "ChatGlmClient.ChatGlmClientBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ")";
        }
    }
}

