/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.cassandra;

import com.datastax.astra.sdk.AstraClient;
import com.datastax.oss.driver.api.core.CqlSession;
import com.dtsx.astra.sdk.cassio.MetadataVectorCassandraTable;
import dev.langchain4j.store.embedding.cassandra.AstraDbEmbeddingConfiguration;
import dev.langchain4j.store.embedding.cassandra.CassandraEmbeddingStoreSupport;

public class AstraDbEmbeddingStore
extends CassandraEmbeddingStoreSupport {
    public AstraDbEmbeddingStore(AstraDbEmbeddingConfiguration config) {
        CqlSession cqlSession = AstraClient.builder().withToken(config.getToken()).withCqlKeyspace(config.getKeyspace()).withDatabaseId(config.getDatabaseId()).withDatabaseRegion(config.getDatabaseRegion()).enableCql().enableDownloadSecureConnectBundle().build().cqlSession();
        this.embeddingTable = new MetadataVectorCassandraTable(cqlSession, config.getKeyspace(), config.getTable(), config.getDimension().intValue());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final AstraDbEmbeddingConfiguration.AstraDbEmbeddingConfigurationBuilder conf = AstraDbEmbeddingConfiguration.builder();

        public Builder token(String token) {
            this.conf.token(token);
            return this;
        }

        public Builder database(String databaseId, String databaseRegion) {
            this.conf.databaseId(databaseId);
            this.conf.databaseRegion(databaseRegion);
            return this;
        }

        public Builder vectorDimension(int dimension) {
            this.conf.dimension(dimension);
            return this;
        }

        public Builder table(String keyspace, String table) {
            this.conf.keyspace(keyspace);
            this.conf.table(table);
            return this;
        }

        public AstraDbEmbeddingStore build() {
            return new AstraDbEmbeddingStore(this.conf.build());
        }
    }
}

