/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.model.bedrock.BedrockAnthropicCompletionChatModelResponse;
import dev.langchain4j.model.bedrock.internal.AbstractBedrockChatModel;
import java.util.HashMap;
import java.util.Map;

public class BedrockAnthropicCompletionChatModel
extends AbstractBedrockChatModel<BedrockAnthropicCompletionChatModelResponse> {
    private static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";
    private final int topK;
    private final String anthropicVersion;
    private final String model;

    @Override
    protected String getModelId() {
        return this.model;
    }

    @Override
    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(7);
        parameters.put("prompt", prompt);
        parameters.put("max_tokens_to_sample", this.getMaxTokens());
        parameters.put("temperature", Float.valueOf(this.getTemperature()));
        parameters.put("top_k", this.topK);
        parameters.put("top_p", Float.valueOf(this.getTopP()));
        parameters.put("stop_sequences", this.getStopSequences());
        parameters.put("anthropic_version", this.anthropicVersion);
        return parameters;
    }

    @Override
    public Class<BedrockAnthropicCompletionChatModelResponse> getResponseClassType() {
        return BedrockAnthropicCompletionChatModelResponse.class;
    }

    private static int $default$topK() {
        return 250;
    }

    private static String $default$anthropicVersion() {
        return DEFAULT_ANTHROPIC_VERSION;
    }

    private static String $default$model() {
        return Types.AnthropicClaudeV2.getValue();
    }

    protected BedrockAnthropicCompletionChatModel(BedrockAnthropicCompletionChatModelBuilder<?, ?> b) {
        super(b);
        this.topK = ((BedrockAnthropicCompletionChatModelBuilder)b).topK$set ? ((BedrockAnthropicCompletionChatModelBuilder)b).topK$value : BedrockAnthropicCompletionChatModel.$default$topK();
        this.anthropicVersion = ((BedrockAnthropicCompletionChatModelBuilder)b).anthropicVersion$set ? ((BedrockAnthropicCompletionChatModelBuilder)b).anthropicVersion$value : BedrockAnthropicCompletionChatModel.$default$anthropicVersion();
        this.model = ((BedrockAnthropicCompletionChatModelBuilder)b).model$set ? ((BedrockAnthropicCompletionChatModelBuilder)b).model$value : BedrockAnthropicCompletionChatModel.$default$model();
    }

    public static BedrockAnthropicCompletionChatModelBuilder<?, ?> builder() {
        return new BedrockAnthropicCompletionChatModelBuilderImpl();
    }

    public int getTopK() {
        return this.topK;
    }

    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    public String getModel() {
        return this.model;
    }

    public static enum Types {
        AnthropicClaudeInstantV1("anthropic.claude-instant-v1"),
        AnthropicClaudeV1("anthropic.claude-v1"),
        AnthropicClaudeV2("anthropic.claude-v2"),
        AnthropicClaudeV2_1("anthropic.claude-v2:1"),
        AnthropicClaude3SonnetV1("anthropic.claude-3-sonnet-20240229-v1:0");

        private final String value;

        private Types(String modelID) {
            this.value = modelID;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class BedrockAnthropicCompletionChatModelBuilder<C extends BedrockAnthropicCompletionChatModel, B extends BedrockAnthropicCompletionChatModelBuilder<C, B>>
    extends AbstractBedrockChatModel.AbstractBedrockChatModelBuilder<BedrockAnthropicCompletionChatModelResponse, C, B> {
        private boolean topK$set;
        private int topK$value;
        private boolean anthropicVersion$set;
        private String anthropicVersion$value;
        private boolean model$set;
        private String model$value;

        public B topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return (B)this.self();
        }

        public B anthropicVersion(String anthropicVersion) {
            this.anthropicVersion$value = anthropicVersion;
            this.anthropicVersion$set = true;
            return (B)this.self();
        }

        public B model(String model) {
            this.model$value = model;
            this.model$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BedrockAnthropicCompletionChatModel.BedrockAnthropicCompletionChatModelBuilder(super=" + super.toString() + ", topK$value=" + this.topK$value + ", anthropicVersion$value=" + this.anthropicVersion$value + ", model$value=" + this.model$value + ")";
        }
    }

    private static final class BedrockAnthropicCompletionChatModelBuilderImpl
    extends BedrockAnthropicCompletionChatModelBuilder<BedrockAnthropicCompletionChatModel, BedrockAnthropicCompletionChatModelBuilderImpl> {
        private BedrockAnthropicCompletionChatModelBuilderImpl() {
        }

        @Override
        protected BedrockAnthropicCompletionChatModelBuilderImpl self() {
            return this;
        }

        @Override
        public BedrockAnthropicCompletionChatModel build() {
            return new BedrockAnthropicCompletionChatModel(this);
        }
    }
}

