/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.anthropic.AnthropicContent;
import dev.langchain4j.model.anthropic.AnthropicImageContent;
import dev.langchain4j.model.anthropic.AnthropicMessage;
import dev.langchain4j.model.anthropic.AnthropicRole;
import dev.langchain4j.model.anthropic.AnthropicTextContent;
import dev.langchain4j.model.anthropic.AnthropicUsage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.stream.Collectors;

class AnthropicMapper {
    AnthropicMapper() {
    }

    static List<AnthropicMessage> toAnthropicMessages(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message.type() != ChatMessageType.SYSTEM).map(AnthropicMapper::toAnthropicMessage).collect(Collectors.toList());
    }

    static AnthropicMessage toAnthropicMessage(ChatMessage message) {
        return AnthropicMessage.builder().role(AnthropicMapper.toAnthropicRole(message.type())).content(AnthropicMapper.toAnthropicContent(message)).build();
    }

    static String toAnthropicSystemPrompt(List<ChatMessage> messages) {
        String systemPrompt = messages.stream().filter(message -> message instanceof SystemMessage).map(message -> ((SystemMessage)message).text()).collect(Collectors.joining("\n\n"));
        if (Utils.isNullOrBlank((String)systemPrompt)) {
            return null;
        }
        return systemPrompt;
    }

    private static AnthropicRole toAnthropicRole(ChatMessageType chatMessageType) {
        switch (chatMessageType) {
            case AI: {
                return AnthropicRole.ASSISTANT;
            }
            case USER: {
                return AnthropicRole.USER;
            }
        }
        throw new IllegalArgumentException("Unknown chat message type: " + chatMessageType);
    }

    private static Object toAnthropicContent(ChatMessage message) {
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            return aiMessage.text();
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            return userMessage.contents().stream().map(content -> {
                if (content instanceof TextContent) {
                    return new AnthropicTextContent(((TextContent)content).text());
                }
                if (content instanceof ImageContent) {
                    Image image = ((ImageContent)content).image();
                    if (image.url() != null) {
                        throw Exceptions.illegalArgument((String)"Anthropic does not support images as URLs, only as Base64-encoded strings", (Object[])new Object[0]);
                    }
                    return new AnthropicImageContent(ValidationUtils.ensureNotBlank((String)image.mimeType(), (String)"mimeType"), ValidationUtils.ensureNotBlank((String)image.base64Data(), (String)"base64Data"));
                }
                throw Exceptions.illegalArgument((String)("Unknown content type: " + content), (Object[])new Object[0]);
            }).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Unknown message type: " + message.type());
    }

    static AiMessage toAiMessage(List<AnthropicContent> contents) {
        String text = contents.stream().filter(content -> "text".equals(content.type)).map(content -> content.text).collect(Collectors.joining("\n"));
        return AiMessage.from((String)text);
    }

    static TokenUsage toTokenUsage(AnthropicUsage anthropicUsage) {
        if (anthropicUsage == null) {
            return null;
        }
        return new TokenUsage(anthropicUsage.inputTokens, anthropicUsage.outputTokens);
    }

    static FinishReason toFinishReason(String anthropicStopReason) {
        if (anthropicStopReason == null) {
            return null;
        }
        switch (anthropicStopReason) {
            case "end_turn": {
                return FinishReason.STOP;
            }
            case "max_tokens": {
                return FinishReason.LENGTH;
            }
            case "stop_sequence": {
                return FinishReason.OTHER;
            }
        }
        return null;
    }
}

