/*
 * Decompiled with CFR 0.152.
 */
package dev.kovstas.fs2throttler;

import cats.Applicative;
import cats.Applicative$;
import cats.Functor;
import cats.Semigroupal;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Clock$;
import cats.effect.kernel.GenTemporal;
import cats.implicits$;
import cats.syntax.SemigroupalOps2$;
import dev.kovstas.fs2throttler.Throttler;
import dev.kovstas.fs2throttler.Throttler$Enforcing$;
import dev.kovstas.fs2throttler.Throttler$Shaping$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Throttler$ {
    public static Throttler$ MODULE$;

    static {
        new Throttler$();
    }

    public <F, O> Function1<Stream<F, O>, Stream<F, O>> throttle(long elements, FiniteDuration duration, Throttler.ThrottleMode mode, GenTemporal<F, Throwable> evidence$1) {
        return this.throttle(elements, duration, mode, 0L, (Function1 & Serializable & scala.Serializable)x$1 -> Applicative$.MODULE$.apply((Applicative)evidence$1).pure((Object)BoxesRunTime.boxToLong((long)1L)), evidence$1);
    }

    public <F, O> Function1<Stream<F, O>, Stream<F, O>> throttle(long elements, FiniteDuration duration, Throttler.ThrottleMode mode, long burst, GenTemporal<F, Throwable> evidence$2) {
        return this.throttle(elements, duration, mode, burst, (Function1 & Serializable & scala.Serializable)x$2 -> Applicative$.MODULE$.apply((Applicative)evidence$2).pure((Object)BoxesRunTime.boxToLong((long)1L)), evidence$2);
    }

    public <F, O> Function1<Stream<F, O>, Stream<F, O>> throttle(long elements, FiniteDuration duration, Throttler.ThrottleMode mode, long burst, Function1<O, F> fnCost, GenTemporal<F, Throwable> evidence$3) {
        return (Function1 & Serializable & scala.Serializable)in -> {
            long capacity = elements + burst <= 0L ? Long.MAX_VALUE : elements + burst;
            long interval = duration.toNanos() / capacity;
            if (interval == 0L) {
                return in;
            }
            return Stream$.MODULE$.eval(Clock$.MODULE$.apply((Clock)evidence$3).monotonic()).flatMap((Function1 & Serializable & scala.Serializable)time -> Pull.StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Throttler$.go$1(in, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> elements, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> time.toNanos(), fnCost, evidence$3, interval, capacity, mode))), NotGiven$.MODULE$.default());
        };
    }

    private static final Pull go$1(Stream s, Function0 tokens, Function0 time, Function1 fnCost$1, GenTemporal evidence$3$1, long interval$1, long capacity$1, Throttler.ThrottleMode mode$1) {
        return Stream.ToPull$.MODULE$.uncons1$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(s))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Object head = tuple2._1();
                Stream tail = (Stream)tuple2._2();
                return Pull$.MODULE$.eval(SemigroupalOps2$.MODULE$.product$extension(implicits$.MODULE$.catsSyntaxSemigroupalOps2(fnCost$1.apply(head)), implicits$.MODULE$.toFunctorOps(Clock$.MODULE$.apply((Clock)evidence$3$1).monotonic(), (Functor)evidence$3$1).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.toNanos())), (Semigroupal)evidence$3$1)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Tuple3 tuple3;
                        Tuple3 tuple32;
                        long cost = tuple2._1$mcJ$sp();
                        long now = tuple2._2$mcJ$sp();
                        long elapsed = now - time.apply$mcJ$sp();
                        long tokensArrived = elapsed >= interval$1 ? elapsed / interval$1 : 0L;
                        long nextTime = time.apply$mcJ$sp() + tokensArrived * interval$1;
                        long available = package$.MODULE$.min(tokens.apply$mcJ$sp() + tokensArrived, capacity$1);
                        if (cost <= available) {
                            tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)(available - cost)), (Object)BoxesRunTime.boxToLong((long)nextTime), (Object)BoxesRunTime.boxToLong((long)0L));
                        } else {
                            long timePassed = now - nextTime;
                            long waitingTime = (cost - available) * interval$1;
                            long delay = waitingTime - timePassed;
                            tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)(now + delay)), (Object)BoxesRunTime.boxToLong((long)delay));
                        }
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        long remainingTokens = BoxesRunTime.unboxToLong((Object)tuple3._1());
                        long nextTime2 = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        long delay = BoxesRunTime.unboxToLong((Object)tuple3._3());
                        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToLong((long)remainingTokens), (Object)BoxesRunTime.boxToLong((long)nextTime2), (Object)BoxesRunTime.boxToLong((long)delay));
                        long remainingTokens2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
                        long nextTime3 = BoxesRunTime.unboxToLong((Object)tuple33._2());
                        long delay2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
                        if (delay2 == 0L) {
                            return Pull$.MODULE$.output1(head).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Throttler$.go$1(tail, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> remainingTokens2, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> nextTime3, fnCost$1, evidence$3$1, interval$1, capacity$1, mode$1));
                        }
                        Throttler.ThrottleMode throttleMode = mode$1;
                        if (Throttler$Enforcing$.MODULE$.equals(throttleMode)) {
                            return Throttler$.go$1(tail, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> remainingTokens2, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> nextTime3, fnCost$1, evidence$3$1, interval$1, capacity$1, mode$1);
                        }
                        if (Throttler$Shaping$.MODULE$.equals(throttleMode)) {
                            return Pull$.MODULE$.sleep(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delay2)).nanos(), evidence$3$1).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Pull$.MODULE$.output1(head)).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Throttler$.go$1(tail, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> remainingTokens2, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> nextTime3, fnCost$1, evidence$3$1, interval$1, capacity$1, mode$1));
                        }
                        throw new MatchError((Object)throttleMode);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError((Object)option);
        });
    }

    private Throttler$() {
        MODULE$ = this;
    }
}

