/*
 * Decompiled with CFR 0.152.
 */
package dev.kovstas.fs2throttler;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Clock$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.implicits$;
import dev.kovstas.fs2throttler.Throttler;
import dev.kovstas.fs2throttler.Throttler$Enforcing$;
import dev.kovstas.fs2throttler.Throttler$Shaping$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class Throttler$ {
    public static final Throttler$ MODULE$ = new Throttler$();

    public <F, O> Function1<Stream<F, O>, Stream<F, O>> throttle(long elements, FiniteDuration duration, Throttler.ThrottleMode mode, GenTemporal<F, Throwable> evidence$1) {
        return this.throttle(elements, duration, mode, 0L, (Function1 & Serializable)x$1 -> Applicative$.MODULE$.apply((Applicative)evidence$1).pure((Object)BoxesRunTime.boxToLong((long)1L)), evidence$1);
    }

    public <F, O> Function1<Stream<F, O>, Stream<F, O>> throttle(long elements, FiniteDuration duration, Throttler.ThrottleMode mode, long burst, GenTemporal<F, Throwable> evidence$2) {
        return this.throttle(elements, duration, mode, burst, (Function1 & Serializable)x$2 -> Applicative$.MODULE$.apply((Applicative)evidence$2).pure((Object)BoxesRunTime.boxToLong((long)1L)), evidence$2);
    }

    public <F, O> Function1<Stream<F, O>, Stream<F, O>> throttle(long elements, FiniteDuration duration, Throttler.ThrottleMode mode, long burst, Function1<O, F> fnCost, GenTemporal<F, Throwable> evidence$3) {
        return (Function1 & Serializable)in -> {
            long capacity = elements + burst <= 0L ? Long.MAX_VALUE : elements + burst;
            return Stream$.MODULE$.eval(cats.effect.package$.MODULE$.Ref().ofEffect(implicits$.MODULE$.toFunctorOps(Clock$.MODULE$.apply((Clock)evidence$3).monotonic(), (Functor)evidence$3).map((Function1 & Serializable)x$4 -> new Tuple2((Object)BoxesRunTime.boxToLong((long)capacity), x$4)), Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)evidence$3), (FlatMap)evidence$3)).flatMap((Function1 & Serializable)bucket -> Pull.StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Throttler$.go$1(in, bucket, capacity, duration.toNanos() / capacity, fnCost, evidence$3, mode))).map((Function1 & Serializable)stream -> stream), NotGiven$.MODULE$.default());
        };
    }

    public static final /* synthetic */ Object $anonfun$throttle$4(GenTemporal evidence$3$1, Ref bucket$1, long interval$1, long capacity$1, Object head$1, Stream tail$1, Throttler.ThrottleMode mode$1, Function1 fnCost$1, long cost) {
        return implicits$.MODULE$.toFlatMapOps(Clock$.MODULE$.apply((Clock)evidence$3$1).monotonic(), (FlatMap)evidence$3$1).flatMap((Function1 & Serializable)now -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(bucket$1.modify((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                long tokens = tuple2._1$mcJ$sp();
                FiniteDuration lastUpdate = (FiniteDuration)tuple2._2();
                if (interval$1 == 0L) {
                    return new Tuple2((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), now), (Object)Duration$.MODULE$.Zero());
                }
                long elapsed = now.$minus(lastUpdate).toNanos();
                long tokensArrived = elapsed >= interval$1 ? elapsed / interval$1 : 0L;
                FiniteDuration nextTime = lastUpdate.$plus(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(tokensArrived * interval$1)).nanos());
                long available = package$.MODULE$.min(tokens + tokensArrived, capacity$1);
                if (cost <= available) {
                    return new Tuple2((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)(available - cost)), (Object)nextTime), (Object)Duration$.MODULE$.Zero());
                }
                long timePassed = now.toNanos() - nextTime.toNanos();
                long waitingTime = (cost - available) * interval$1;
                FiniteDuration delay = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(waitingTime - timePassed)).nanos();
                return new Tuple2((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)now.$plus(delay)), (Object)delay);
            }
            throw new MatchError((Object)tuple2);
        }), (Functor)evidence$3$1).map((Function1 & Serializable)delay -> {
            Pull continueF = Pull$.MODULE$.output1(head$1).$greater$greater((Function0 & Serializable)() -> Throttler$.go$1(tail$1, bucket$1, capacity$1, interval$1, fnCost$1, evidence$3$1, mode$1));
            return new Tuple2(delay, (Object)continueF);
        }), (FlatMap)evidence$3$1).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                Object object;
                FiniteDuration delay = (FiniteDuration)tuple2._1();
                Pull continueF = (Pull)tuple2._2();
                FiniteDuration finiteDuration = delay;
                FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                if (!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null)) {
                    object = Applicative$.MODULE$.apply((Applicative)evidence$3$1).pure((Object)continueF);
                } else {
                    Throttler.ThrottleMode throttleMode = mode$1;
                    if (Throttler$Enforcing$.MODULE$.equals(throttleMode)) {
                        object = Applicative$.MODULE$.apply((Applicative)evidence$3$1).pure((Object)Throttler$.go$1(tail$1, bucket$1, capacity$1, interval$1, fnCost$1, evidence$3$1, mode$1));
                    } else if (Throttler$Shaping$.MODULE$.equals(throttleMode)) {
                        object = ((GenTemporal)Clock$.MODULE$.apply((Clock)evidence$3$1)).delayBy(Applicative$.MODULE$.apply((Applicative)evidence$3$1).pure((Object)continueF), (Duration)delay);
                    } else {
                        throw new MatchError((Object)throttleMode);
                    }
                }
                return implicits$.MODULE$.toFunctorOps(object, (Functor)evidence$3$1).map((Function1 & Serializable)result -> result);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private static final Pull go$1(Stream s, Ref bucket, long capacity, long interval, Function1 fnCost$1, GenTemporal evidence$3$1, Throttler.ThrottleMode mode$1) {
        return Stream.ToPull$.MODULE$.uncons1$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(s))).flatMap((Function1 & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Object head = tuple2._1();
                Stream tail = (Stream)tuple2._2();
                return Pull$.MODULE$.eval(implicits$.MODULE$.toFlatMapOps(fnCost$1.apply(head), (FlatMap)evidence$3$1).flatMap((Function1 & Serializable)cost -> Throttler$.$anonfun$throttle$4(evidence$3$1, bucket, interval, capacity, head, tail, mode$1, fnCost$1, BoxesRunTime.unboxToLong((Object)cost)))).flatMap((Function1 & Serializable)x -> (Pull)Predef$.MODULE$.identity(x));
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError((Object)option);
        });
    }

    private Throttler$() {
    }
}

