/*
 * Copyright (c) 2021 kotx__.
 * Twitter: https://twitter.com/kotx__
 */

package dev.kotx.flylib.command

import dev.kotx.flylib.utils.*
import org.bukkit.*
import org.bukkit.command.*
import org.bukkit.entity.*
import org.bukkit.plugin.java.*

class CommandContext(
    val command: Command,
    val plugin: JavaPlugin,
    val sender: CommandSender,
    val message: String,
    val args: Array<String>,
    val typedArgs: Array<Any?>
) {

    val player: Player? = sender as? Player
    val server: Server? = player?.server
    val world: World? = player?.world

    val options = getOptions()
    val argsWithoutOptions = withoutOptionList()

    @JvmName("getOptions1")
    private fun getOptions(): Map<String, List<String>> {
        val singleHyphenRegex = "-([a-zA-Z0-9]+)".toRegex()
        val doubleHyphenRegex = "--([a-zA-Z0-9]+)".toRegex()

        val groups = mutableMapOf<String, List<String>>()
        val groupCache = mutableListOf<String>()
        args.reversed().forEach { it ->

            when {
                it.matches(singleHyphenRegex) -> {
                    singleHyphenRegex.find(it)!!.groupValues[1].map(Char::toString).forEach {
                        groups[it] = emptyList()
                    }

                    groupCache.clear()
                }

                it.matches(doubleHyphenRegex) -> {
                    groups[doubleHyphenRegex.find(it)!!.groupValues[1]] = groupCache.toList().reversed()
                    groupCache.clear()
                }

                else -> groupCache.add(it)
            }
        }

        return groups
    }

    private fun withoutOptionList(): List<String> {
        val messages = mutableListOf<String>()
        args.forEach {
            if (it.startsWith("-"))
                return messages
            else
                messages.add(it)
        }

        return messages
    }

    fun send(block: TextComponentAction) {
        sender.sendPluginMessage(plugin, block)
    }

    fun send(text: String) {
        sender.sendPluginMessage(plugin, text)
    }

    fun fail(text: String) {
        sender.fail(plugin, text)
    }

    fun warn(text: String) {
        sender.warn(plugin, text)
    }

    fun success(text: String) {
        sender.success(plugin, text)
    }

    fun interface Action {
        fun CommandContext.execute()
    }
}