(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'colorkt'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'colorkt'.");
    }root.colorkt = factory(typeof colorkt === 'undefined' ? {} : colorkt, kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_q3lmfv$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var kotlin_js_internal_DoubleCompanionObject = Kotlin.kotlin.js.internal.DoubleCompanionObject;
  var equals = Kotlin.equals;
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var JsMath = Math;
  var rangeTo = Kotlin.kotlin.ranges.rangeTo_38ydlf$;
  var coerceIn = Kotlin.kotlin.ranges.coerceIn_nig4hr$;
  var getKClass = Kotlin.getKClass;
  var throwCCE = Kotlin.throwCCE;
  var toString = Kotlin.kotlin.text.toString_dqglrj$;
  var padStart = Kotlin.kotlin.text.padStart_vrc1nu$;
  var roundToInt = Kotlin.kotlin.math.roundToInt_yrwdxr$;
  var removePrefix = Kotlin.kotlin.text.removePrefix_gsj5wt$;
  var toInt = Kotlin.kotlin.text.toInt_6ic1pp$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var mutableListOf = Kotlin.kotlin.collections.mutableListOf_i5x0yv$;
  var HashSet_init = Kotlin.kotlin.collections.HashSet_init_287e2$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var ArrayDeque_init = Kotlin.kotlin.collections.ArrayDeque_init_mqih57$;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var plus = Kotlin.kotlin.collections.plus_qloxvw$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var Map = Kotlin.kotlin.collections.Map;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var RuntimeException = Kotlin.kotlin.RuntimeException;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init;
  var RuntimeException_init_0 = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var math = Kotlin.kotlin.math;
  Zcam$LuminanceSource.prototype = Object.create(Enum.prototype);
  Zcam$LuminanceSource.prototype.constructor = Zcam$LuminanceSource;
  Zcam$ChromaSource.prototype = Object.create(Enum.prototype);
  Zcam$ChromaSource.prototype.constructor = Zcam$ChromaSource;
  LchGamut$ClipMethod.prototype = Object.create(Enum.prototype);
  LchGamut$ClipMethod.prototype.constructor = LchGamut$ClipMethod;
  OklabGamut$ClipMethod.prototype = Object.create(Enum.prototype);
  OklabGamut$ClipMethod.prototype.constructor = OklabGamut$ClipMethod;
  OklabGamut$SaturationCoefficients.prototype = Object.create(Enum.prototype);
  OklabGamut$SaturationCoefficients.prototype.constructor = OklabGamut$SaturationCoefficients;
  UnsupportedConversionException.prototype = Object.create(RuntimeException.prototype);
  UnsupportedConversionException.prototype.constructor = UnsupportedConversionException;
  function Color() {
    Color$Companion_getInstance();
  }
  function Color$Companion() {
    Color$Companion_instance = this;
    this.pathCache_0 = HashMap_init();
    registerAllColors();
  }
  Color$Companion.prototype.convert_81ts6v$ = defineInlineFunction('colorkt.dev.kdrag0n.colorkt.Color.Companion.convert_81ts6v$', wrapFunction(function () {
    var getKClass = Kotlin.getKClass;
    var throwCCE = Kotlin.throwCCE;
    var UnsupportedConversionException_init = _.dev.kdrag0n.colorkt.util.conversion.UnsupportedConversionException_init_61zpoe$;
    return function (T_0, isT, $receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      tmp$_2 = (tmp$_1 = isT(tmp$ = $receiver) ? tmp$ : null) != null ? tmp$_1 : (tmp$_0 = this.convert_ejw624$($receiver, getKClass(T_0))) == null || isT(tmp$_0) ? tmp$_0 : throwCCE();
      if (tmp$_2 == null) {
        throw UnsupportedConversionException_init('No conversion path from ' + Kotlin.getKClassFromExpression($receiver) + ' to ' + getKClass(T_0));
      }return tmp$_2;
    };
  }));
  Color$Companion.prototype.convert_ejw624$ = function (fromColor, toType) {
    var tmp$, tmp$_0, tmp$_1;
    var pathKey = to(Kotlin.getKClassFromExpression(fromColor), toType);
    var tmp$_2;
    if ((tmp$_0 = this.pathCache_0.get_11rb$(pathKey)) != null)
      tmp$_2 = tmp$_0;
    else {
      var tmp$_3;
      if ((tmp$ = ConversionGraph_getInstance().findPath_f4nrtl$(Kotlin.getKClassFromExpression(fromColor), toType)) != null) {
        this.pathCache_0.put_xwzc9p$(pathKey, tmp$);
        tmp$_3 = tmp$;
      } else
        tmp$_3 = null;
      tmp$_2 = tmp$_3;
    }
    tmp$_1 = tmp$_2;
    if (tmp$_1 == null) {
      return null;
    }var path = tmp$_1;
    var tmp$_4;
    var accumulator = fromColor;
    tmp$_4 = path.iterator();
    while (tmp$_4.hasNext()) {
      var element = tmp$_4.next();
      accumulator = element.convert_s97y55$(accumulator);
    }
    return accumulator;
  };
  Color$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Color$Companion_instance = null;
  function Color$Companion_getInstance() {
    if (Color$Companion_instance === null) {
      new Color$Companion();
    }return Color$Companion_instance;
  }
  Color.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Color',
    interfaces: []
  };
  function registerAllColors() {
    LinearSrgb$Companion_getInstance().register_8be2vx$();
    CieXyz$Companion_getInstance().register_8be2vx$();
    CieXyzAbs$Companion_getInstance().register_8be2vx$();
    CieLab$Companion_getInstance().register_8be2vx$();
    Oklab$Companion_getInstance().register_8be2vx$();
    Srlab2$Companion_getInstance().register_8be2vx$();
    CieLch$Companion_getInstance().register_8be2vx$();
    Oklch$Companion_getInstance().register_8be2vx$();
    Srlch2$Companion_getInstance().register_8be2vx$();
  }
  function Zcam(brightness, lightness, colorfulness, chroma, hue, saturation, vividness, blackness, whiteness, viewingConditions) {
    Zcam$Companion_getInstance();
    if (brightness === void 0)
      brightness = kotlin_js_internal_DoubleCompanionObject.NaN;
    if (lightness === void 0)
      lightness = kotlin_js_internal_DoubleCompanionObject.NaN;
    if (colorfulness === void 0)
      colorfulness = kotlin_js_internal_DoubleCompanionObject.NaN;
    if (chroma === void 0)
      chroma = kotlin_js_internal_DoubleCompanionObject.NaN;
    if (saturation === void 0)
      saturation = kotlin_js_internal_DoubleCompanionObject.NaN;
    if (vividness === void 0)
      vividness = kotlin_js_internal_DoubleCompanionObject.NaN;
    if (blackness === void 0)
      blackness = kotlin_js_internal_DoubleCompanionObject.NaN;
    if (whiteness === void 0)
      whiteness = kotlin_js_internal_DoubleCompanionObject.NaN;
    this.brightness = brightness;
    this.lightness_k5x8it$_0 = lightness;
    this.colorfulness = colorfulness;
    this.chroma_pkpu5m$_0 = chroma;
    this.hue_1ps3cg$_0 = hue;
    this.saturation = saturation;
    this.vividness = vividness;
    this.blackness = blackness;
    this.whiteness = whiteness;
    this.viewingConditions = viewingConditions;
  }
  Object.defineProperty(Zcam.prototype, 'lightness', {
    get: function () {
      return this.lightness_k5x8it$_0;
    }
  });
  Object.defineProperty(Zcam.prototype, 'chroma', {
    get: function () {
      return this.chroma_pkpu5m$_0;
    }
  });
  Object.defineProperty(Zcam.prototype, 'hue', {
    get: function () {
      return this.hue_1ps3cg$_0;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Qz', {
    configurable: true,
    get: function () {
      return this.brightness;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Jz', {
    configurable: true,
    get: function () {
      return this.lightness;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Mz', {
    configurable: true,
    get: function () {
      return this.colorfulness;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Cz', {
    configurable: true,
    get: function () {
      return this.chroma;
    }
  });
  Object.defineProperty(Zcam.prototype, 'hz', {
    configurable: true,
    get: function () {
      return this.hue;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Sz', {
    configurable: true,
    get: function () {
      return this.saturation;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Vz', {
    configurable: true,
    get: function () {
      return this.vividness;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Kz', {
    configurable: true,
    get: function () {
      return this.blackness;
    }
  });
  Object.defineProperty(Zcam.prototype, 'Wz', {
    configurable: true,
    get: function () {
      return this.whiteness;
    }
  });
  Zcam.prototype.toXyzAbs_nenmwo$ = function (luminanceSource, chromaSource) {
    var tmp$, tmp$_0, tmp$_1;
    var cond = this.viewingConditions;
    var Qz_w = cond.Qz_w_8be2vx$;
    switch (luminanceSource.name) {
      case 'BRIGHTNESS':
        tmp$ = this.Qz / cond.Iz_coeff_8be2vx$;
        break;
      case 'LIGHTNESS':
        tmp$ = this.Jz * Qz_w / (cond.Iz_coeff_8be2vx$ * 100.0);
        break;
      default:tmp$ = Kotlin.noWhenBranchMatched();
        break;
    }
    var $receiver = tmp$;
    var x = cond.Qz_denom_8be2vx$ / (1.6 * cond.surroundFactor);
    var Iz = JsMath.pow($receiver, x);
    switch (chromaSource.name) {
      case 'CHROMA':
        tmp$_0 = this.Cz;
        break;
      case 'COLORFULNESS':
        tmp$_0 = kotlin_js_internal_DoubleCompanionObject.NaN;
        break;
      case 'SATURATION':
        var tmp$_2 = this.Qz;
        var x_0 = this.Sz;
        tmp$_0 = tmp$_2 * (x_0 * x_0) / (100.0 * Qz_w * cond.Qz_denom_8be2vx$);
        break;
      case 'VIVIDNESS':
        var x_1 = this.Vz;
        var tmp$_3 = x_1 * x_1;
        var x_2 = this.Jz - 58;
        var x_3 = (tmp$_3 - x_2 * x_2) / 3.4;
        tmp$_0 = JsMath.sqrt(x_3);
        break;
      case 'BLACKNESS':
        var x_4 = (100 - this.Kz) / 0.8;
        var tmp$_4 = x_4 * x_4;
        var x_5 = this.Jz;
        var x_6 = (tmp$_4 - x_5 * x_5) / 8;
        tmp$_0 = JsMath.sqrt(x_6);
        break;
      case 'WHITENESS':
        var x_7 = 100.0 - this.Wz;
        var tmp$_5 = x_7 * x_7;
        var x_8 = 100.0 - this.Jz;
        var x_9 = tmp$_5 - x_8 * x_8;
        tmp$_0 = JsMath.sqrt(x_9);
        break;
      default:tmp$_0 = Kotlin.noWhenBranchMatched();
        break;
    }
    var Cz = tmp$_0;
    if (equals(chromaSource, Zcam$ChromaSource$COLORFULNESS_getInstance()))
      tmp$_1 = this.Mz;
    else
      tmp$_1 = Cz * Qz_w / 100;
    var Mz = tmp$_1;
    var ez = Zcam$Companion_getInstance().hpToEz_0(this.hz);
    var $receiver_0 = Mz * cond.Mz_denom_8be2vx$ / (100.0 * JsMath.pow(ez, 0.068) * cond.ez_coeff_8be2vx$);
    var x_10 = 1.0 / 0.37 / 2;
    var Cz_p = JsMath.pow($receiver_0, x_10);
    var hzRad = toRadians(this.hz);
    var az = Cz_p * JsMath.cos(hzRad);
    var bz = Cz_p * JsMath.sin(hzRad);
    var I = Iz + Zcam$Companion_getInstance().EPSILON_0;
    var r = Zcam$Companion_getInstance().pqInv_0(I + 0.2772100865 * az + 0.1160946323 * bz);
    var g = Zcam$Companion_getInstance().pqInv_0(I);
    var b = Zcam$Companion_getInstance().pqInv_0(I + 0.0425858012 * az + -0.7538445799 * bz);
    var xp = 1.9242264358 * r + -1.0047923126 * g + 0.037651404 * b;
    var yp = 0.3503167621 * r + 0.7264811939 * g + -0.0653844229 * b;
    var z = -0.090982811 * r + -0.3127282905 * g + 1.5227665613 * b;
    var x_11 = (xp + (Zcam$Companion_getInstance().B_0 - 1) * z) / Zcam$Companion_getInstance().B_0;
    var y = (yp + (Zcam$Companion_getInstance().G_0 - 1) * x_11) / Zcam$Companion_getInstance().G_0;
    return new CieXyzAbs(x_11, y, z);
  };
  function Zcam$LuminanceSource(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Zcam$LuminanceSource_initFields() {
    Zcam$LuminanceSource_initFields = function () {
    };
    Zcam$LuminanceSource$BRIGHTNESS_instance = new Zcam$LuminanceSource('BRIGHTNESS', 0);
    Zcam$LuminanceSource$LIGHTNESS_instance = new Zcam$LuminanceSource('LIGHTNESS', 1);
  }
  var Zcam$LuminanceSource$BRIGHTNESS_instance;
  function Zcam$LuminanceSource$BRIGHTNESS_getInstance() {
    Zcam$LuminanceSource_initFields();
    return Zcam$LuminanceSource$BRIGHTNESS_instance;
  }
  var Zcam$LuminanceSource$LIGHTNESS_instance;
  function Zcam$LuminanceSource$LIGHTNESS_getInstance() {
    Zcam$LuminanceSource_initFields();
    return Zcam$LuminanceSource$LIGHTNESS_instance;
  }
  Zcam$LuminanceSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LuminanceSource',
    interfaces: [Enum]
  };
  function Zcam$LuminanceSource$values() {
    return [Zcam$LuminanceSource$BRIGHTNESS_getInstance(), Zcam$LuminanceSource$LIGHTNESS_getInstance()];
  }
  Zcam$LuminanceSource.values = Zcam$LuminanceSource$values;
  function Zcam$LuminanceSource$valueOf(name) {
    switch (name) {
      case 'BRIGHTNESS':
        return Zcam$LuminanceSource$BRIGHTNESS_getInstance();
      case 'LIGHTNESS':
        return Zcam$LuminanceSource$LIGHTNESS_getInstance();
      default:throwISE('No enum constant dev.kdrag0n.colorkt.cam.Zcam.LuminanceSource.' + name);
    }
  }
  Zcam$LuminanceSource.valueOf_61zpoe$ = Zcam$LuminanceSource$valueOf;
  function Zcam$ChromaSource(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Zcam$ChromaSource_initFields() {
    Zcam$ChromaSource_initFields = function () {
    };
    Zcam$ChromaSource$CHROMA_instance = new Zcam$ChromaSource('CHROMA', 0);
    Zcam$ChromaSource$COLORFULNESS_instance = new Zcam$ChromaSource('COLORFULNESS', 1);
    Zcam$ChromaSource$SATURATION_instance = new Zcam$ChromaSource('SATURATION', 2);
    Zcam$ChromaSource$VIVIDNESS_instance = new Zcam$ChromaSource('VIVIDNESS', 3);
    Zcam$ChromaSource$BLACKNESS_instance = new Zcam$ChromaSource('BLACKNESS', 4);
    Zcam$ChromaSource$WHITENESS_instance = new Zcam$ChromaSource('WHITENESS', 5);
  }
  var Zcam$ChromaSource$CHROMA_instance;
  function Zcam$ChromaSource$CHROMA_getInstance() {
    Zcam$ChromaSource_initFields();
    return Zcam$ChromaSource$CHROMA_instance;
  }
  var Zcam$ChromaSource$COLORFULNESS_instance;
  function Zcam$ChromaSource$COLORFULNESS_getInstance() {
    Zcam$ChromaSource_initFields();
    return Zcam$ChromaSource$COLORFULNESS_instance;
  }
  var Zcam$ChromaSource$SATURATION_instance;
  function Zcam$ChromaSource$SATURATION_getInstance() {
    Zcam$ChromaSource_initFields();
    return Zcam$ChromaSource$SATURATION_instance;
  }
  var Zcam$ChromaSource$VIVIDNESS_instance;
  function Zcam$ChromaSource$VIVIDNESS_getInstance() {
    Zcam$ChromaSource_initFields();
    return Zcam$ChromaSource$VIVIDNESS_instance;
  }
  var Zcam$ChromaSource$BLACKNESS_instance;
  function Zcam$ChromaSource$BLACKNESS_getInstance() {
    Zcam$ChromaSource_initFields();
    return Zcam$ChromaSource$BLACKNESS_instance;
  }
  var Zcam$ChromaSource$WHITENESS_instance;
  function Zcam$ChromaSource$WHITENESS_getInstance() {
    Zcam$ChromaSource_initFields();
    return Zcam$ChromaSource$WHITENESS_instance;
  }
  Zcam$ChromaSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChromaSource',
    interfaces: [Enum]
  };
  function Zcam$ChromaSource$values() {
    return [Zcam$ChromaSource$CHROMA_getInstance(), Zcam$ChromaSource$COLORFULNESS_getInstance(), Zcam$ChromaSource$SATURATION_getInstance(), Zcam$ChromaSource$VIVIDNESS_getInstance(), Zcam$ChromaSource$BLACKNESS_getInstance(), Zcam$ChromaSource$WHITENESS_getInstance()];
  }
  Zcam$ChromaSource.values = Zcam$ChromaSource$values;
  function Zcam$ChromaSource$valueOf(name) {
    switch (name) {
      case 'CHROMA':
        return Zcam$ChromaSource$CHROMA_getInstance();
      case 'COLORFULNESS':
        return Zcam$ChromaSource$COLORFULNESS_getInstance();
      case 'SATURATION':
        return Zcam$ChromaSource$SATURATION_getInstance();
      case 'VIVIDNESS':
        return Zcam$ChromaSource$VIVIDNESS_getInstance();
      case 'BLACKNESS':
        return Zcam$ChromaSource$BLACKNESS_getInstance();
      case 'WHITENESS':
        return Zcam$ChromaSource$WHITENESS_getInstance();
      default:throwISE('No enum constant dev.kdrag0n.colorkt.cam.Zcam.ChromaSource.' + name);
    }
  }
  Zcam$ChromaSource.valueOf_61zpoe$ = Zcam$ChromaSource$valueOf;
  function Zcam$ViewingConditions(surroundFactor, adaptingLuminance, backgroundLuminance, referenceWhite) {
    Zcam$ViewingConditions$Companion_getInstance();
    this.surroundFactor = surroundFactor;
    this.adaptingLuminance = adaptingLuminance;
    this.backgroundLuminance = backgroundLuminance;
    this.referenceWhite = referenceWhite;
    this.Iz_coeff_8be2vx$ = 0;
    this.ez_coeff_8be2vx$ = 0;
    this.Qz_denom_8be2vx$ = 0;
    this.Sz_coeff_8be2vx$ = 0;
    this.Mz_denom_8be2vx$ = 0;
    this.Qz_w_8be2vx$ = 0;
    var x = this.backgroundLuminance / this.referenceWhite.y;
    var F_b = JsMath.sqrt(x);
    var tmp$ = 0.171 * cbrt(this.adaptingLuminance);
    var x_0 = -48.0 / 9.0 * this.adaptingLuminance;
    var F_l = tmp$ * (1.0 - JsMath.exp(x_0));
    var $receiver = this.surroundFactor;
    this.Iz_coeff_8be2vx$ = 2700.0 * JsMath.pow($receiver, 2.2) * JsMath.pow(F_b, 0.5) * JsMath.pow(F_l, 0.2);
    this.ez_coeff_8be2vx$ = JsMath.pow(F_l, 0.2);
    this.Qz_denom_8be2vx$ = JsMath.pow(F_b, 0.12);
    this.Sz_coeff_8be2vx$ = JsMath.pow(F_l, 0.6);
    var Iz_w = Zcam$Companion_getInstance().xyzToIzazbz_0(this.referenceWhite)[0];
    this.Mz_denom_8be2vx$ = JsMath.pow(Iz_w, 0.78) * JsMath.pow(F_b, 0.1);
    this.Qz_w_8be2vx$ = Zcam$Companion_getInstance().izToQz_0(Iz_w, this);
  }
  function Zcam$ViewingConditions$Companion() {
    Zcam$ViewingConditions$Companion_instance = this;
    this.SURROUND_DARK = 0.525;
    this.SURROUND_DIM = 0.59;
    this.SURROUND_AVERAGE = 0.69;
  }
  Zcam$ViewingConditions$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Zcam$ViewingConditions$Companion_instance = null;
  function Zcam$ViewingConditions$Companion_getInstance() {
    if (Zcam$ViewingConditions$Companion_instance === null) {
      new Zcam$ViewingConditions$Companion();
    }return Zcam$ViewingConditions$Companion_instance;
  }
  Zcam$ViewingConditions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ViewingConditions',
    interfaces: []
  };
  Zcam$ViewingConditions.prototype.component1 = function () {
    return this.surroundFactor;
  };
  Zcam$ViewingConditions.prototype.component2 = function () {
    return this.adaptingLuminance;
  };
  Zcam$ViewingConditions.prototype.component3 = function () {
    return this.backgroundLuminance;
  };
  Zcam$ViewingConditions.prototype.component4 = function () {
    return this.referenceWhite;
  };
  Zcam$ViewingConditions.prototype.copy_3q37sp$ = function (surroundFactor, adaptingLuminance, backgroundLuminance, referenceWhite) {
    return new Zcam$ViewingConditions(surroundFactor === void 0 ? this.surroundFactor : surroundFactor, adaptingLuminance === void 0 ? this.adaptingLuminance : adaptingLuminance, backgroundLuminance === void 0 ? this.backgroundLuminance : backgroundLuminance, referenceWhite === void 0 ? this.referenceWhite : referenceWhite);
  };
  Zcam$ViewingConditions.prototype.toString = function () {
    return 'ViewingConditions(surroundFactor=' + Kotlin.toString(this.surroundFactor) + (', adaptingLuminance=' + Kotlin.toString(this.adaptingLuminance)) + (', backgroundLuminance=' + Kotlin.toString(this.backgroundLuminance)) + (', referenceWhite=' + Kotlin.toString(this.referenceWhite)) + ')';
  };
  Zcam$ViewingConditions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.surroundFactor) | 0;
    result = result * 31 + Kotlin.hashCode(this.adaptingLuminance) | 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundLuminance) | 0;
    result = result * 31 + Kotlin.hashCode(this.referenceWhite) | 0;
    return result;
  };
  Zcam$ViewingConditions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.surroundFactor, other.surroundFactor) && Kotlin.equals(this.adaptingLuminance, other.adaptingLuminance) && Kotlin.equals(this.backgroundLuminance, other.backgroundLuminance) && Kotlin.equals(this.referenceWhite, other.referenceWhite)))));
  };
  function Zcam$Companion() {
    Zcam$Companion_instance = this;
    this.B_0 = 1.15;
    this.G_0 = 0.66;
    this.C1_0 = 3424.0 / 4096;
    this.C2_0 = 2413.0 / 128;
    this.C3_0 = 2392.0 / 128;
    this.ETA_0 = 2610.0 / 16384;
    this.RHO_0 = 1.7 * 2523.0 / 32;
    this.EPSILON_0 = 3.7035226210190005E-11;
  }
  Zcam$Companion.prototype.pq_0 = function (x) {
    var tmp$ = this.C1_0;
    var tmp$_0 = this.C2_0;
    var $receiver = x / 10000;
    var x_0 = this.ETA_0;
    var num = tmp$ + tmp$_0 * JsMath.pow($receiver, x_0);
    var tmp$_1 = this.C3_0;
    var $receiver_0 = x / 10000;
    var x_1 = this.ETA_0;
    var denom = 1.0 + tmp$_1 * JsMath.pow($receiver_0, x_1);
    var $receiver_1 = num / denom;
    var x_2 = this.RHO_0;
    return JsMath.pow($receiver_1, x_2);
  };
  Zcam$Companion.prototype.pqInv_0 = function (x) {
    var tmp$ = this.C1_0;
    var x_0 = 1.0 / this.RHO_0;
    var num = tmp$ - JsMath.pow(x, x_0);
    var tmp$_0 = this.C3_0;
    var x_1 = 1.0 / this.RHO_0;
    var denom = tmp$_0 * JsMath.pow(x, x_1) - this.C2_0;
    var $receiver = num / denom;
    var x_2 = 1.0 / this.ETA_0;
    return 10000.0 * JsMath.pow($receiver, x_2);
  };
  Zcam$Companion.prototype.xyzToIzazbz_0 = function (xyz) {
    var xp = this.B_0 * xyz.x - (this.B_0 - 1) * xyz.z;
    var yp = this.G_0 * xyz.y - (this.G_0 - 1) * xyz.x;
    var rp = this.pq_0(0.41478972 * xp + 0.579999 * yp + 0.014648 * xyz.z);
    var gp = this.pq_0(-0.20151 * xp + 1.120649 * yp + 0.0531008 * xyz.z);
    var bp = this.pq_0(-0.0166008 * xp + 0.2648 * yp + 0.6684799 * xyz.z);
    var az = 3.524 * rp + -4.066708 * gp + 0.542708 * bp;
    var bz = 0.199076 * rp + 1.096799 * gp + -1.295875 * bp;
    var Iz = gp - this.EPSILON_0;
    return new Float64Array([Iz, az, bz]);
  };
  Zcam$Companion.prototype.hpToEz_0 = function (hp) {
    var x = toRadians(89.038 + hp);
    return 1.015 + JsMath.cos(x);
  };
  Zcam$Companion.prototype.izToQz_0 = function (Iz, cond) {
    var tmp$ = cond.Iz_coeff_8be2vx$;
    var x = 1.6 * cond.surroundFactor / cond.Qz_denom_8be2vx$;
    return tmp$ * JsMath.pow(Iz, x);
  };
  Zcam$Companion.prototype.toZcam_jpksxg$ = function ($receiver, cond, include2D) {
    if (include2D === void 0)
      include2D = true;
    var tmp$ = this.xyzToIzazbz_0($receiver);
    var Iz = tmp$[0];
    var az = tmp$[1];
    var bz = tmp$[2];
    var hzRaw = toDegrees(JsMath.atan2(bz, az));
    var hz = hzRaw < 0 ? hzRaw + 360 : hzRaw;
    var ez = this.hpToEz_0(hz);
    var Qz = this.izToQz_0(Iz, cond);
    var Qz_w = cond.Qz_w_8be2vx$;
    var Jz = 100.0 * (Qz / Qz_w);
    var $receiver_0 = az * az + bz * bz;
    var Mz = 100.0 * JsMath.pow($receiver_0, 0.37) * (JsMath.pow(ez, 0.068) * cond.ez_coeff_8be2vx$ / cond.Mz_denom_8be2vx$);
    var Cz = 100.0 * (Mz / Qz_w);
    var tmp$_0;
    if (include2D) {
      var tmp$_1 = 100.0 * cond.Sz_coeff_8be2vx$;
      var x = Mz / Qz;
      tmp$_0 = tmp$_1 * JsMath.sqrt(x);
    } else
      tmp$_0 = kotlin_js_internal_DoubleCompanionObject.NaN;
    var Sz = tmp$_0;
    var tmp$_2;
    if (include2D) {
      var x_0 = Jz - 58;
      var x_1 = x_0 * x_0 + 3.4 * (Cz * Cz);
      tmp$_2 = JsMath.sqrt(x_1);
    } else
      tmp$_2 = kotlin_js_internal_DoubleCompanionObject.NaN;
    var Vz = tmp$_2;
    var tmp$_3;
    if (include2D) {
      var x_2 = Jz * Jz + 8.0 * (Cz * Cz);
      tmp$_3 = 100.0 - 0.8 * JsMath.sqrt(x_2);
    } else
      tmp$_3 = kotlin_js_internal_DoubleCompanionObject.NaN;
    var Kz = tmp$_3;
    var tmp$_4;
    if (include2D) {
      var x_3 = 100.0 - Jz;
      var x_4 = x_3 * x_3 + Cz * Cz;
      tmp$_4 = 100.0 - JsMath.sqrt(x_4);
    } else
      tmp$_4 = kotlin_js_internal_DoubleCompanionObject.NaN;
    var Wz = tmp$_4;
    return new Zcam(Qz, Jz, Mz, Cz, hz, Sz, Vz, Kz, Wz, cond);
  };
  Zcam$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Zcam$Companion_instance = null;
  function Zcam$Companion_getInstance() {
    if (Zcam$Companion_instance === null) {
      new Zcam$Companion();
    }return Zcam$Companion_instance;
  }
  Zcam.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Zcam',
    interfaces: [Lch, Color]
  };
  Zcam.prototype.component1 = function () {
    return this.brightness;
  };
  Zcam.prototype.component2 = function () {
    return this.lightness;
  };
  Zcam.prototype.component3 = function () {
    return this.colorfulness;
  };
  Zcam.prototype.component4 = function () {
    return this.chroma;
  };
  Zcam.prototype.component5 = function () {
    return this.hue;
  };
  Zcam.prototype.component6 = function () {
    return this.saturation;
  };
  Zcam.prototype.component7 = function () {
    return this.vividness;
  };
  Zcam.prototype.component8 = function () {
    return this.blackness;
  };
  Zcam.prototype.component9 = function () {
    return this.whiteness;
  };
  Zcam.prototype.component10 = function () {
    return this.viewingConditions;
  };
  Zcam.prototype.copy_kxntad$ = function (brightness, lightness, colorfulness, chroma, hue, saturation, vividness, blackness, whiteness, viewingConditions) {
    return new Zcam(brightness === void 0 ? this.brightness : brightness, lightness === void 0 ? this.lightness : lightness, colorfulness === void 0 ? this.colorfulness : colorfulness, chroma === void 0 ? this.chroma : chroma, hue === void 0 ? this.hue : hue, saturation === void 0 ? this.saturation : saturation, vividness === void 0 ? this.vividness : vividness, blackness === void 0 ? this.blackness : blackness, whiteness === void 0 ? this.whiteness : whiteness, viewingConditions === void 0 ? this.viewingConditions : viewingConditions);
  };
  Zcam.prototype.toString = function () {
    return 'Zcam(brightness=' + Kotlin.toString(this.brightness) + (', lightness=' + Kotlin.toString(this.lightness)) + (', colorfulness=' + Kotlin.toString(this.colorfulness)) + (', chroma=' + Kotlin.toString(this.chroma)) + (', hue=' + Kotlin.toString(this.hue)) + (', saturation=' + Kotlin.toString(this.saturation)) + (', vividness=' + Kotlin.toString(this.vividness)) + (', blackness=' + Kotlin.toString(this.blackness)) + (', whiteness=' + Kotlin.toString(this.whiteness)) + (', viewingConditions=' + Kotlin.toString(this.viewingConditions)) + ')';
  };
  Zcam.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.brightness) | 0;
    result = result * 31 + Kotlin.hashCode(this.lightness) | 0;
    result = result * 31 + Kotlin.hashCode(this.colorfulness) | 0;
    result = result * 31 + Kotlin.hashCode(this.chroma) | 0;
    result = result * 31 + Kotlin.hashCode(this.hue) | 0;
    result = result * 31 + Kotlin.hashCode(this.saturation) | 0;
    result = result * 31 + Kotlin.hashCode(this.vividness) | 0;
    result = result * 31 + Kotlin.hashCode(this.blackness) | 0;
    result = result * 31 + Kotlin.hashCode(this.whiteness) | 0;
    result = result * 31 + Kotlin.hashCode(this.viewingConditions) | 0;
    return result;
  };
  Zcam.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.brightness, other.brightness) && Kotlin.equals(this.lightness, other.lightness) && Kotlin.equals(this.colorfulness, other.colorfulness) && Kotlin.equals(this.chroma, other.chroma) && Kotlin.equals(this.hue, other.hue) && Kotlin.equals(this.saturation, other.saturation) && Kotlin.equals(this.vividness, other.vividness) && Kotlin.equals(this.blackness, other.blackness) && Kotlin.equals(this.whiteness, other.whiteness) && Kotlin.equals(this.viewingConditions, other.viewingConditions)))));
  };
  function Illuminants() {
    Illuminants_instance = this;
    this.D65 = new CieXyz(this.xyToX_0(0.3127, 0.329), 1.0, this.xyToZ_0(0.3127, 0.329));
    this.D65_ASTM = new CieXyz(0.95047, 1.0, 1.08883);
    this.D65_CIE = new CieXyz(0.9504705586542832, 1.0, 1.088828736395884);
    this.D50 = new CieXyz(this.xyToX_0(0.3457, 0.3585), 1.0, this.xyToZ_0(0.3457, 0.3585));
  }
  Illuminants.prototype.xyToX_0 = function (x, y) {
    return x / y;
  };
  Illuminants.prototype.xyToZ_0 = function (x, y) {
    return (1.0 - x - y) / y;
  };
  Illuminants.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Illuminants',
    interfaces: []
  };
  var Illuminants_instance = null;
  function Illuminants_getInstance() {
    if (Illuminants_instance === null) {
      new Illuminants();
    }return Illuminants_instance;
  }
  function LchFactory(f) {
    this.function$ = f;
  }
  LchFactory.prototype.getColor_yvo9jy$ = function (lightness, chroma, hue) {
    return this.function$(lightness, chroma, hue);
  };
  LchFactory.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'LchFactory',
    interfaces: []
  };
  function LchGamut() {
    LchGamut_instance = this;
    this.EPSILON_100_0 = 1.0E-4;
  }
  LchGamut.prototype.evalLine_0 = function (slope, intercept, x) {
    return slope * x + intercept;
  };
  LchGamut.prototype.clip_0 = function (l1, c1, hue, l0, epsilon, maxLightness, factory) {
    var tmp$;
    var result = factory.getColor_yvo9jy$(l1, c1, hue);
    if (result.isInGamut())
      tmp$ = result;
    else if (l1 <= epsilon)
      tmp$ = new LinearSrgb(0.0, 0.0, 0.0);
    else if (l1 >= maxLightness - epsilon)
      tmp$ = new LinearSrgb(1.0, 1.0, 1.0);
    else {
      var c0 = 0.0;
      var slope = (l1 - l0) / (c1 - c0);
      var intercept = l0 - slope * c0;
      var lo = 0.0;
      var hi = c1;
      while (true) {
        var x = hi - lo;
        if (!(JsMath.abs(x) > epsilon))
          break;
        var midC = (lo + hi) / 2;
        var midL = this.evalLine_0(slope, intercept, midC);
        result = factory.getColor_yvo9jy$(midL, midC, hue);
        if (!result.isInGamut()) {
          hi = midC;
        } else {
          var midC2 = midC + epsilon;
          var midL2 = this.evalLine_0(slope, intercept, midC2);
          var ptOutside = factory.getColor_yvo9jy$(midL2, midC2, hue);
          if (ptOutside.isInGamut()) {
            lo = midC;
          } else {
            break;
          }
        }
      }
      tmp$ = result;
    }
    return tmp$;
  };
  function LchGamut$clipToLinearSrgb$lambda(this$clipToLinearSrgb) {
    return function (l, c, h) {
      return (new Zcam(void 0, l, void 0, c, h, void 0, void 0, void 0, void 0, this$clipToLinearSrgb.viewingConditions)).toXyzAbs_nenmwo$(Zcam$LuminanceSource$LIGHTNESS_getInstance(), Zcam$ChromaSource$CHROMA_getInstance()).toRel_14dthe$(this$clipToLinearSrgb.viewingConditions.referenceWhite.y).toLinearSrgb();
    };
  }
  LchGamut.prototype.clipToLinearSrgb_8s4f7r$ = function ($receiver, method, alpha) {
    if (method === void 0)
      method = LchGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance();
    if (alpha === void 0)
      alpha = 0.05;
    var tmp$;
    switch (method.name) {
      case 'PRESERVE_LIGHTNESS':
        tmp$ = $receiver.lightness;
        break;
      case 'PROJECT_TO_MID':
        tmp$ = 50.0;
        break;
      case 'ADAPTIVE_TOWARDS_MID':
        tmp$ = OklabGamut_getInstance().calcAdaptiveMidL_hln2n9$($receiver.lightness / 100.0, $receiver.chroma / 100.0, alpha) * 100.0;
        break;
      default:tmp$ = Kotlin.noWhenBranchMatched();
        break;
    }
    var l0 = tmp$;
    return this.clip_0($receiver.lightness, $receiver.chroma, $receiver.hue, l0, this.EPSILON_100_0, 100.0, new LchFactory(LchGamut$clipToLinearSrgb$lambda($receiver)));
  };
  function LchGamut$ClipMethod(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function LchGamut$ClipMethod_initFields() {
    LchGamut$ClipMethod_initFields = function () {
    };
    LchGamut$ClipMethod$PRESERVE_LIGHTNESS_instance = new LchGamut$ClipMethod('PRESERVE_LIGHTNESS', 0);
    LchGamut$ClipMethod$PROJECT_TO_MID_instance = new LchGamut$ClipMethod('PROJECT_TO_MID', 1);
    LchGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_instance = new LchGamut$ClipMethod('ADAPTIVE_TOWARDS_MID', 2);
  }
  var LchGamut$ClipMethod$PRESERVE_LIGHTNESS_instance;
  function LchGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance() {
    LchGamut$ClipMethod_initFields();
    return LchGamut$ClipMethod$PRESERVE_LIGHTNESS_instance;
  }
  var LchGamut$ClipMethod$PROJECT_TO_MID_instance;
  function LchGamut$ClipMethod$PROJECT_TO_MID_getInstance() {
    LchGamut$ClipMethod_initFields();
    return LchGamut$ClipMethod$PROJECT_TO_MID_instance;
  }
  var LchGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_instance;
  function LchGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance() {
    LchGamut$ClipMethod_initFields();
    return LchGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_instance;
  }
  LchGamut$ClipMethod.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ClipMethod',
    interfaces: [Enum]
  };
  function LchGamut$ClipMethod$values() {
    return [LchGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance(), LchGamut$ClipMethod$PROJECT_TO_MID_getInstance(), LchGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance()];
  }
  LchGamut$ClipMethod.values = LchGamut$ClipMethod$values;
  function LchGamut$ClipMethod$valueOf(name) {
    switch (name) {
      case 'PRESERVE_LIGHTNESS':
        return LchGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance();
      case 'PROJECT_TO_MID':
        return LchGamut$ClipMethod$PROJECT_TO_MID_getInstance();
      case 'ADAPTIVE_TOWARDS_MID':
        return LchGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance();
      default:throwISE('No enum constant dev.kdrag0n.colorkt.gamut.LchGamut.ClipMethod.' + name);
    }
  }
  LchGamut$ClipMethod.valueOf_61zpoe$ = LchGamut$ClipMethod$valueOf;
  LchGamut.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'LchGamut',
    interfaces: []
  };
  var LchGamut_instance = null;
  function LchGamut_getInstance() {
    if (LchGamut_instance === null) {
      new LchGamut();
    }return LchGamut_instance;
  }
  function OklabGamut() {
    OklabGamut_instance = this;
    this.CLIP_EPSILON_0 = 1.0E-5;
  }
  OklabGamut.prototype.computeMaxSaturation_0 = function (a, b) {
    var tmp$;
    if (-1.88170328 * a - 0.80936493 * b > 1)
      tmp$ = OklabGamut$SaturationCoefficients$RED_getInstance();
    else if (1.81444104 * a - 1.19445276 * b > 1)
      tmp$ = OklabGamut$SaturationCoefficients$GREEN_getInstance();
    else
      tmp$ = OklabGamut$SaturationCoefficients$BLUE_getInstance();
    var coeff = tmp$;
    var S = coeff.k0 + coeff.k1 * a + coeff.k2 * b + coeff.k3 * a * a + coeff.k4 * a * b;
    var k_l = +0.3963377774 * a + 0.2158037573 * b;
    var k_m = -0.1055613458 * a - 0.0638541728 * b;
    var k_s = -0.0894841775 * a - 1.291485548 * b;
    var l_ = 1 + S * k_l;
    var m_ = 1 + S * k_m;
    var s_ = 1 + S * k_s;
    var l = l_ * l_ * l_;
    var m = m_ * m_ * m_;
    var s = s_ * s_ * s_;
    var l_dS = 3 * k_l * (l_ * l_);
    var m_dS = 3 * k_m * (m_ * m_);
    var s_dS = 3 * k_s * (s_ * s_);
    var l_dS2 = 6 * (k_l * k_l) * l_;
    var m_dS2 = 6 * (k_m * k_m) * m_;
    var s_dS2 = 6 * (k_s * k_s) * s_;
    var f = coeff.wl * l + coeff.wm * m + coeff.ws * s;
    var f1 = coeff.wl * l_dS + coeff.wm * m_dS + coeff.ws * s_dS;
    var f2 = coeff.wl * l_dS2 + coeff.wm * m_dS2 + coeff.ws * s_dS2;
    return S - f * f1 / (f1 * f1 - 0.5 * f * f2);
  };
  OklabGamut.prototype.findCusp_0 = function (a, b) {
    var S_cusp = this.computeMaxSaturation_0(a, b);
    var rgb_at_max = (new Oklab(1.0, S_cusp * a, S_cusp * b)).toLinearSrgb();
    var a_0 = rgb_at_max.r;
    var b_0 = rgb_at_max.g;
    var a_1 = JsMath.max(a_0, b_0);
    var b_1 = rgb_at_max.b;
    var L_cusp = cbrt(1.0 / JsMath.max(a_1, b_1));
    var C_cusp = L_cusp * S_cusp;
    return new OklabGamut$LC(L_cusp, C_cusp);
  };
  OklabGamut.prototype.halleyTerm_0 = function (l, m, s, ldt, mdt, sdt, ldt2, mdt2, sdt2, coeff1, coeff2, coeff3) {
    var n = coeff1 * l + coeff2 * m + coeff3 * s - 1;
    var n1 = coeff1 * ldt + coeff2 * mdt + coeff3 * sdt;
    var n2 = coeff1 * ldt2 + coeff2 * mdt2 + coeff3 * sdt2;
    var u_n = n1 / (n1 * n1 - 0.5 * n * n2);
    var t_n = -n * u_n;
    return u_n >= 0 ? t_n : kotlin_js_internal_DoubleCompanionObject.MAX_VALUE;
  };
  OklabGamut.prototype.findGamutIntersection_0 = function (cusp, a, b, l1, c1, l0) {
    if ((l1 - l0) * cusp.C - (cusp.L - l0) * c1 <= 0) {
      return cusp.C * l0 / (c1 * cusp.L + cusp.C * (l0 - l1));
    }var t = cusp.C * (l0 - 1) / (c1 * (cusp.L - 1) + cusp.C * (l0 - l1));
    var dL = l1 - l0;
    var dC = c1;
    var k_l = +0.3963377774 * a + 0.2158037573 * b;
    var k_m = -0.1055613458 * a - 0.0638541728 * b;
    var k_s = -0.0894841775 * a - 1.291485548 * b;
    var l_dt = dL + dC * k_l;
    var m_dt = dL + dC * k_m;
    var s_dt = dL + dC * k_s;
    var L = l0 * (1.0 - t) + t * l1;
    var C = t * c1;
    var l_ = L + C * k_l;
    var m_ = L + C * k_m;
    var s_ = L + C * k_s;
    var l = l_ * l_ * l_;
    var m = m_ * m_ * m_;
    var s = s_ * s_ * s_;
    var ldt = 3 * l_dt * (l_ * l_);
    var mdt = 3 * m_dt * (m_ * m_);
    var sdt = 3 * s_dt * (s_ * s_);
    var ldt2 = 6 * (l_dt * l_dt) * l_;
    var mdt2 = 6 * (m_dt * m_dt) * m_;
    var sdt2 = 6 * (s_dt * s_dt) * s_;
    var t_r = this.halleyTerm_0(l, m, s, ldt, mdt, sdt, ldt2, mdt2, sdt2, 4.0767416621, -3.3077115913, 0.2309699292);
    var t_g = this.halleyTerm_0(l, m, s, ldt, mdt, sdt, ldt2, mdt2, sdt2, -1.2681437731, 2.6097574011, -0.3413193965);
    var t_b = this.halleyTerm_0(l, m, s, ldt, mdt, sdt, ldt2, mdt2, sdt2, -0.0041960863, -0.7034186147, 1.707614701);
    var b_0 = JsMath.min(t_g, t_b);
    return t + JsMath.min(t_r, b_0);
  };
  OklabGamut.prototype.calcAdaptiveMidL_hln2n9$ = function (L, C, alpha) {
    var Ld = L - 0.5;
    var e1 = 0.5 + JsMath.abs(Ld) + alpha * C;
    var tmp$ = JsMath.sign(Ld);
    var x = e1 * e1 - 2.0 * JsMath.abs(Ld);
    return 0.5 * (1.0 + tmp$ * (e1 - JsMath.sqrt(x)));
  };
  OklabGamut.prototype.clip_0 = function (rgb, method, alpha, oklab) {
    if (alpha === void 0)
      alpha = 0.05;
    if (oklab === void 0)
      oklab = null;
    var tmp$;
    if (rangeTo(0.0, 1.0).contains_mef7kx$(rgb.r) && rangeTo(0.0, 1.0).contains_mef7kx$(rgb.g) && rangeTo(0.0, 1.0).contains_mef7kx$(rgb.b)) {
      return rgb;
    }var lab = oklab != null ? oklab : Oklab$Companion_getInstance().toOklab_ke1od$(rgb);
    var L = lab.L;
    var tmp$_0 = this.CLIP_EPSILON_0;
    var x = lab.a * lab.a + lab.b * lab.b;
    var b = JsMath.sqrt(x);
    var C = JsMath.max(tmp$_0, b);
    var a_ = lab.a / C;
    var b_ = lab.b / C;
    var cusp = this.findCusp_0(a_, b_);
    switch (method.name) {
      case 'PRESERVE_LIGHTNESS':
        tmp$ = coerceIn(L, 0.0, 1.0);
        break;
      case 'PROJECT_TO_MID':
        tmp$ = 0.5;
        break;
      case 'PROJECT_TO_LCUSP':
        tmp$ = cusp.L;
        break;
      case 'ADAPTIVE_TOWARDS_MID':
        tmp$ = this.calcAdaptiveMidL_hln2n9$(L, C, alpha);
        break;
      case 'ADAPTIVE_TOWARDS_LCUSP':
        var Ld = L - cusp.L;
        var k = 2.0 * (Ld > 0 ? 1.0 - cusp.L : cusp.L);
        var e1 = 0.5 * k + JsMath.abs(Ld) + alpha * C / k;
        var tmp$_1 = cusp.L;
        var tmp$_2 = JsMath.sign(Ld);
        var x_0 = e1 * e1 - 2.0 * k * JsMath.abs(Ld);
        tmp$ = tmp$_1 + 0.5 * (tmp$_2 * (e1 - JsMath.sqrt(x_0)));
        break;
      default:tmp$ = Kotlin.noWhenBranchMatched();
        break;
    }
    var l0 = tmp$;
    var t = this.findGamutIntersection_0(cusp, a_, b_, L, C, l0);
    var L_clipped = l0 * (1 - t) + t * L;
    var C_clipped = t * C;
    return (new Oklab(L_clipped, C_clipped * a_, C_clipped * b_)).toLinearSrgb();
  };
  function OklabGamut$ClipMethod(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OklabGamut$ClipMethod_initFields() {
    OklabGamut$ClipMethod_initFields = function () {
    };
    OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_instance = new OklabGamut$ClipMethod('PRESERVE_LIGHTNESS', 0);
    OklabGamut$ClipMethod$PROJECT_TO_MID_instance = new OklabGamut$ClipMethod('PROJECT_TO_MID', 1);
    OklabGamut$ClipMethod$PROJECT_TO_LCUSP_instance = new OklabGamut$ClipMethod('PROJECT_TO_LCUSP', 2);
    OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_instance = new OklabGamut$ClipMethod('ADAPTIVE_TOWARDS_MID', 3);
    OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_LCUSP_instance = new OklabGamut$ClipMethod('ADAPTIVE_TOWARDS_LCUSP', 4);
  }
  var OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_instance;
  function OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance() {
    OklabGamut$ClipMethod_initFields();
    return OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_instance;
  }
  var OklabGamut$ClipMethod$PROJECT_TO_MID_instance;
  function OklabGamut$ClipMethod$PROJECT_TO_MID_getInstance() {
    OklabGamut$ClipMethod_initFields();
    return OklabGamut$ClipMethod$PROJECT_TO_MID_instance;
  }
  var OklabGamut$ClipMethod$PROJECT_TO_LCUSP_instance;
  function OklabGamut$ClipMethod$PROJECT_TO_LCUSP_getInstance() {
    OklabGamut$ClipMethod_initFields();
    return OklabGamut$ClipMethod$PROJECT_TO_LCUSP_instance;
  }
  var OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_instance;
  function OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance() {
    OklabGamut$ClipMethod_initFields();
    return OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_instance;
  }
  var OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_LCUSP_instance;
  function OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_LCUSP_getInstance() {
    OklabGamut$ClipMethod_initFields();
    return OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_LCUSP_instance;
  }
  OklabGamut$ClipMethod.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ClipMethod',
    interfaces: [Enum]
  };
  function OklabGamut$ClipMethod$values() {
    return [OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance(), OklabGamut$ClipMethod$PROJECT_TO_MID_getInstance(), OklabGamut$ClipMethod$PROJECT_TO_LCUSP_getInstance(), OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance(), OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_LCUSP_getInstance()];
  }
  OklabGamut$ClipMethod.values = OklabGamut$ClipMethod$values;
  function OklabGamut$ClipMethod$valueOf(name) {
    switch (name) {
      case 'PRESERVE_LIGHTNESS':
        return OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance();
      case 'PROJECT_TO_MID':
        return OklabGamut$ClipMethod$PROJECT_TO_MID_getInstance();
      case 'PROJECT_TO_LCUSP':
        return OklabGamut$ClipMethod$PROJECT_TO_LCUSP_getInstance();
      case 'ADAPTIVE_TOWARDS_MID':
        return OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance();
      case 'ADAPTIVE_TOWARDS_LCUSP':
        return OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_LCUSP_getInstance();
      default:throwISE('No enum constant dev.kdrag0n.colorkt.gamut.OklabGamut.ClipMethod.' + name);
    }
  }
  OklabGamut$ClipMethod.valueOf_61zpoe$ = OklabGamut$ClipMethod$valueOf;
  function OklabGamut$LC(L, C) {
    this.L = L;
    this.C = C;
  }
  OklabGamut$LC.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LC',
    interfaces: []
  };
  OklabGamut$LC.prototype.component1 = function () {
    return this.L;
  };
  OklabGamut$LC.prototype.component2 = function () {
    return this.C;
  };
  OklabGamut$LC.prototype.copy_lu1900$ = function (L, C) {
    return new OklabGamut$LC(L === void 0 ? this.L : L, C === void 0 ? this.C : C);
  };
  OklabGamut$LC.prototype.toString = function () {
    return 'LC(L=' + Kotlin.toString(this.L) + (', C=' + Kotlin.toString(this.C)) + ')';
  };
  OklabGamut$LC.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.L) | 0;
    result = result * 31 + Kotlin.hashCode(this.C) | 0;
    return result;
  };
  OklabGamut$LC.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.L, other.L) && Kotlin.equals(this.C, other.C)))));
  };
  function OklabGamut$SaturationCoefficients(name, ordinal, k0, k1, k2, k3, k4, wl, wm, ws) {
    Enum.call(this);
    this.k0 = k0;
    this.k1 = k1;
    this.k2 = k2;
    this.k3 = k3;
    this.k4 = k4;
    this.wl = wl;
    this.wm = wm;
    this.ws = ws;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OklabGamut$SaturationCoefficients_initFields() {
    OklabGamut$SaturationCoefficients_initFields = function () {
    };
    OklabGamut$SaturationCoefficients$RED_instance = new OklabGamut$SaturationCoefficients('RED', 0, +1.19086277, +1.76576728, +0.59662641, +0.75515197, +0.56771245, +4.0767416621, -3.3077115913, +0.2309699292);
    OklabGamut$SaturationCoefficients$GREEN_instance = new OklabGamut$SaturationCoefficients('GREEN', 1, +0.73956515, -0.45954404, +0.08285427, +0.1254107, +0.14503204, -1.2681437731, +2.6097574011, -0.3413193965);
    OklabGamut$SaturationCoefficients$BLUE_instance = new OklabGamut$SaturationCoefficients('BLUE', 2, +1.35733652, -0.00915799, -1.1513021, -0.50559606, +0.00692167, -0.0041960863, -0.7034186147, +1.707614701);
  }
  var OklabGamut$SaturationCoefficients$RED_instance;
  function OklabGamut$SaturationCoefficients$RED_getInstance() {
    OklabGamut$SaturationCoefficients_initFields();
    return OklabGamut$SaturationCoefficients$RED_instance;
  }
  var OklabGamut$SaturationCoefficients$GREEN_instance;
  function OklabGamut$SaturationCoefficients$GREEN_getInstance() {
    OklabGamut$SaturationCoefficients_initFields();
    return OklabGamut$SaturationCoefficients$GREEN_instance;
  }
  var OklabGamut$SaturationCoefficients$BLUE_instance;
  function OklabGamut$SaturationCoefficients$BLUE_getInstance() {
    OklabGamut$SaturationCoefficients_initFields();
    return OklabGamut$SaturationCoefficients$BLUE_instance;
  }
  OklabGamut$SaturationCoefficients.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SaturationCoefficients',
    interfaces: [Enum]
  };
  function OklabGamut$SaturationCoefficients$values() {
    return [OklabGamut$SaturationCoefficients$RED_getInstance(), OklabGamut$SaturationCoefficients$GREEN_getInstance(), OklabGamut$SaturationCoefficients$BLUE_getInstance()];
  }
  OklabGamut$SaturationCoefficients.values = OklabGamut$SaturationCoefficients$values;
  function OklabGamut$SaturationCoefficients$valueOf(name) {
    switch (name) {
      case 'RED':
        return OklabGamut$SaturationCoefficients$RED_getInstance();
      case 'GREEN':
        return OklabGamut$SaturationCoefficients$GREEN_getInstance();
      case 'BLUE':
        return OklabGamut$SaturationCoefficients$BLUE_getInstance();
      default:throwISE('No enum constant dev.kdrag0n.colorkt.gamut.OklabGamut.SaturationCoefficients.' + name);
    }
  }
  OklabGamut$SaturationCoefficients.valueOf_61zpoe$ = OklabGamut$SaturationCoefficients$valueOf;
  OklabGamut.prototype.clipToLinearSrgb_elvxkk$ = function ($receiver, method, alpha) {
    if (method === void 0)
      method = OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance();
    if (alpha === void 0)
      alpha = 0.05;
    return this.clip_0($receiver.toLinearSrgb(), method, alpha, $receiver);
  };
  OklabGamut.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'OklabGamut',
    interfaces: []
  };
  var OklabGamut_instance = null;
  function OklabGamut_getInstance() {
    if (OklabGamut_instance === null) {
      new OklabGamut();
    }return OklabGamut_instance;
  }
  function ConversionGraph$add$lambda(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function LinearSrgb(r, g, b) {
    LinearSrgb$Companion_getInstance();
    this.r_nxxqiy$_0 = r;
    this.g_nxxq9h$_0 = g;
    this.b_nxxq56$_0 = b;
  }
  Object.defineProperty(LinearSrgb.prototype, 'r', {
    get: function () {
      return this.r_nxxqiy$_0;
    }
  });
  Object.defineProperty(LinearSrgb.prototype, 'g', {
    get: function () {
      return this.g_nxxq9h$_0;
    }
  });
  Object.defineProperty(LinearSrgb.prototype, 'b', {
    get: function () {
      return this.b_nxxq56$_0;
    }
  });
  LinearSrgb.prototype.toSrgb = function () {
    return new Srgb(LinearSrgb$Companion_getInstance().f_0(this.r), LinearSrgb$Companion_getInstance().f_0(this.g), LinearSrgb$Companion_getInstance().f_0(this.b));
  };
  LinearSrgb.prototype.isInGamut = function () {
    return rangeTo(0.0, 1.0).contains_mef7kx$(this.r) && rangeTo(0.0, 1.0).contains_mef7kx$(this.g) && rangeTo(0.0, 1.0).contains_mef7kx$(this.b);
  };
  function LinearSrgb$Companion() {
    LinearSrgb$Companion_instance = this;
  }
  function LinearSrgb$Companion$register$lambda(this$LinearSrgb$) {
    return function (it) {
      return this$LinearSrgb$.toLinear_cm64d4$(it);
    };
  }
  function LinearSrgb$Companion$register$lambda_0(it) {
    return it.toSrgb();
  }
  LinearSrgb$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(Srgb), getKClass(LinearSrgb), new ColorConverter(ConversionGraph$add$lambda(LinearSrgb$Companion$register$lambda(this), Srgb, Kotlin.isInstanceOf(Srgb))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(LinearSrgb), getKClass(Srgb), new ColorConverter(ConversionGraph$add$lambda(LinearSrgb$Companion$register$lambda_0, LinearSrgb, Kotlin.isInstanceOf(LinearSrgb))));
  };
  LinearSrgb$Companion.prototype.f_0 = function (x) {
    if (x >= 0.0031308) {
      var x_0 = 1.0 / 2.4;
      return 1.055 * JsMath.pow(x, x_0) - 0.055;
    } else {
      return 12.92 * x;
    }
  };
  LinearSrgb$Companion.prototype.fInv_0 = function (x) {
    if (x >= 0.04045) {
      var $receiver = (x + 0.055) / 1.055;
      return JsMath.pow($receiver, 2.4);
    } else {
      return x / 12.92;
    }
  };
  LinearSrgb$Companion.prototype.toLinear_cm64d4$ = function ($receiver) {
    return new LinearSrgb(this.fInv_0($receiver.r), this.fInv_0($receiver.g), this.fInv_0($receiver.b));
  };
  LinearSrgb$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var LinearSrgb$Companion_instance = null;
  function LinearSrgb$Companion_getInstance() {
    if (LinearSrgb$Companion_instance === null) {
      new LinearSrgb$Companion();
    }return LinearSrgb$Companion_instance;
  }
  LinearSrgb.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LinearSrgb',
    interfaces: [Rgb]
  };
  LinearSrgb.prototype.component1 = function () {
    return this.r;
  };
  LinearSrgb.prototype.component2 = function () {
    return this.g;
  };
  LinearSrgb.prototype.component3 = function () {
    return this.b;
  };
  LinearSrgb.prototype.copy_yvo9jy$ = function (r, g, b) {
    return new LinearSrgb(r === void 0 ? this.r : r, g === void 0 ? this.g : g, b === void 0 ? this.b : b);
  };
  LinearSrgb.prototype.toString = function () {
    return 'LinearSrgb(r=' + Kotlin.toString(this.r) + (', g=' + Kotlin.toString(this.g)) + (', b=' + Kotlin.toString(this.b)) + ')';
  };
  LinearSrgb.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.r) | 0;
    result = result * 31 + Kotlin.hashCode(this.g) | 0;
    result = result * 31 + Kotlin.hashCode(this.b) | 0;
    return result;
  };
  LinearSrgb.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.r, other.r) && Kotlin.equals(this.g, other.g) && Kotlin.equals(this.b, other.b)))));
  };
  function Rgb() {
  }
  Rgb.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Rgb',
    interfaces: [Color]
  };
  function Srgb(r, g, b) {
    Srgb$Companion_getInstance();
    this.r_mguxtb$_0 = r;
    this.g_mguxju$_0 = g;
    this.b_mguxfj$_0 = b;
  }
  Object.defineProperty(Srgb.prototype, 'r', {
    get: function () {
      return this.r_mguxtb$_0;
    }
  });
  Object.defineProperty(Srgb.prototype, 'g', {
    get: function () {
      return this.g_mguxju$_0;
    }
  });
  Object.defineProperty(Srgb.prototype, 'b', {
    get: function () {
      return this.b_mguxfj$_0;
    }
  });
  Srgb.prototype.toRgb8 = function () {
    return Srgb$Companion_getInstance().quantize8_0(this.r) << 16 | Srgb$Companion_getInstance().quantize8_0(this.g) << 8 | Srgb$Companion_getInstance().quantize8_0(this.b);
  };
  Srgb.prototype.toHex = function () {
    return '#' + padStart(toString(this.toRgb8(), 16), 6, 48);
  };
  function Srgb$Companion() {
    Srgb$Companion_instance = this;
  }
  Srgb$Companion.prototype.quantize8_0 = function (n) {
    return roundToInt(n * 255.0) & 255;
  };
  Srgb$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Srgb$Companion_instance = null;
  function Srgb$Companion_getInstance() {
    if (Srgb$Companion_instance === null) {
      new Srgb$Companion();
    }return Srgb$Companion_instance;
  }
  Srgb.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Srgb',
    interfaces: [Rgb]
  };
  function Srgb_init(r, g, b, $this) {
    $this = $this || Object.create(Srgb.prototype);
    Srgb.call($this, r / 255.0, g / 255.0, b / 255.0);
    return $this;
  }
  function Srgb_init_0(color, $this) {
    $this = $this || Object.create(Srgb.prototype);
    Srgb_init(color >> 16 & 255, color >> 8 & 255, color & 255, $this);
    return $this;
  }
  function Srgb_init_1(color, $this) {
    $this = $this || Object.create(Srgb.prototype);
    Srgb_init_0(toInt(removePrefix(color, '#'), 16), $this);
    return $this;
  }
  Srgb.prototype.component1 = function () {
    return this.r;
  };
  Srgb.prototype.component2 = function () {
    return this.g;
  };
  Srgb.prototype.component3 = function () {
    return this.b;
  };
  Srgb.prototype.copy_yvo9jy$ = function (r, g, b) {
    return new Srgb(r === void 0 ? this.r : r, g === void 0 ? this.g : g, b === void 0 ? this.b : b);
  };
  Srgb.prototype.toString = function () {
    return 'Srgb(r=' + Kotlin.toString(this.r) + (', g=' + Kotlin.toString(this.g)) + (', b=' + Kotlin.toString(this.b)) + ')';
  };
  Srgb.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.r) | 0;
    result = result * 31 + Kotlin.hashCode(this.g) | 0;
    result = result * 31 + Kotlin.hashCode(this.b) | 0;
    return result;
  };
  Srgb.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.r, other.r) && Kotlin.equals(this.g, other.g) && Kotlin.equals(this.b, other.b)))));
  };
  function ConversionGraph$add$lambda_0(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function CieXyz(x, y, z) {
    CieXyz$Companion_getInstance();
    this.x = x;
    this.y = y;
    this.z = z;
  }
  CieXyz.prototype.toLinearSrgb = function () {
    return new LinearSrgb(3.2409699419045226 * this.x + -1.537383177570094 * this.y + -0.49861076029300355 * this.z, -0.9692436362808796 * this.x + 1.8759675015077202 * this.y + 0.04155505740717562 * this.z, 0.055630079696993635 * this.x + -0.2039769588889765 * this.y + 1.0569715142428784 * this.z);
  };
  function CieXyz$Companion() {
    CieXyz$Companion_instance = this;
  }
  function CieXyz$Companion$register$lambda(this$CieXyz$) {
    return function (it) {
      return this$CieXyz$.toXyz_ke1od$(it);
    };
  }
  function CieXyz$Companion$register$lambda_0(it) {
    return it.toLinearSrgb();
  }
  CieXyz$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(LinearSrgb), getKClass(CieXyz), new ColorConverter(ConversionGraph$add$lambda_0(CieXyz$Companion$register$lambda(this), LinearSrgb, Kotlin.isInstanceOf(LinearSrgb))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(CieXyz), getKClass(LinearSrgb), new ColorConverter(ConversionGraph$add$lambda_0(CieXyz$Companion$register$lambda_0, CieXyz, Kotlin.isInstanceOf(CieXyz))));
  };
  CieXyz$Companion.prototype.toXyz_ke1od$ = function ($receiver) {
    return new CieXyz(0.4123907992659593 * $receiver.r + 0.357584339383878 * $receiver.g + 0.18048078840183432 * $receiver.b, 0.21263900587151024 * $receiver.r + 0.715168678767756 * $receiver.g + 0.07219231536073373 * $receiver.b, 0.01933081871559182 * $receiver.r + 0.11919477979462598 * $receiver.g + 0.9505321522496608 * $receiver.b);
  };
  CieXyz$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CieXyz$Companion_instance = null;
  function CieXyz$Companion_getInstance() {
    if (CieXyz$Companion_instance === null) {
      new CieXyz$Companion();
    }return CieXyz$Companion_instance;
  }
  CieXyz.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CieXyz',
    interfaces: [Color]
  };
  CieXyz.prototype.component1 = function () {
    return this.x;
  };
  CieXyz.prototype.component2 = function () {
    return this.y;
  };
  CieXyz.prototype.component3 = function () {
    return this.z;
  };
  CieXyz.prototype.copy_yvo9jy$ = function (x, y, z) {
    return new CieXyz(x === void 0 ? this.x : x, y === void 0 ? this.y : y, z === void 0 ? this.z : z);
  };
  CieXyz.prototype.toString = function () {
    return 'CieXyz(x=' + Kotlin.toString(this.x) + (', y=' + Kotlin.toString(this.y)) + (', z=' + Kotlin.toString(this.z)) + ')';
  };
  CieXyz.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.x) | 0;
    result = result * 31 + Kotlin.hashCode(this.y) | 0;
    result = result * 31 + Kotlin.hashCode(this.z) | 0;
    return result;
  };
  CieXyz.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.x, other.x) && Kotlin.equals(this.y, other.y) && Kotlin.equals(this.z, other.z)))));
  };
  function ConversionGraph$add$lambda_1(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function CieXyzAbs(x, y, z) {
    CieXyzAbs$Companion_getInstance();
    this.x = x;
    this.y = y;
    this.z = z;
  }
  CieXyzAbs.prototype.toRel_14dthe$ = function (luminance) {
    if (luminance === void 0)
      luminance = CieXyzAbs$Companion_getInstance().DEFAULT_SDR_WHITE_LUMINANCE;
    return new CieXyz(this.x / luminance, this.y / luminance, this.z / luminance);
  };
  function CieXyzAbs$Companion() {
    CieXyzAbs$Companion_instance = this;
    this.DEFAULT_SDR_WHITE_LUMINANCE = 200.0;
  }
  function CieXyzAbs$Companion$register$lambda(this$CieXyzAbs$) {
    return function (it) {
      return this$CieXyzAbs$.toAbs_ddoe5a$(it, this$CieXyzAbs$.DEFAULT_SDR_WHITE_LUMINANCE);
    };
  }
  function CieXyzAbs$Companion$register$lambda_0(this$CieXyzAbs$) {
    return function (it) {
      return it.toRel_14dthe$(this$CieXyzAbs$.DEFAULT_SDR_WHITE_LUMINANCE);
    };
  }
  CieXyzAbs$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(CieXyz), getKClass(CieXyzAbs), new ColorConverter(ConversionGraph$add$lambda_1(CieXyzAbs$Companion$register$lambda(this), CieXyz, Kotlin.isInstanceOf(CieXyz))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(CieXyzAbs), getKClass(CieXyz), new ColorConverter(ConversionGraph$add$lambda_1(CieXyzAbs$Companion$register$lambda_0(this), CieXyzAbs, Kotlin.isInstanceOf(CieXyzAbs))));
  };
  CieXyzAbs$Companion.prototype.toAbs_ddoe5a$ = function ($receiver, luminance) {
    if (luminance === void 0)
      luminance = this.DEFAULT_SDR_WHITE_LUMINANCE;
    return new CieXyzAbs($receiver.x * luminance, $receiver.y * luminance, $receiver.z * luminance);
  };
  CieXyzAbs$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CieXyzAbs$Companion_instance = null;
  function CieXyzAbs$Companion_getInstance() {
    if (CieXyzAbs$Companion_instance === null) {
      new CieXyzAbs$Companion();
    }return CieXyzAbs$Companion_instance;
  }
  CieXyzAbs.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CieXyzAbs',
    interfaces: [Color]
  };
  CieXyzAbs.prototype.component1 = function () {
    return this.x;
  };
  CieXyzAbs.prototype.component2 = function () {
    return this.y;
  };
  CieXyzAbs.prototype.component3 = function () {
    return this.z;
  };
  CieXyzAbs.prototype.copy_yvo9jy$ = function (x, y, z) {
    return new CieXyzAbs(x === void 0 ? this.x : x, y === void 0 ? this.y : y, z === void 0 ? this.z : z);
  };
  CieXyzAbs.prototype.toString = function () {
    return 'CieXyzAbs(x=' + Kotlin.toString(this.x) + (', y=' + Kotlin.toString(this.y)) + (', z=' + Kotlin.toString(this.z)) + ')';
  };
  CieXyzAbs.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.x) | 0;
    result = result * 31 + Kotlin.hashCode(this.y) | 0;
    result = result * 31 + Kotlin.hashCode(this.z) | 0;
    return result;
  };
  CieXyzAbs.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.x, other.x) && Kotlin.equals(this.y, other.y) && Kotlin.equals(this.z, other.z)))));
  };
  function ConversionGraph$add$lambda_2(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function CieLab(L, a, b, referenceWhite) {
    CieLab$Companion_getInstance();
    if (referenceWhite === void 0)
      referenceWhite = Illuminants_getInstance().D65;
    this.L_jezvi0$_0 = L;
    this.a_jezw03$_0 = a;
    this.b_jezw0y$_0 = b;
    this.referenceWhite = referenceWhite;
  }
  Object.defineProperty(CieLab.prototype, 'L', {
    get: function () {
      return this.L_jezvi0$_0;
    }
  });
  Object.defineProperty(CieLab.prototype, 'a', {
    get: function () {
      return this.a_jezw03$_0;
    }
  });
  Object.defineProperty(CieLab.prototype, 'b', {
    get: function () {
      return this.b_jezw0y$_0;
    }
  });
  CieLab.prototype.toXyz = function () {
    var lp = (this.L + 16.0) / 116.0;
    return new CieXyz(this.referenceWhite.x * CieLab$Companion_getInstance().fInv_0(lp + this.a / 500.0), this.referenceWhite.y * CieLab$Companion_getInstance().fInv_0(lp), this.referenceWhite.z * CieLab$Companion_getInstance().fInv_0(lp - this.b / 200.0));
  };
  function CieLab$Companion() {
    CieLab$Companion_instance = this;
  }
  function CieLab$Companion$register$lambda(this$CieLab$) {
    return function (it) {
      return this$CieLab$.toCieLab_gc44y7$(it);
    };
  }
  function CieLab$Companion$register$lambda_0(it) {
    return it.toXyz();
  }
  CieLab$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(CieXyz), getKClass(CieLab), new ColorConverter(ConversionGraph$add$lambda_2(CieLab$Companion$register$lambda(this), CieXyz, Kotlin.isInstanceOf(CieXyz))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(CieLab), getKClass(CieXyz), new ColorConverter(ConversionGraph$add$lambda_2(CieLab$Companion$register$lambda_0, CieLab, Kotlin.isInstanceOf(CieLab))));
  };
  CieLab$Companion.prototype.f_0 = function (x) {
    if (x > 216.0 / 24389.0) {
      return cbrt(x);
    } else {
      return x / (108.0 / 841.0) + 4.0 / 29.0;
    }
  };
  CieLab$Companion.prototype.fInv_0 = function (x) {
    if (x > 6.0 / 29.0) {
      return x * x * x;
    } else {
      return 108.0 / 841.0 * (x - 4.0 / 29.0);
    }
  };
  CieLab$Companion.prototype.toCieLab_gc44y7$ = function ($receiver, refWhite) {
    if (refWhite === void 0)
      refWhite = Illuminants_getInstance().D65;
    return new CieLab(116.0 * this.f_0($receiver.y / refWhite.y) - 16.0, 500.0 * (this.f_0($receiver.x / refWhite.x) - this.f_0($receiver.y / refWhite.y)), 200.0 * (this.f_0($receiver.y / refWhite.y) - this.f_0($receiver.z / refWhite.z)), refWhite);
  };
  CieLab$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CieLab$Companion_instance = null;
  function CieLab$Companion_getInstance() {
    if (CieLab$Companion_instance === null) {
      new CieLab$Companion();
    }return CieLab$Companion_instance;
  }
  CieLab.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CieLab',
    interfaces: [Lab]
  };
  CieLab.prototype.component1 = function () {
    return this.L;
  };
  CieLab.prototype.component2 = function () {
    return this.a;
  };
  CieLab.prototype.component3 = function () {
    return this.b;
  };
  CieLab.prototype.component4 = function () {
    return this.referenceWhite;
  };
  CieLab.prototype.copy_f668ah$ = function (L, a, b, referenceWhite) {
    return new CieLab(L === void 0 ? this.L : L, a === void 0 ? this.a : a, b === void 0 ? this.b : b, referenceWhite === void 0 ? this.referenceWhite : referenceWhite);
  };
  CieLab.prototype.toString = function () {
    return 'CieLab(L=' + Kotlin.toString(this.L) + (', a=' + Kotlin.toString(this.a)) + (', b=' + Kotlin.toString(this.b)) + (', referenceWhite=' + Kotlin.toString(this.referenceWhite)) + ')';
  };
  CieLab.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.L) | 0;
    result = result * 31 + Kotlin.hashCode(this.a) | 0;
    result = result * 31 + Kotlin.hashCode(this.b) | 0;
    result = result * 31 + Kotlin.hashCode(this.referenceWhite) | 0;
    return result;
  };
  CieLab.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.L, other.L) && Kotlin.equals(this.a, other.a) && Kotlin.equals(this.b, other.b) && Kotlin.equals(this.referenceWhite, other.referenceWhite)))));
  };
  function Lab() {
  }
  Lab.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Lab',
    interfaces: [Color]
  };
  function ConversionGraph$add$lambda_3(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function Oklab(L, a, b) {
    Oklab$Companion_getInstance();
    this.L_sx3ftt$_0 = L;
    this.a_sx3gbw$_0 = a;
    this.b_sx3gcr$_0 = b;
  }
  Object.defineProperty(Oklab.prototype, 'L', {
    get: function () {
      return this.L_sx3ftt$_0;
    }
  });
  Object.defineProperty(Oklab.prototype, 'a', {
    get: function () {
      return this.a_sx3gbw$_0;
    }
  });
  Object.defineProperty(Oklab.prototype, 'b', {
    get: function () {
      return this.b_sx3gcr$_0;
    }
  });
  Oklab.prototype.toLinearSrgb = function () {
    var l = this.labToL_0();
    var m = this.labToM_0();
    var s = this.labToS_0();
    return new LinearSrgb(+4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s, -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s, -0.0041960863 * l - 0.7034186147 * m + 1.707614701 * s);
  };
  Oklab.prototype.toXyz = function () {
    var l = this.labToL_0();
    var m = this.labToM_0();
    var s = this.labToS_0();
    return new CieXyz(+1.2270138511 * l - 0.5577999807 * m + 0.281256149 * s, -0.0405801784 * l + 1.1122568696 * m - 0.0716766787 * s, -0.0763812845 * l - 0.4214819784 * m + 1.5861632204 * s);
  };
  Oklab.prototype.labToL_0 = function () {
    var x = this.L + 0.3963377774 * this.a + 0.2158037573 * this.b;
    return x * x * x;
  };
  Oklab.prototype.labToM_0 = function () {
    var x = this.L - 0.1055613458 * this.a - 0.0638541728 * this.b;
    return x * x * x;
  };
  Oklab.prototype.labToS_0 = function () {
    var x = this.L - 0.0894841775 * this.a - 1.291485548 * this.b;
    return x * x * x;
  };
  function Oklab$Companion() {
    Oklab$Companion_instance = this;
  }
  function Oklab$Companion$register$lambda(this$Oklab$) {
    return function (it) {
      return this$Oklab$.toOklab_ke1od$(it);
    };
  }
  function Oklab$Companion$register$lambda_0(it) {
    return it.toLinearSrgb();
  }
  Oklab$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(LinearSrgb), getKClass(Oklab), new ColorConverter(ConversionGraph$add$lambda_3(Oklab$Companion$register$lambda(this), LinearSrgb, Kotlin.isInstanceOf(LinearSrgb))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(Oklab), getKClass(LinearSrgb), new ColorConverter(ConversionGraph$add$lambda_3(Oklab$Companion$register$lambda_0, Oklab, Kotlin.isInstanceOf(Oklab))));
  };
  Oklab$Companion.prototype.lmsToOklab_0 = function (l, m, s) {
    var lp = cbrt(l);
    var mp = cbrt(m);
    var sp = cbrt(s);
    return new Oklab(0.2104542553 * lp + 0.793617785 * mp - 0.0040720468 * sp, 1.9779984951 * lp - 2.428592205 * mp + 0.4505937099 * sp, 0.0259040371 * lp + 0.7827717662 * mp - 0.808675766 * sp);
  };
  Oklab$Companion.prototype.toOklab_ke1od$ = function ($receiver) {
    return this.lmsToOklab_0(0.4122214708 * $receiver.r + 0.5363325363 * $receiver.g + 0.0514459929 * $receiver.b, 0.2119034982 * $receiver.r + 0.6806995451 * $receiver.g + 0.1073969566 * $receiver.b, 0.0883024619 * $receiver.r + 0.2817188376 * $receiver.g + 0.6299787005 * $receiver.b);
  };
  Oklab$Companion.prototype.toOklab_s1xckg$ = function ($receiver) {
    return this.lmsToOklab_0(0.8189330101 * $receiver.x + 0.3618667424 * $receiver.y - 0.1288597137 * $receiver.z, 0.0329845436 * $receiver.x + 0.9293118715 * $receiver.y + 0.0361456387 * $receiver.z, 0.0482003018 * $receiver.x + 0.2643662691 * $receiver.y + 0.633851707 * $receiver.z);
  };
  Oklab$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Oklab$Companion_instance = null;
  function Oklab$Companion_getInstance() {
    if (Oklab$Companion_instance === null) {
      new Oklab$Companion();
    }return Oklab$Companion_instance;
  }
  Oklab.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Oklab',
    interfaces: [Lab]
  };
  Oklab.prototype.component1 = function () {
    return this.L;
  };
  Oklab.prototype.component2 = function () {
    return this.a;
  };
  Oklab.prototype.component3 = function () {
    return this.b;
  };
  Oklab.prototype.copy_yvo9jy$ = function (L, a, b) {
    return new Oklab(L === void 0 ? this.L : L, a === void 0 ? this.a : a, b === void 0 ? this.b : b);
  };
  Oklab.prototype.toString = function () {
    return 'Oklab(L=' + Kotlin.toString(this.L) + (', a=' + Kotlin.toString(this.a)) + (', b=' + Kotlin.toString(this.b)) + ')';
  };
  Oklab.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.L) | 0;
    result = result * 31 + Kotlin.hashCode(this.a) | 0;
    result = result * 31 + Kotlin.hashCode(this.b) | 0;
    return result;
  };
  Oklab.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.L, other.L) && Kotlin.equals(this.a, other.a) && Kotlin.equals(this.b, other.b)))));
  };
  function ConversionGraph$add$lambda_4(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function Srlab2(L, a, b) {
    Srlab2$Companion_getInstance();
    this.L_fqmyji$_0 = L;
    this.a_fqmy1f$_0 = a;
    this.b_fqmy0k$_0 = b;
  }
  Object.defineProperty(Srlab2.prototype, 'L', {
    get: function () {
      return this.L_fqmyji$_0;
    }
  });
  Object.defineProperty(Srlab2.prototype, 'a', {
    get: function () {
      return this.a_fqmy1f$_0;
    }
  });
  Object.defineProperty(Srlab2.prototype, 'b', {
    get: function () {
      return this.b_fqmy0k$_0;
    }
  });
  Srlab2.prototype.toLinearSrgb = function () {
    var x = Srlab2$Companion_getInstance().fInv_0(0.01 * this.L + 9.04127E-4 * this.a + 4.56344E-4 * this.b);
    var y = Srlab2$Companion_getInstance().fInv_0(0.01 * this.L - 5.33159E-4 * this.a - 2.69178E-4 * this.b);
    var z = Srlab2$Companion_getInstance().fInv_0(0.01 * this.L - 0.0058 * this.b);
    return new LinearSrgb(5.435679 * x - 4.599131 * y + 0.163593 * z, -1.16809 * x + 2.327977 * y - 0.159798 * z, 0.03784 * x - 0.198564 * y + 1.160644 * z);
  };
  function Srlab2$Companion() {
    Srlab2$Companion_instance = this;
  }
  function Srlab2$Companion$register$lambda(this$Srlab2$) {
    return function (it) {
      return this$Srlab2$.toSrlab2_ke1od$(it);
    };
  }
  function Srlab2$Companion$register$lambda_0(it) {
    return it.toLinearSrgb();
  }
  Srlab2$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(LinearSrgb), getKClass(Srlab2), new ColorConverter(ConversionGraph$add$lambda_4(Srlab2$Companion$register$lambda(this), LinearSrgb, Kotlin.isInstanceOf(LinearSrgb))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(Srlab2), getKClass(LinearSrgb), new ColorConverter(ConversionGraph$add$lambda_4(Srlab2$Companion$register$lambda_0, Srlab2, Kotlin.isInstanceOf(Srlab2))));
  };
  Srlab2$Companion.prototype.f_0 = function (x) {
    if (x <= 216.0 / 24389.0) {
      return x * 24389.0 / 2700.0;
    } else {
      return 1.16 * cbrt(x) - 0.16;
    }
  };
  Srlab2$Companion.prototype.fInv_0 = function (x) {
    if (x <= 0.08) {
      return x * 2700.0 / 24389.0;
    } else {
      var x_0 = (x + 0.16) / 1.16;
      return x_0 * x_0 * x_0;
    }
  };
  Srlab2$Companion.prototype.toSrlab2_ke1od$ = function ($receiver) {
    var x2 = this.f_0(0.32053 * $receiver.r + 0.63692 * $receiver.g + 0.04256 * $receiver.b);
    var y2 = this.f_0(0.161987 * $receiver.r + 0.756636 * $receiver.g + 0.081376 * $receiver.b);
    var z2 = this.f_0(0.017228 * $receiver.r + 0.10866 * $receiver.g + 0.874112 * $receiver.b);
    return new Srlab2(37.095 * x2 + 62.9054 * y2 - 8.0E-4 * z2, 663.4684 * x2 - 750.5078 * y2 + 87.0328 * z2, 63.9569 * x2 + 108.4576 * y2 - 172.4152 * z2);
  };
  Srlab2$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Srlab2$Companion_instance = null;
  function Srlab2$Companion_getInstance() {
    if (Srlab2$Companion_instance === null) {
      new Srlab2$Companion();
    }return Srlab2$Companion_instance;
  }
  Srlab2.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Srlab2',
    interfaces: [Lab]
  };
  Srlab2.prototype.component1 = function () {
    return this.L;
  };
  Srlab2.prototype.component2 = function () {
    return this.a;
  };
  Srlab2.prototype.component3 = function () {
    return this.b;
  };
  Srlab2.prototype.copy_yvo9jy$ = function (L, a, b) {
    return new Srlab2(L === void 0 ? this.L : L, a === void 0 ? this.a : a, b === void 0 ? this.b : b);
  };
  Srlab2.prototype.toString = function () {
    return 'Srlab2(L=' + Kotlin.toString(this.L) + (', a=' + Kotlin.toString(this.a)) + (', b=' + Kotlin.toString(this.b)) + ')';
  };
  Srlab2.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.L) | 0;
    result = result * 31 + Kotlin.hashCode(this.a) | 0;
    result = result * 31 + Kotlin.hashCode(this.b) | 0;
    return result;
  };
  Srlab2.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.L, other.L) && Kotlin.equals(this.a, other.a) && Kotlin.equals(this.b, other.b)))));
  };
  function ConversionGraph$add$lambda_5(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function CieLch(lightness, chroma, hue, referenceWhite) {
    CieLch$Companion_getInstance();
    if (referenceWhite === void 0)
      referenceWhite = Illuminants_getInstance().D65;
    this.lightness_6qua89$_0 = lightness;
    this.chroma_svxyey$_0 = chroma;
    this.hue_zfgpo4$_0 = hue;
    this.referenceWhite = referenceWhite;
  }
  Object.defineProperty(CieLch.prototype, 'lightness', {
    get: function () {
      return this.lightness_6qua89$_0;
    }
  });
  Object.defineProperty(CieLch.prototype, 'chroma', {
    get: function () {
      return this.chroma_svxyey$_0;
    }
  });
  Object.defineProperty(CieLch.prototype, 'hue', {
    get: function () {
      return this.hue_zfgpo4$_0;
    }
  });
  CieLch.prototype.toCieLab = function () {
    return new CieLab(this.lightness, calcLabA(this), calcLabB(this), this.referenceWhite);
  };
  function CieLch$Companion() {
    CieLch$Companion_instance = this;
  }
  function CieLch$Companion$register$lambda(this$CieLch$) {
    return function (it) {
      return this$CieLch$.toCieLch_dkvj5h$(it);
    };
  }
  function CieLch$Companion$register$lambda_0(it) {
    return it.toCieLab();
  }
  CieLch$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(CieLab), getKClass(CieLch), new ColorConverter(ConversionGraph$add$lambda_5(CieLch$Companion$register$lambda(this), CieLab, Kotlin.isInstanceOf(CieLab))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(CieLch), getKClass(CieLab), new ColorConverter(ConversionGraph$add$lambda_5(CieLch$Companion$register$lambda_0, CieLch, Kotlin.isInstanceOf(CieLch))));
  };
  CieLch$Companion.prototype.toCieLch_dkvj5h$ = function ($receiver) {
    return new CieLch($receiver.L, calcLchC($receiver), calcLchH($receiver), $receiver.referenceWhite);
  };
  CieLch$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CieLch$Companion_instance = null;
  function CieLch$Companion_getInstance() {
    if (CieLch$Companion_instance === null) {
      new CieLch$Companion();
    }return CieLch$Companion_instance;
  }
  CieLch.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CieLch',
    interfaces: [Lch]
  };
  CieLch.prototype.component1 = function () {
    return this.lightness;
  };
  CieLch.prototype.component2 = function () {
    return this.chroma;
  };
  CieLch.prototype.component3 = function () {
    return this.hue;
  };
  CieLch.prototype.component4 = function () {
    return this.referenceWhite;
  };
  CieLch.prototype.copy_f668ah$ = function (lightness, chroma, hue, referenceWhite) {
    return new CieLch(lightness === void 0 ? this.lightness : lightness, chroma === void 0 ? this.chroma : chroma, hue === void 0 ? this.hue : hue, referenceWhite === void 0 ? this.referenceWhite : referenceWhite);
  };
  CieLch.prototype.toString = function () {
    return 'CieLch(lightness=' + Kotlin.toString(this.lightness) + (', chroma=' + Kotlin.toString(this.chroma)) + (', hue=' + Kotlin.toString(this.hue)) + (', referenceWhite=' + Kotlin.toString(this.referenceWhite)) + ')';
  };
  CieLch.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lightness) | 0;
    result = result * 31 + Kotlin.hashCode(this.chroma) | 0;
    result = result * 31 + Kotlin.hashCode(this.hue) | 0;
    result = result * 31 + Kotlin.hashCode(this.referenceWhite) | 0;
    return result;
  };
  CieLch.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lightness, other.lightness) && Kotlin.equals(this.chroma, other.chroma) && Kotlin.equals(this.hue, other.hue) && Kotlin.equals(this.referenceWhite, other.referenceWhite)))));
  };
  function Lch() {
  }
  Lch.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Lch',
    interfaces: [Color]
  };
  function calcLchC($receiver) {
    var x = $receiver.a;
    var tmp$ = x * x;
    var x_0 = $receiver.b;
    var x_1 = tmp$ + x_0 * x_0;
    return JsMath.sqrt(x_1);
  }
  function calcLchH($receiver) {
    var y = $receiver.b;
    var x = $receiver.a;
    var hDeg = toDegrees(JsMath.atan2(y, x));
    return hDeg < 0 ? hDeg + 360 : hDeg;
  }
  function calcLabA($receiver) {
    var tmp$ = $receiver.chroma;
    var x = toRadians($receiver.hue);
    return tmp$ * JsMath.cos(x);
  }
  function calcLabB($receiver) {
    var tmp$ = $receiver.chroma;
    var x = toRadians($receiver.hue);
    return tmp$ * JsMath.sin(x);
  }
  function ConversionGraph$add$lambda_6(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function Oklch(lightness, chroma, hue) {
    Oklch$Companion_getInstance();
    this.lightness_mwjp7c$_0 = lightness;
    this.chroma_gkdsvt$_0 = chroma;
    this.hue_hbzo9f$_0 = hue;
  }
  Object.defineProperty(Oklch.prototype, 'lightness', {
    get: function () {
      return this.lightness_mwjp7c$_0;
    }
  });
  Object.defineProperty(Oklch.prototype, 'chroma', {
    get: function () {
      return this.chroma_gkdsvt$_0;
    }
  });
  Object.defineProperty(Oklch.prototype, 'hue', {
    get: function () {
      return this.hue_hbzo9f$_0;
    }
  });
  Oklch.prototype.toOklab = function () {
    return new Oklab(this.lightness, calcLabA(this), calcLabB(this));
  };
  function Oklch$Companion() {
    Oklch$Companion_instance = this;
  }
  function Oklch$Companion$register$lambda(this$Oklch$) {
    return function (it) {
      return this$Oklch$.toOklch_lbf2us$(it);
    };
  }
  function Oklch$Companion$register$lambda_0(it) {
    return it.toOklab();
  }
  Oklch$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(Oklab), getKClass(Oklch), new ColorConverter(ConversionGraph$add$lambda_6(Oklch$Companion$register$lambda(this), Oklab, Kotlin.isInstanceOf(Oklab))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(Oklch), getKClass(Oklab), new ColorConverter(ConversionGraph$add$lambda_6(Oklch$Companion$register$lambda_0, Oklch, Kotlin.isInstanceOf(Oklch))));
  };
  Oklch$Companion.prototype.toOklch_lbf2us$ = function ($receiver) {
    return new Oklch($receiver.L, calcLchC($receiver), calcLchH($receiver));
  };
  Oklch$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Oklch$Companion_instance = null;
  function Oklch$Companion_getInstance() {
    if (Oklch$Companion_instance === null) {
      new Oklch$Companion();
    }return Oklch$Companion_instance;
  }
  Oklch.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Oklch',
    interfaces: [Lch]
  };
  Oklch.prototype.component1 = function () {
    return this.lightness;
  };
  Oklch.prototype.component2 = function () {
    return this.chroma;
  };
  Oklch.prototype.component3 = function () {
    return this.hue;
  };
  Oklch.prototype.copy_yvo9jy$ = function (lightness, chroma, hue) {
    return new Oklch(lightness === void 0 ? this.lightness : lightness, chroma === void 0 ? this.chroma : chroma, hue === void 0 ? this.hue : hue);
  };
  Oklch.prototype.toString = function () {
    return 'Oklch(lightness=' + Kotlin.toString(this.lightness) + (', chroma=' + Kotlin.toString(this.chroma)) + (', hue=' + Kotlin.toString(this.hue)) + ')';
  };
  Oklch.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lightness) | 0;
    result = result * 31 + Kotlin.hashCode(this.chroma) | 0;
    result = result * 31 + Kotlin.hashCode(this.hue) | 0;
    return result;
  };
  Oklch.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lightness, other.lightness) && Kotlin.equals(this.chroma, other.chroma) && Kotlin.equals(this.hue, other.hue)))));
  };
  function ConversionGraph$add$lambda_7(closure$converter, typeClosure$F, isF) {
    return function (it) {
      var tmp$;
      return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
    };
  }
  function Srlch2(lightness, chroma, hue) {
    Srlch2$Companion_getInstance();
    this.lightness_o0ka8n$_0 = lightness;
    this.chroma_k52go$_0 = chroma;
    this.hue_wd1r7i$_0 = hue;
  }
  Object.defineProperty(Srlch2.prototype, 'lightness', {
    get: function () {
      return this.lightness_o0ka8n$_0;
    }
  });
  Object.defineProperty(Srlch2.prototype, 'chroma', {
    get: function () {
      return this.chroma_k52go$_0;
    }
  });
  Object.defineProperty(Srlch2.prototype, 'hue', {
    get: function () {
      return this.hue_wd1r7i$_0;
    }
  });
  Srlch2.prototype.toSrlab2 = function () {
    return new Srlab2(this.lightness, calcLabA(this), calcLabB(this));
  };
  function Srlch2$Companion() {
    Srlch2$Companion_instance = this;
  }
  function Srlch2$Companion$register$lambda(this$Srlch2$) {
    return function (it) {
      return this$Srlch2$.toSrlch2_cjreid$(it);
    };
  }
  function Srlch2$Companion$register$lambda_0(it) {
    return it.toSrlab2();
  }
  Srlch2$Companion.prototype.register_8be2vx$ = function () {
    ConversionGraph_getInstance().add_3n5us3$(getKClass(Srlab2), getKClass(Srlch2), new ColorConverter(ConversionGraph$add$lambda_7(Srlch2$Companion$register$lambda(this), Srlab2, Kotlin.isInstanceOf(Srlab2))));
    ConversionGraph_getInstance().add_3n5us3$(getKClass(Srlch2), getKClass(Srlab2), new ColorConverter(ConversionGraph$add$lambda_7(Srlch2$Companion$register$lambda_0, Srlch2, Kotlin.isInstanceOf(Srlch2))));
  };
  Srlch2$Companion.prototype.toSrlch2_cjreid$ = function ($receiver) {
    return new Srlch2($receiver.L, calcLchC($receiver), calcLchH($receiver));
  };
  Srlch2$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Srlch2$Companion_instance = null;
  function Srlch2$Companion_getInstance() {
    if (Srlch2$Companion_instance === null) {
      new Srlch2$Companion();
    }return Srlch2$Companion_instance;
  }
  Srlch2.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Srlch2',
    interfaces: [Lch]
  };
  Srlch2.prototype.component1 = function () {
    return this.lightness;
  };
  Srlch2.prototype.component2 = function () {
    return this.chroma;
  };
  Srlch2.prototype.component3 = function () {
    return this.hue;
  };
  Srlch2.prototype.copy_yvo9jy$ = function (lightness, chroma, hue) {
    return new Srlch2(lightness === void 0 ? this.lightness : lightness, chroma === void 0 ? this.chroma : chroma, hue === void 0 ? this.hue : hue);
  };
  Srlch2.prototype.toString = function () {
    return 'Srlch2(lightness=' + Kotlin.toString(this.lightness) + (', chroma=' + Kotlin.toString(this.chroma)) + (', hue=' + Kotlin.toString(this.hue)) + ')';
  };
  Srlch2.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.lightness) | 0;
    result = result * 31 + Kotlin.hashCode(this.chroma) | 0;
    result = result * 31 + Kotlin.hashCode(this.hue) | 0;
    return result;
  };
  Srlch2.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.lightness, other.lightness) && Kotlin.equals(this.chroma, other.chroma) && Kotlin.equals(this.hue, other.hue)))));
  };
  function ColorConverter(f) {
    this.function$ = f;
  }
  ColorConverter.prototype.convert_s97y55$ = function (color) {
    return this.function$(color);
  };
  ColorConverter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ColorConverter',
    interfaces: []
  };
  function ConversionGraph() {
    ConversionGraph_instance = this;
    this.graph_0 = LinkedHashMap_init();
  }
  ConversionGraph.prototype.add_c21wku$ = defineInlineFunction('colorkt.dev.kdrag0n.colorkt.util.conversion.ConversionGraph.add_c21wku$', wrapFunction(function () {
    var getKClass = Kotlin.getKClass;
    var throwCCE = Kotlin.throwCCE;
    var ColorConverter = _.dev.kdrag0n.colorkt.util.conversion.ColorConverter;
    function ConversionGraph$add$lambda(closure$converter, typeClosure$F, isF) {
      return function (it) {
        var tmp$;
        return closure$converter(isF(tmp$ = it) ? tmp$ : throwCCE());
      };
    }
    return function (F_0, isF, T_0, isT, converter) {
      this.add_3n5us3$(getKClass(F_0), getKClass(T_0), new ColorConverter(ConversionGraph$add$lambda(converter, F_0, isF)));
    };
  }));
  ConversionGraph.prototype.add_3n5us3$ = function (from, to, converter) {
    var node = new ConversionGraph$ConversionEdge(from, to, converter);
    var $receiver = this.graph_0;
    var tmp$;
    if ((Kotlin.isType(tmp$ = $receiver, Map) ? tmp$ : throwCCE()).containsKey_11rb$(from)) {
      ensureNotNull(this.graph_0.get_11rb$(from)).add_11rb$(node);
    } else {
      var $receiver_0 = this.graph_0;
      var value = mutableListOf([node]);
      $receiver_0.put_xwzc9p$(from, value);
    }
    var $receiver_1 = this.graph_0;
    var tmp$_0;
    if ((Kotlin.isType(tmp$_0 = $receiver_1, Map) ? tmp$_0 : throwCCE()).containsKey_11rb$(to)) {
      ensureNotNull(this.graph_0.get_11rb$(to)).add_11rb$(node);
    } else {
      var $receiver_2 = this.graph_0;
      var value_0 = mutableListOf([node]);
      $receiver_2.put_xwzc9p$(to, value_0);
    }
  };
  function ConversionGraph$findPath$lambda(it) {
    return it;
  }
  ConversionGraph.prototype.findPath_f4nrtl$ = function (from, to) {
    var tmp$, tmp$_0;
    var visited = HashSet_init();
    var pathQueue = ArrayDeque_init(listOf(listOf(new ConversionGraph$ConversionEdge(from, from, new ColorConverter(ConversionGraph$findPath$lambda)))));
    while (!pathQueue.isEmpty()) {
      var path = pathQueue.removeFirst();
      var node = last(path);
      if ((tmp$ = node.to) != null ? tmp$.equals(to) : null) {
        var destination = ArrayList_init(collectionSizeOrDefault(path, 10));
        var tmp$_1;
        tmp$_1 = path.iterator();
        while (tmp$_1.hasNext()) {
          var item = tmp$_1.next();
          destination.add_11rb$(item.converter);
        }
        return destination;
      } else if (!visited.contains_11rb$(node)) {
        visited.add_11rb$(node);
        tmp$_0 = this.graph_0.get_11rb$(node.to);
        if (tmp$_0 == null) {
          continue;
        }var neighbors = tmp$_0;
        var destination_0 = ArrayList_init(collectionSizeOrDefault(neighbors, 10));
        var tmp$_2;
        tmp$_2 = neighbors.iterator();
        while (tmp$_2.hasNext()) {
          var item_0 = tmp$_2.next();
          destination_0.add_11rb$(plus(path, item_0));
        }
        pathQueue.addAll_brywnq$(destination_0);
      }}
    return null;
  };
  function ConversionGraph$ConversionEdge(from, to, converter) {
    this.from = from;
    this.to = to;
    this.converter = converter;
  }
  ConversionGraph$ConversionEdge.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConversionEdge',
    interfaces: []
  };
  ConversionGraph$ConversionEdge.prototype.component1 = function () {
    return this.from;
  };
  ConversionGraph$ConversionEdge.prototype.component2 = function () {
    return this.to;
  };
  ConversionGraph$ConversionEdge.prototype.component3 = function () {
    return this.converter;
  };
  ConversionGraph$ConversionEdge.prototype.copy_3n5us3$ = function (from, to, converter) {
    return new ConversionGraph$ConversionEdge(from === void 0 ? this.from : from, to === void 0 ? this.to : to, converter === void 0 ? this.converter : converter);
  };
  ConversionGraph$ConversionEdge.prototype.toString = function () {
    return 'ConversionEdge(from=' + Kotlin.toString(this.from) + (', to=' + Kotlin.toString(this.to)) + (', converter=' + Kotlin.toString(this.converter)) + ')';
  };
  ConversionGraph$ConversionEdge.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.from) | 0;
    result = result * 31 + Kotlin.hashCode(this.to) | 0;
    result = result * 31 + Kotlin.hashCode(this.converter) | 0;
    return result;
  };
  ConversionGraph$ConversionEdge.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.from, other.from) && Kotlin.equals(this.to, other.to) && Kotlin.equals(this.converter, other.converter)))));
  };
  ConversionGraph.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ConversionGraph',
    interfaces: []
  };
  var ConversionGraph_instance = null;
  function ConversionGraph_getInstance() {
    if (ConversionGraph_instance === null) {
      new ConversionGraph();
    }return ConversionGraph_instance;
  }
  function UnsupportedConversionException() {
    this.name = 'UnsupportedConversionException';
  }
  UnsupportedConversionException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnsupportedConversionException',
    interfaces: [RuntimeException]
  };
  function UnsupportedConversionException_init($this) {
    $this = $this || Object.create(UnsupportedConversionException.prototype);
    RuntimeException_init($this);
    UnsupportedConversionException.call($this);
    return $this;
  }
  function UnsupportedConversionException_init_0(message, $this) {
    $this = $this || Object.create(UnsupportedConversionException.prototype);
    RuntimeException_init_0(message, $this);
    UnsupportedConversionException.call($this);
    return $this;
  }
  var cube = defineInlineFunction('colorkt.dev.kdrag0n.colorkt.util.math.cube_tq0o01$', function (x) {
    return x * x * x;
  });
  var square = defineInlineFunction('colorkt.dev.kdrag0n.colorkt.util.math.square_tq0o01$', function (x) {
    return x * x;
  });
  function toRadians($receiver) {
    return $receiver * math.PI / 180.0;
  }
  function toDegrees($receiver) {
    return $receiver * 180.0 / math.PI;
  }
  function cbrt(x) {
    if (x > 0) {
      var x_0 = 1.0 / 3.0;
      return JsMath.pow(x, x_0);
    } else if (x < 0) {
      var $receiver = -x;
      var x_1 = 1.0 / 3.0;
      return -JsMath.pow($receiver, x_1);
    } else
      return 0.0;
  }
  var package$dev = _.dev || (_.dev = {});
  var package$kdrag0n = package$dev.kdrag0n || (package$dev.kdrag0n = {});
  var package$colorkt = package$kdrag0n.colorkt || (package$kdrag0n.colorkt = {});
  var package$util = package$colorkt.util || (package$colorkt.util = {});
  var package$conversion = package$util.conversion || (package$util.conversion = {});
  package$conversion.UnsupportedConversionException_init_61zpoe$ = UnsupportedConversionException_init_0;
  Object.defineProperty(Color, 'Companion', {
    get: Color$Companion_getInstance
  });
  package$colorkt.Color = Color;
  package$colorkt.registerAllColors_8be2vx$ = registerAllColors;
  $$importsForInline$$.colorkt = _;
  Object.defineProperty(Zcam$LuminanceSource, 'BRIGHTNESS', {
    get: Zcam$LuminanceSource$BRIGHTNESS_getInstance
  });
  Object.defineProperty(Zcam$LuminanceSource, 'LIGHTNESS', {
    get: Zcam$LuminanceSource$LIGHTNESS_getInstance
  });
  Zcam.LuminanceSource = Zcam$LuminanceSource;
  Object.defineProperty(Zcam$ChromaSource, 'CHROMA', {
    get: Zcam$ChromaSource$CHROMA_getInstance
  });
  Object.defineProperty(Zcam$ChromaSource, 'COLORFULNESS', {
    get: Zcam$ChromaSource$COLORFULNESS_getInstance
  });
  Object.defineProperty(Zcam$ChromaSource, 'SATURATION', {
    get: Zcam$ChromaSource$SATURATION_getInstance
  });
  Object.defineProperty(Zcam$ChromaSource, 'VIVIDNESS', {
    get: Zcam$ChromaSource$VIVIDNESS_getInstance
  });
  Object.defineProperty(Zcam$ChromaSource, 'BLACKNESS', {
    get: Zcam$ChromaSource$BLACKNESS_getInstance
  });
  Object.defineProperty(Zcam$ChromaSource, 'WHITENESS', {
    get: Zcam$ChromaSource$WHITENESS_getInstance
  });
  Zcam.ChromaSource = Zcam$ChromaSource;
  Object.defineProperty(Zcam$ViewingConditions, 'Companion', {
    get: Zcam$ViewingConditions$Companion_getInstance
  });
  Zcam.ViewingConditions = Zcam$ViewingConditions;
  Object.defineProperty(Zcam, 'Companion', {
    get: Zcam$Companion_getInstance
  });
  var package$cam = package$colorkt.cam || (package$colorkt.cam = {});
  package$cam.Zcam = Zcam;
  var package$data = package$colorkt.data || (package$colorkt.data = {});
  Object.defineProperty(package$data, 'Illuminants', {
    get: Illuminants_getInstance
  });
  Object.defineProperty(LchGamut$ClipMethod, 'PRESERVE_LIGHTNESS', {
    get: LchGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance
  });
  Object.defineProperty(LchGamut$ClipMethod, 'PROJECT_TO_MID', {
    get: LchGamut$ClipMethod$PROJECT_TO_MID_getInstance
  });
  Object.defineProperty(LchGamut$ClipMethod, 'ADAPTIVE_TOWARDS_MID', {
    get: LchGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance
  });
  LchGamut.prototype.ClipMethod = LchGamut$ClipMethod;
  var package$gamut = package$colorkt.gamut || (package$colorkt.gamut = {});
  Object.defineProperty(package$gamut, 'LchGamut', {
    get: LchGamut_getInstance
  });
  Object.defineProperty(OklabGamut$ClipMethod, 'PRESERVE_LIGHTNESS', {
    get: OklabGamut$ClipMethod$PRESERVE_LIGHTNESS_getInstance
  });
  Object.defineProperty(OklabGamut$ClipMethod, 'PROJECT_TO_MID', {
    get: OklabGamut$ClipMethod$PROJECT_TO_MID_getInstance
  });
  Object.defineProperty(OklabGamut$ClipMethod, 'PROJECT_TO_LCUSP', {
    get: OklabGamut$ClipMethod$PROJECT_TO_LCUSP_getInstance
  });
  Object.defineProperty(OklabGamut$ClipMethod, 'ADAPTIVE_TOWARDS_MID', {
    get: OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_MID_getInstance
  });
  Object.defineProperty(OklabGamut$ClipMethod, 'ADAPTIVE_TOWARDS_LCUSP', {
    get: OklabGamut$ClipMethod$ADAPTIVE_TOWARDS_LCUSP_getInstance
  });
  OklabGamut.prototype.ClipMethod = OklabGamut$ClipMethod;
  Object.defineProperty(package$gamut, 'OklabGamut', {
    get: OklabGamut_getInstance
  });
  Object.defineProperty(LinearSrgb, 'Companion', {
    get: LinearSrgb$Companion_getInstance
  });
  var package$rgb = package$colorkt.rgb || (package$colorkt.rgb = {});
  package$rgb.LinearSrgb = LinearSrgb;
  package$rgb.Rgb = Rgb;
  package$rgb.Srgb_init_qt1dr2$ = Srgb_init;
  package$rgb.Srgb_init_za3lpa$ = Srgb_init_0;
  package$rgb.Srgb_init_61zpoe$ = Srgb_init_1;
  package$rgb.Srgb = Srgb;
  Object.defineProperty(CieXyz, 'Companion', {
    get: CieXyz$Companion_getInstance
  });
  var package$tristimulus = package$colorkt.tristimulus || (package$colorkt.tristimulus = {});
  package$tristimulus.CieXyz = CieXyz;
  Object.defineProperty(CieXyzAbs, 'Companion', {
    get: CieXyzAbs$Companion_getInstance
  });
  package$tristimulus.CieXyzAbs = CieXyzAbs;
  Object.defineProperty(CieLab, 'Companion', {
    get: CieLab$Companion_getInstance
  });
  var package$ucs = package$colorkt.ucs || (package$colorkt.ucs = {});
  var package$lab = package$ucs.lab || (package$ucs.lab = {});
  package$lab.CieLab = CieLab;
  package$lab.Lab = Lab;
  Object.defineProperty(Oklab, 'Companion', {
    get: Oklab$Companion_getInstance
  });
  package$lab.Oklab = Oklab;
  Object.defineProperty(Srlab2, 'Companion', {
    get: Srlab2$Companion_getInstance
  });
  package$lab.Srlab2 = Srlab2;
  Object.defineProperty(CieLch, 'Companion', {
    get: CieLch$Companion_getInstance
  });
  var package$lch = package$ucs.lch || (package$ucs.lch = {});
  package$lch.CieLch = CieLch;
  package$lch.Lch = Lch;
  package$lch.calcLchC_4ggnbf$ = calcLchC;
  package$lch.calcLchH_4ggnbf$ = calcLchH;
  package$lch.calcLabA_rqlp4d$ = calcLabA;
  package$lch.calcLabB_rqlp4d$ = calcLabB;
  Object.defineProperty(Oklch, 'Companion', {
    get: Oklch$Companion_getInstance
  });
  package$lch.Oklch = Oklch;
  Object.defineProperty(Srlch2, 'Companion', {
    get: Srlch2$Companion_getInstance
  });
  package$lch.Srlch2 = Srlch2;
  package$conversion.ColorConverter = ColorConverter;
  Object.defineProperty(package$conversion, 'ConversionGraph', {
    get: ConversionGraph_getInstance
  });
  package$conversion.UnsupportedConversionException_init = UnsupportedConversionException_init;
  package$conversion.UnsupportedConversionException = UnsupportedConversionException;
  var package$math = package$util.math || (package$util.math = {});
  package$math.cube_tq0o01$ = cube;
  package$math.square_tq0o01$ = square;
  package$math.toRadians_1zw1ma$ = toRadians;
  package$math.toDegrees_1zw1ma$ = toDegrees;
  package$math.cbrt_tq0o01$ = cbrt;
  Kotlin.defineModule('colorkt', _);
  return _;
}));

//# sourceMappingURL=colorkt.js.map
