/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.throttler;

import dev.katsute.simplehttpserver.HttpSession;
import dev.katsute.simplehttpserver.HttpSessionHandler;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.handler.throttler.ConnectionThrottler;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerSessionThrottler
extends ConnectionThrottler {
    private final HttpSessionHandler sessionHandler;
    private final Map<HttpSession, AtomicInteger> connections = new ConcurrentHashMap<HttpSession, AtomicInteger>();
    private final AtomicInteger connCount = new AtomicInteger(0);
    private final AtomicInteger maxConn = new AtomicInteger(-1);

    public ServerSessionThrottler(HttpSessionHandler sessionHandler) {
        this(sessionHandler, -1);
    }

    public ServerSessionThrottler(HttpSessionHandler sessionHandler, int maxConnections) {
        this.sessionHandler = Objects.requireNonNull(sessionHandler);
        this.maxConn.set(maxConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean addConnection(SimpleHttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        int sessionMaxConn = this.getMaxConnections(session, exchange);
        this.connections.putIfAbsent(session, new AtomicInteger(0));
        AtomicInteger conn = this.connections.get(session);
        boolean exempt = this.canIgnoreConnectionLimit(session, exchange);
        if (sessionMaxConn < 0) {
            if (!exempt) {
                int maxServerConn = this.maxConn.get();
                ServerSessionThrottler serverSessionThrottler = this;
                synchronized (serverSessionThrottler) {
                    if (maxServerConn < 0 || this.connCount.get() < maxServerConn) {
                        conn.incrementAndGet();
                        this.connCount.incrementAndGet();
                        return true;
                    }
                    return false;
                }
            }
            conn.incrementAndGet();
            return true;
        }
        if (!exempt) {
            int maxServerConn = this.maxConn.get();
            ServerSessionThrottler serverSessionThrottler = this;
            synchronized (serverSessionThrottler) {
                if (conn.get() < sessionMaxConn && (maxServerConn < 0 || this.connCount.get() < maxServerConn)) {
                    conn.incrementAndGet();
                    this.connCount.incrementAndGet();
                    return true;
                }
                return false;
            }
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < sessionMaxConn) {
                added.set(true);
            }
            return operand < sessionMaxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(SimpleHttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        if (this.connections.containsKey(session)) {
            this.connections.get(session).decrementAndGet();
            if (!this.canIgnoreConnectionLimit(session, exchange)) {
                this.connCount.decrementAndGet();
            }
        }
    }

    @Override
    public final int getMaxConnections(SimpleHttpExchange exchange) {
        return this.getMaxConnections(this.sessionHandler.getSession(exchange), exchange);
    }

    public int getMaxConnections(HttpSession session, SimpleHttpExchange exchange) {
        return -1;
    }

    public boolean canIgnoreConnectionLimit(HttpSession session, SimpleHttpExchange exchange) {
        return false;
    }

    public final synchronized void setMaxServerConnections(int connections) {
        this.maxConn.set(connections);
    }

    public final synchronized int getMaxServerConnections() {
        return this.maxConn.get();
    }

    public String toString() {
        return "ServerSessionThrottler{sessionHandler=" + this.sessionHandler + ", connections=" + this.connections + ", connCount=" + this.connCount + ", maxConn=" + this.maxConn + '}';
    }
}

