/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dev.katsute.simplehttpserver.ContextUtility;
import dev.katsute.simplehttpserver.HttpSession;
import dev.katsute.simplehttpserver.HttpSessionHandler;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpServer;
import dev.katsute.simplehttpserver.handler.RootHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;

final class SimpleHttpServerImpl
extends SimpleHttpServer {
    private final HttpServer server = HttpServer.create();
    private HttpSessionHandler sessionHandler;
    private final Map<HttpContext, HttpHandler> contexts = Collections.synchronizedMap(new HashMap());

    SimpleHttpServerImpl(Integer port, Integer backlog) throws IOException {
        if (port != null) {
            this.server.bind(new InetSocketAddress(port), backlog != null ? backlog : 0);
        }
    }

    private void handle(HttpExchange exchange) {
        if (this.sessionHandler != null) {
            this.sessionHandler.getSession(exchange).update();
        }
    }

    @Override
    public final HttpServer getHttpServer() {
        return this.server;
    }

    @Override
    public final synchronized InetSocketAddress bind(int port) throws IOException {
        return this.bind(port, null);
    }

    @Override
    public final synchronized InetSocketAddress bind(int port, int backlog) throws IOException {
        return this.bind(port, (Integer)backlog);
    }

    private synchronized InetSocketAddress bind(int port, Integer backlog) throws IOException {
        InetSocketAddress address = new InetSocketAddress(port);
        this.server.bind(address, backlog == null ? 0 : backlog);
        return address;
    }

    public synchronized void bind(InetSocketAddress address) throws IOException {
        this.bind(address, null);
    }

    @Override
    public synchronized void bind(InetSocketAddress address, int backlog) throws IOException {
        this.bind(address, (Integer)backlog);
    }

    private synchronized void bind(InetSocketAddress address, Integer backlog) throws IOException {
        this.server.bind(Objects.requireNonNull(address), backlog == null ? 0 : backlog);
    }

    @Override
    public final InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    @Override
    public final synchronized Executor getExecutor() {
        return this.server.getExecutor();
    }

    @Override
    public final synchronized void setExecutor(Executor executor) {
        this.server.setExecutor(executor);
    }

    @Override
    public final synchronized HttpSessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    @Override
    public final synchronized void setSessionHandler(HttpSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    @Override
    public final HttpSession getSession(HttpExchange exchange) {
        return this.sessionHandler != null ? this.sessionHandler.getSession(Objects.requireNonNull(exchange) instanceof SimpleHttpExchange ? ((SimpleHttpExchange)exchange).getHttpExchange() : exchange) : null;
    }

    @Override
    public final synchronized HttpContext createContext(String context) {
        return this.createContext(context, HttpExchange::close);
    }

    @Override
    public final synchronized HttpContext createContext(String context, HttpHandler handler) {
        String ct = ContextUtility.getContext(Objects.requireNonNull(context), true, false);
        if (!ct.equals("/") && Objects.requireNonNull(handler) instanceof RootHandler) {
            throw new IllegalArgumentException("RootHandler can only be used at the root '/' context");
        }
        HttpContext hc = this.server.createContext(ct);
        HttpHandler wrapper = exchange -> {
            this.handle(exchange);
            handler.handle(exchange);
        };
        hc.setHandler(wrapper);
        this.contexts.put(hc, handler);
        return hc;
    }

    @Override
    public final synchronized void removeContext(String context) {
        try {
            this.server.removeContext(ContextUtility.getContext(Objects.requireNonNull(context), true, false));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            for (HttpContext hc : this.contexts.keySet()) {
                if (!hc.getPath().equalsIgnoreCase(ContextUtility.getContext(context, true, false))) continue;
                this.contexts.remove(hc);
                break;
            }
        }
    }

    @Override
    public final synchronized void removeContext(HttpContext context) {
        Objects.requireNonNull(context);
        this.contexts.remove(context);
        this.server.removeContext(context);
    }

    @Override
    public final HttpHandler getContextHandler(String context) {
        Objects.requireNonNull(context);
        for (Map.Entry<HttpContext, HttpHandler> entry : this.contexts.entrySet()) {
            if (!entry.getKey().getPath().equals(ContextUtility.getContext(context, true, false))) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public final HttpHandler getContextHandler(HttpContext context) {
        return this.contexts.get(Objects.requireNonNull(context));
    }

    @Override
    public final Map<HttpContext, HttpHandler> getContexts() {
        return new HashMap<HttpContext, HttpHandler>(this.contexts);
    }

    @Override
    public final synchronized String getRandomContext() {
        return this.getRandomContext("");
    }

    @Override
    public final synchronized String getRandomContext(String context) {
        String targetContext;
        String head;
        String string = head = Objects.requireNonNull(context).isEmpty() ? "" : ContextUtility.getContext(context, true, false);
        while (this.getContextHandler(targetContext = head + ContextUtility.getContext(UUID.randomUUID().toString(), true, false)) != null) {
        }
        return targetContext;
    }

    @Override
    public final synchronized void start() {
        this.server.start();
    }

    @Override
    public final synchronized void stop() {
        this.stop(0);
    }

    @Override
    public final synchronized void stop(int delay) {
        this.server.stop(delay);
    }

    public String toString() {
        return "SimpleHttpServer{server=" + this.server + ", sessionHandler=" + this.sessionHandler + ", contexts=" + this.contexts + '}';
    }
}

