/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpServer;
import dev.katsute.simplehttpserver.FileRecord;
import dev.katsute.simplehttpserver.MultipartFormData;
import dev.katsute.simplehttpserver.Record;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

final class SimpleHttpExchangeImpl
extends SimpleHttpExchange {
    private static final Pattern boundaryHeaderPattern = Pattern.compile("(.*): (.*?)(?:$|; )(.*)");
    private static final Pattern contentDispositionKVPPattern = Pattern.compile("(.*?)=\"(.*?)\"(?:; |$)");
    private final HttpExchange exchange;
    private final String rawGet;
    private final Map<String, String> getMap;
    private final String rawPost;
    private final Map<String, ?> postMap;
    private final MultipartFormData multipartFormData;
    private final Map<String, String> cookies;

    private static Map<String, String> parseWwwFormEnc(String s) {
        String[] pairs;
        HashMap<String, String> OUT = new HashMap<String, String>();
        for (String pair : pairs = s.split("&")) {
            if (!pair.contains("=")) continue;
            String[] kv = pair.split("=");
            try {
                OUT.put(URLDecoder.decode(kv[0], "UTF-8"), kv.length == 2 ? URLDecoder.decode(kv[1], "UTF-8") : null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return OUT;
    }

    /*
     * WARNING - void declaration
     */
    SimpleHttpExchangeImpl(HttpExchange exchange) {
        String OUT;
        this.exchange = Objects.requireNonNull(exchange);
        this.rawGet = exchange.getRequestURI().getRawQuery();
        this.getMap = this.rawGet == null ? new HashMap() : SimpleHttpExchangeImpl.parseWwwFormEnc(this.rawGet);
        try (InputStream IN = exchange.getRequestBody();
             Scanner scanner = new Scanner(IN, "UTF-8");){
            OUT = scanner.useDelimiter("\\A").next();
        }
        catch (IOException | NoSuchElementException ignored) {
            OUT = null;
        }
        this.rawPost = OUT;
        if (this.rawPost != null) {
            String content_type = exchange.getRequestHeaders().getFirst("Content-type");
            if (content_type != null && content_type.startsWith("multipart/form-data")) {
                void var11_18;
                String[] pairs;
                String webkitBoundary = content_type.substring(content_type.indexOf("; boundary=") + 11);
                String startBoundary = "--" + webkitBoundary + "\r\n";
                String endBoundary = "--" + webkitBoundary + "--\r\n";
                HashMap postMap_buffer = new HashMap();
                String[] stringArray = pairs = OUT.replace(endBoundary, "").split(Pattern.quote(startBoundary));
                int n = stringArray.length;
                boolean bl = false;
                while (var11_18 < n) {
                    String pair = stringArray[var11_18];
                    HashMap postHeaders = new HashMap();
                    if (pair.contains("\r\n\r\n")) {
                        String[] headers;
                        for (String header : headers = pair.substring(0, pair.indexOf("\r\n\r\n")).split("\r\n")) {
                            HashMap<String, Object> headerMap = new HashMap<String, Object>();
                            HashMap<String, String> val = new HashMap<String, String>();
                            Matcher headerMatcher = boundaryHeaderPattern.matcher(header);
                            if (headerMatcher.find()) {
                                Matcher contentDispositionKVPMatcher = contentDispositionKVPPattern.matcher(headerMatcher.group(3));
                                while (contentDispositionKVPMatcher.find()) {
                                    val.put(contentDispositionKVPMatcher.group(1), contentDispositionKVPMatcher.group(2));
                                }
                                headerMap.put("header-name", headerMatcher.group(1));
                                headerMap.put("header-value", headerMatcher.group(2));
                                headerMap.put("parameters", val);
                            }
                            postHeaders.put((String)headerMap.get("header-name"), headerMap);
                        }
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        row.put("headers", postHeaders);
                        row.put("value", pair.substring(pair.indexOf("\r\n\r\n") + 4, pair.lastIndexOf("\r\n")));
                        postMap_buffer.put((String)((Map)((Map)postHeaders.get("Content-Disposition")).get("parameters")).get("name"), row);
                    }
                    ++var11_18;
                }
                HashMap<String, Record> form_buffer = new HashMap<String, Record>();
                for (Map.Entry<String, Map<String, ?>> entry : postMap_buffer.entrySet()) {
                    try {
                        form_buffer.put((String)entry.getKey(), new FileRecord(entry));
                    }
                    catch (NullPointerException ignored) {
                        try {
                            form_buffer.put((String)entry.getKey(), new Record(entry));
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    catch (ClassCastException ignored) {
                        form_buffer = Collections.emptyMap();
                        break;
                    }
                }
                this.postMap = postMap_buffer;
                this.multipartFormData = form_buffer.isEmpty() ? null : new MultipartFormData(form_buffer);
            } else {
                this.postMap = SimpleHttpExchangeImpl.parseWwwFormEnc(this.rawPost);
                this.multipartFormData = null;
            }
        } else {
            this.postMap = new HashMap();
            this.multipartFormData = null;
        }
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : Objects.requireNonNull(exchange).getRequestHeaders().entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("Cookie")) continue;
            for (String value : entry.getValue()) {
                String[] pair = value.split("=");
                cookies.put(pair[0], pair[1]);
            }
        }
        this.cookies = cookies;
    }

    @Override
    public final HttpServer getHttpServer() {
        return this.exchange.getHttpContext().getServer();
    }

    @Override
    public final HttpExchange getHttpExchange() {
        return this.exchange;
    }

    @Override
    public final URI getRequestURI() {
        return this.exchange.getRequestURI();
    }

    @Override
    public final String getRequestMethod() {
        return this.exchange.getRequestMethod();
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        return this.exchange.getLocalAddress();
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        return this.exchange.getRemoteAddress();
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.exchange.getHttpContext();
    }

    @Override
    public final HttpPrincipal getPrincipal() {
        return this.exchange.getPrincipal();
    }

    @Override
    public final String getProtocol() {
        return this.exchange.getProtocol();
    }

    @Override
    public final Headers getRequestHeaders() {
        return this.exchange.getRequestHeaders();
    }

    @Override
    public final InputStream getRequestBody() {
        return this.exchange.getRequestBody();
    }

    @Override
    public final Object getAttribute(String name) {
        return this.exchange.getAttribute(name);
    }

    @Override
    public final void setAttribute(String name, Object value) {
        this.exchange.setAttribute(name, value);
    }

    @Override
    public final void setStreams(InputStream i, OutputStream o) {
        this.exchange.setStreams(i, o);
    }

    @Override
    public final String getRawGet() {
        return this.rawGet;
    }

    @Override
    public final Map<String, String> getGetMap() {
        return new HashMap<String, String>(this.getMap);
    }

    @Override
    public final boolean hasGet() {
        return this.rawGet != null;
    }

    @Override
    public final String getRawPost() {
        return this.rawPost;
    }

    public final Map<String, Object> getPostMap() {
        return new HashMap<String, Object>(this.postMap);
    }

    @Override
    public final MultipartFormData getMultipartFormData() {
        return this.multipartFormData;
    }

    @Override
    public final boolean hasPost() {
        return this.rawPost != null;
    }

    @Override
    public final String getCookie(String cookie) {
        return this.cookies.get(Objects.requireNonNull(cookie));
    }

    @Override
    public final Map<String, String> getCookies() {
        return new HashMap<String, String>(this.cookies);
    }

    @Override
    public final synchronized void setCookie(String key, String value) {
        this.setCookie(new HttpCookie(Objects.requireNonNull(key), Objects.requireNonNull(value)));
    }

    @Override
    public final synchronized void setCookie(HttpCookie cookie) {
        this.exchange.getResponseHeaders().add("Set-Cookie", Objects.requireNonNull(cookie).toString());
    }

    @Override
    public final int getResponseCode() {
        return this.exchange.getResponseCode();
    }

    @Override
    public final Headers getResponseHeaders() {
        return this.exchange.getResponseHeaders();
    }

    @Override
    public final OutputStream getResponseBody() {
        return this.exchange.getResponseBody();
    }

    @Override
    public final synchronized void sendResponseHeaders(int code, long length) throws IOException {
        this.exchange.sendResponseHeaders(code, length);
    }

    @Override
    public final synchronized void send(int responseCode) throws IOException {
        this.sendResponseHeaders(responseCode, 0L);
    }

    @Override
    public final synchronized void send(byte[] response) throws IOException {
        this.send(response, 200, false);
    }

    @Override
    public final void send(byte[] response, boolean gzip) throws IOException {
        this.send(response, 200, gzip);
    }

    @Override
    public final synchronized void send(byte[] response, int responseCode) throws IOException {
        this.send(response, responseCode, false);
    }

    @Override
    public final void send(byte[] response, int responseCode, boolean gzip) throws IOException {
        block18: {
            if (gzip) {
                this.exchange.getResponseHeaders().set("Accept-Encoding", "gzip");
                this.exchange.getResponseHeaders().set("Content-Encoding", "gzip");
                this.exchange.getResponseHeaders().set("Connection", "keep-alive");
                this.sendResponseHeaders(responseCode, 0L);
                try (OutputStream OS = this.exchange.getResponseBody();
                     GZIPOutputStream OUT = new GZIPOutputStream(OS);){
                    OUT.write(Objects.requireNonNull(response));
                    OUT.finish();
                    OUT.flush();
                    break block18;
                }
            }
            this.sendResponseHeaders(responseCode, response.length);
            try (OutputStream OUT = this.exchange.getResponseBody();){
                OUT.write(response);
                OUT.flush();
            }
        }
    }

    @Override
    public final synchronized void send(String response) throws IOException {
        this.send(response, 200, false);
    }

    @Override
    public final void send(String response, boolean gzip) throws IOException {
        this.send(response, 200, gzip);
    }

    @Override
    public final synchronized void send(String response, int responseCode) throws IOException {
        this.send(response, responseCode, false);
    }

    @Override
    public final void send(String response, int responseCode, boolean gzip) throws IOException {
        this.send(Objects.requireNonNull(response).getBytes(StandardCharsets.UTF_8), responseCode, gzip);
    }

    @Override
    public final void send(File file) throws IOException {
        this.send(file, 200, false);
    }

    @Override
    public final void send(File file, boolean gzip) throws IOException {
        this.send(file, 200, gzip);
    }

    @Override
    public final void send(File file, int responseCode) throws IOException {
        this.send(file, responseCode, false);
    }

    @Override
    public final void send(File file, int responseCode, boolean gzip) throws IOException {
        this.send(Files.readAllBytes(Objects.requireNonNull(file).toPath()), responseCode, gzip);
    }

    @Override
    public final synchronized void close() {
        try {
            this.exchange.getResponseBody().close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.exchange.close();
        }
    }

    public String toString() {
        return "SimpleHttpExchange{exchange=" + this.exchange + ", rawGet='" + this.rawGet + '\'' + ", getMap=" + this.getMap + ", rawPost='" + this.rawPost + '\'' + ", postMap=" + this.postMap + ", multipartFormData=" + this.multipartFormData + ", cookies=" + this.cookies + '}';
    }
}

