/*
 * Decompiled with CFR 0.152.
 */
package dev.joss.jason.utils;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import dev.joss.jason.models.JsonType;
import dev.joss.jason.models.ParsedJsonStringResult;
import dev.joss.jason.models.ReadJsonPathResult;
import java.util.List;
import java.util.Map;

public class JsonParsingUtils {
    public static ReadJsonPathResult<Boolean> getJsonPathBooleanResultIfValid(DocumentContext documentContext, String jsonPath) {
        try {
            Object rawResult = documentContext.read(jsonPath, new Predicate[0]);
            Boolean result = (Boolean)rawResult;
            return ReadJsonPathResult.success(result);
        }
        catch (ClassCastException exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructTypeCastErrorMessage(jsonPath, JsonType.BOOLEAN));
        }
        catch (PathNotFoundException exception) {
            return ReadJsonPathResult.failure(exception.getLocalizedMessage());
        }
        catch (Exception exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructUnknownErrorMessage(jsonPath, exception.getMessage()));
        }
    }

    public static ReadJsonPathResult<String> getJsonPathStringResultIfValid(DocumentContext documentContext, String jsonPath) {
        try {
            Object rawResult = documentContext.read(jsonPath, new Predicate[0]);
            String result = (String)rawResult;
            return ReadJsonPathResult.success(result);
        }
        catch (ClassCastException exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructTypeCastErrorMessage(jsonPath, JsonType.STRING));
        }
        catch (PathNotFoundException exception) {
            return ReadJsonPathResult.failure(exception.getLocalizedMessage());
        }
        catch (Exception exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructUnknownErrorMessage(jsonPath, exception.getMessage()));
        }
    }

    public static ReadJsonPathResult<Map<String, Object>> getJsonPathObjectResultIfValid(DocumentContext documentContext, String jsonPath) {
        try {
            Object rawResult = documentContext.read(jsonPath, new Predicate[0]);
            Map result = (Map)rawResult;
            return ReadJsonPathResult.success(result);
        }
        catch (ClassCastException exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructTypeCastErrorMessage(jsonPath, JsonType.OBJECT));
        }
        catch (PathNotFoundException exception) {
            return ReadJsonPathResult.failure(exception.getLocalizedMessage());
        }
        catch (Exception exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructUnknownErrorMessage(jsonPath, exception.getMessage()));
        }
    }

    public static ReadJsonPathResult<List<Object>> getJsonPathArrayResultIfValid(DocumentContext documentContext, String jsonPath) {
        try {
            Object rawResult = documentContext.read(jsonPath, new Predicate[0]);
            List result = (List)rawResult;
            return ReadJsonPathResult.success(result);
        }
        catch (ClassCastException exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructTypeCastErrorMessage(jsonPath, JsonType.ARRAY));
        }
        catch (PathNotFoundException exception) {
            return ReadJsonPathResult.failure(exception.getLocalizedMessage());
        }
        catch (Exception exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructUnknownErrorMessage(jsonPath, exception.getMessage()));
        }
    }

    public static ReadJsonPathResult<Double> getJsonPathNumberResultIfValid(DocumentContext documentContext, String jsonPath) {
        try {
            Number rawResult = (Number)documentContext.read(jsonPath, new Predicate[0]);
            Double result = rawResult.doubleValue();
            return ReadJsonPathResult.success(result);
        }
        catch (ClassCastException exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructTypeCastErrorMessage(jsonPath, JsonType.NUMBER));
        }
        catch (PathNotFoundException exception) {
            return ReadJsonPathResult.failure(exception.getLocalizedMessage());
        }
        catch (Exception exception) {
            return ReadJsonPathResult.failure(JsonParsingUtils.constructUnknownErrorMessage(jsonPath, exception.getMessage()));
        }
    }

    public static ParsedJsonStringResult getDocumentContextIfValid(String jsonString) {
        try {
            DocumentContext documentContext = JsonPath.parse((String)jsonString.strip());
            return ParsedJsonStringResult.success(documentContext);
        }
        catch (Exception exception) {
            return ParsedJsonStringResult.failure(exception.getLocalizedMessage());
        }
    }

    private static String constructTypeCastErrorMessage(String jsonPath, JsonType jsonType) {
        return String.format("The value at path %s, could not be converted to a JSON %s Type.", jsonPath, jsonType.getTypeName());
    }

    private static String constructUnknownErrorMessage(String jsonPath, String exceptionMessage) {
        return String.format("When attempting to convert value at path %s, caused an unexpected error. The exception was: %s.", jsonPath, exceptionMessage);
    }
}

