/*
 * Decompiled with CFR 0.152.
 */
package dev.joss.jason.models;

import java.util.Optional;

public class ReadJsonPathResult<T> {
    private final T result;
    private final String errorMessage;

    private ReadJsonPathResult(T result, String errorMessage) {
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public static <U> ReadJsonPathResult<U> success(U value) {
        return new ReadJsonPathResult<U>(value, null);
    }

    public static <U> ReadJsonPathResult<U> failure(String errorMessage) {
        return new ReadJsonPathResult<Object>(null, errorMessage);
    }

    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }
}

