/*
 * Decompiled with CFR 0.152.
 */
package dev.joss.jason;

import com.jayway.jsonpath.DocumentContext;
import dev.joss.jason.assertions.JsonArrayAssert;
import dev.joss.jason.assertions.JsonBooleanAssert;
import dev.joss.jason.assertions.JsonNumericAssert;
import dev.joss.jason.assertions.JsonObjectAssert;
import dev.joss.jason.assertions.JsonStringAssert;
import dev.joss.jason.assertions.JsonTypeAssert;
import dev.joss.jason.models.ParsedJsonStringResult;
import dev.joss.jason.models.ReadJsonPathResult;
import dev.joss.jason.utils.JsonParsingUtils;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;

public class JasonAssert
extends AbstractAssert<JasonAssert, String>
implements JsonTypeAssert {
    private final ParsedJsonStringResult parsedJsonStringResult;

    private JasonAssert(String actualJson) {
        super((Object)actualJson, JasonAssert.class);
        this.parsedJsonStringResult = JsonParsingUtils.getDocumentContextIfValid(actualJson);
    }

    public static JasonAssert assertThatJson(String actualJson) {
        return new JasonAssert(actualJson);
    }

    @Override
    public JsonStringAssert stringAtPath(String jsonPath) {
        this.isValidJson();
        DocumentContext documentContext = this.parsedJsonStringResult.getDocumentContext().orElseThrow();
        ReadJsonPathResult<String> readJsonPathResult = JsonParsingUtils.getJsonPathStringResultIfValid(documentContext, jsonPath);
        if (readJsonPathResult.getErrorMessage().isPresent()) {
            this.failWithMessage(readJsonPathResult.getErrorMessage().get(), new Object[0]);
        }
        return new JsonStringAssert(this, readJsonPathResult.getResult().orElseThrow());
    }

    @Override
    public JsonNumericAssert numberAtPath(String jsonPath) {
        this.isValidJson();
        DocumentContext documentContext = this.parsedJsonStringResult.getDocumentContext().orElseThrow();
        ReadJsonPathResult<Double> readJsonPathResult = JsonParsingUtils.getJsonPathNumberResultIfValid(documentContext, jsonPath);
        if (readJsonPathResult.getErrorMessage().isPresent()) {
            this.failWithMessage(readJsonPathResult.getErrorMessage().get(), new Object[0]);
        }
        return new JsonNumericAssert(this, readJsonPathResult.getResult().orElseThrow());
    }

    @Override
    public JsonBooleanAssert booleanAtPath(String jsonPath) {
        this.isValidJson();
        DocumentContext documentContext = this.parsedJsonStringResult.getDocumentContext().orElseThrow();
        ReadJsonPathResult<Boolean> readJsonPathResult = JsonParsingUtils.getJsonPathBooleanResultIfValid(documentContext, jsonPath);
        if (readJsonPathResult.getErrorMessage().isPresent()) {
            this.failWithMessage(readJsonPathResult.getErrorMessage().get(), new Object[0]);
        }
        return new JsonBooleanAssert(this, readJsonPathResult.getResult().orElseThrow());
    }

    @Override
    public JsonObjectAssert objectAtPath(String jsonPath) {
        this.isValidJson();
        DocumentContext documentContext = this.parsedJsonStringResult.getDocumentContext().orElseThrow();
        ReadJsonPathResult<Map<String, Object>> readJsonPathResult = JsonParsingUtils.getJsonPathObjectResultIfValid(documentContext, jsonPath);
        if (readJsonPathResult.getErrorMessage().isPresent()) {
            this.failWithMessage(readJsonPathResult.getErrorMessage().orElseThrow(), new Object[0]);
        }
        return new JsonObjectAssert(this, readJsonPathResult.getResult().orElseThrow());
    }

    @Override
    public JsonArrayAssert arrayAtPath(String jsonPath) {
        this.isValidJson();
        DocumentContext documentContext = this.parsedJsonStringResult.getDocumentContext().orElseThrow();
        ReadJsonPathResult<List<Object>> readJsonPathResult = JsonParsingUtils.getJsonPathArrayResultIfValid(documentContext, jsonPath);
        if (readJsonPathResult.getErrorMessage().isPresent()) {
            this.failWithMessage(readJsonPathResult.getErrorMessage().get(), new Object[0]);
        }
        return new JsonArrayAssert(this, readJsonPathResult.getResult().orElseThrow());
    }

    private JasonAssert isValidJson() {
        this.isNotNull();
        if (this.parsedJsonStringResult.getErrorMessage().isPresent()) {
            this.failWithMessage("Could not parse JSON data: " + this.parsedJsonStringResult.getErrorMessage().get(), new Object[0]);
        }
        return this;
    }
}

