/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.nms.NMS;
import java.util.Collection;

public class ScoreHolderArgument<T>
extends Argument<T> {
    private final boolean single;

    public ScoreHolderArgument(String nodeName) {
        this(nodeName, ScoreHolderType.SINGLE);
    }

    @Deprecated(forRemoval=true, since="8.7.0")
    public ScoreHolderArgument(String nodeName, ScoreHolderType type) {
        super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentScoreholder(ArgumentSubType.SCOREHOLDER_SINGLE));
        this.single = type == ScoreHolderType.SINGLE;
    }

    public boolean isSingle() {
        return this.single;
    }

    @Override
    public Class<T> getPrimitiveType() {
        return this.single ? String.class : Collection.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.SCORE_HOLDER;
    }

    @Override
    public <CommandListenerWrapper> T parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        return (T)(this.single ? nms.getScoreHolderSingle(cmdCtx, key) : nms.getScoreHolderMultiple(cmdCtx, key));
    }

    @Deprecated(forRemoval=true, since="8.7.0")
    public static enum ScoreHolderType {
        SINGLE,
        MULTIPLE;

    }

    public static class Multiple
    extends Argument<Collection> {
        public Multiple(String nodeName) {
            super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentScoreholder(ArgumentSubType.SCOREHOLDER_MULTIPLE));
        }

        @Override
        public Class<Collection> getPrimitiveType() {
            return Collection.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.SCORE_HOLDER;
        }

        @Override
        public <CommandSourceStack> Collection<String> parseArgument(NMS<CommandSourceStack> nms, CommandContext<CommandSourceStack> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
            return nms.getScoreHolderMultiple(cmdCtx, key);
        }
    }

    public static class Single
    extends ScoreHolderArgument<Object> {
        public Single(String nodeName) {
            super(nodeName);
        }
    }
}

