/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.nms.NMS;
import org.bukkit.Location;

public class LocationArgument
extends SafeOverrideableArgument<Location, Location> {
    private final boolean isPrecise;

    public LocationArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public LocationArgument(String nodeName, LocationType type) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIHandler.getInstance().getNMS()._ArgumentPosition() : CommandAPIHandler.getInstance().getNMS()._ArgumentVec3(), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockY() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getY() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location> getPrimitiveType() {
        return Location.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION;
    }

    @Override
    public <CommandListenerWrapper> Location parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? nms.getLocationPrecise(cmdCtx, key) : nms.getLocationBlock(cmdCtx, key);
    }
}

