/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.Tooltip;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;

@FunctionalInterface
public interface SafeSuggestions<S> {
    public ArgumentSuggestions toSuggestions(Function<S, String> var1);

    public static <T> SafeSuggestions<T> empty() {
        return mapper -> ArgumentSuggestions.empty();
    }

    @SafeVarargs
    public static <T> SafeSuggestions<T> suggest(T ... suggestions) {
        return mapper -> ArgumentSuggestions.strings(SafeSuggestions.toStrings(mapper, suggestions));
    }

    public static <T> SafeSuggestions<T> suggest(Collection<T> suggestions) {
        return mapper -> ArgumentSuggestions.strings(SafeSuggestions.toStrings(mapper, suggestions));
    }

    public static <T> SafeSuggestions<T> suggest(Function<SuggestionInfo, T[]> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollection(info -> SafeSuggestions.toStrings(mapper, (Object[])suggestions.apply((SuggestionInfo)info)));
    }

    public static <T> SafeSuggestions<T> suggestCollection(Function<SuggestionInfo, Collection<T>> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollection(info -> SafeSuggestions.toStrings(mapper, (Collection)suggestions.apply((SuggestionInfo)info)));
    }

    public static <T> SafeSuggestions<T> suggestAsync(Function<SuggestionInfo, CompletableFuture<T[]>> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStrings(mapper, items)));
    }

    public static <T> SafeSuggestions<T> suggestCollectionAsync(Function<SuggestionInfo, CompletableFuture<Collection<T>>> suggestions) {
        return mapper -> ArgumentSuggestions.stringCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStrings(mapper, items)));
    }

    @SafeVarargs
    public static <T> SafeSuggestions<T> tooltips(Tooltip<T> ... suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltips(SafeSuggestions.toStringsWithTooltips(mapper, suggestions));
    }

    public static <T> SafeSuggestions<T> tooltips(Collection<Tooltip<T>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltips(SafeSuggestions.toStringsWithTooltips(mapper, suggestions));
    }

    public static <T> SafeSuggestions<T> tooltips(Function<SuggestionInfo, Tooltip<T>[]> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollection(info -> SafeSuggestions.toStringsWithTooltips(mapper, (Tooltip[])suggestions.apply((SuggestionInfo)info)));
    }

    public static <T> SafeSuggestions<T> tooltipCollection(Function<SuggestionInfo, Collection<Tooltip<T>>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollection(info -> SafeSuggestions.toStringsWithTooltips(mapper, (Collection)suggestions.apply((SuggestionInfo)info)));
    }

    public static <T> SafeSuggestions<T> tooltipsAsync(Function<SuggestionInfo, CompletableFuture<Tooltip<T>[]>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStringsWithTooltips(mapper, items)));
    }

    public static <T> SafeSuggestions<T> tooltipCollectionAsync(Function<SuggestionInfo, CompletableFuture<Collection<Tooltip<T>>>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsCollectionAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStringsWithTooltips(mapper, items)));
    }

    @SafeVarargs
    private static <T> Collection<String> toStrings(Function<T, String> mapper, T ... suggestions) {
        return Arrays.stream(suggestions).map(mapper).toList();
    }

    private static <T> Collection<String> toStrings(Function<T, String> mapper, Collection<T> suggestions) {
        return suggestions.stream().map(mapper).toList();
    }

    @SafeVarargs
    private static <T> Collection<IStringTooltip> toStringsWithTooltips(Function<T, String> mapper, Tooltip<T> ... suggestions) {
        return SafeSuggestions.toStringsWithTooltips(mapper, Arrays.stream(suggestions));
    }

    private static <T> Collection<IStringTooltip> toStringsWithTooltips(Function<T, String> mapper, Collection<Tooltip<T>> suggestions) {
        return SafeSuggestions.toStringsWithTooltips(mapper, suggestions.stream());
    }

    private static <T> Collection<IStringTooltip> toStringsWithTooltips(Function<T, String> mapper, Stream<Tooltip<T>> suggestions) {
        Function<Tooltip, IStringTooltip> builder = Tooltip.build(mapper)::apply;
        return suggestions.map(builder).toList();
    }
}

