/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.Executable;
import dev.jorel.commandapi.Execution;
import dev.jorel.commandapi.arguments.Argument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArgumentTree
extends Executable<ArgumentTree> {
    final List<ArgumentTree> arguments = new ArrayList<ArgumentTree>();
    final Argument<?> argument;

    protected ArgumentTree() {
        ArgumentTree argumentTree = this;
        if (!(argumentTree instanceof Argument)) {
            throw new IllegalArgumentException("Implicit inherited constructor must be from Argument");
        }
        Argument argument = (Argument)argumentTree;
        this.argument = argument;
    }

    public ArgumentTree(Argument<?> argument) {
        this.argument = argument;
        this.executor = argument.executor;
    }

    public ArgumentTree then(ArgumentTree tree) {
        this.arguments.add(tree);
        return this;
    }

    List<Execution> getExecutions() {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        if (this.executor.hasAnyExecutors()) {
            executions.add(new Execution(Arrays.asList(this.argument), this.executor));
        }
        for (ArgumentTree tree : this.arguments) {
            for (Execution execution : tree.getExecutions()) {
                executions.add(execution.prependedBy(this.argument));
            }
        }
        return executions;
    }
}

