/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.exceptions.InvalidRangeException;
import dev.jorel.commandapi.nms.NMS;

public class FloatArgument
extends SafeOverrideableArgument<Float, Float> {
    public FloatArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg(), String::valueOf);
    }

    public FloatArgument(String nodeName, float min) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min), String::valueOf);
    }

    public FloatArgument(String nodeName, float min, float max) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min, (float)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Float> getPrimitiveType() {
        return Float.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_FLOAT;
    }

    @Override
    public <CommandListenerWrapper> Float parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return (Float)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

