/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.nms.NMS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntitySelectorArgument<T>
extends Argument<T> {
    private final EntitySelector selector;

    public EntitySelectorArgument(String nodeName) {
        this(nodeName, EntitySelector.ONE_ENTITY);
    }

    public EntitySelectorArgument(String nodeName, EntitySelector selector) {
        super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentEntity(selector));
        this.selector = selector;
    }

    @Override
    public Class<T> getPrimitiveType() {
        return switch (this.selector) {
            case EntitySelector.MANY_ENTITIES, EntitySelector.MANY_PLAYERS -> Collection.class;
            case EntitySelector.ONE_ENTITY -> Entity.class;
            case EntitySelector.ONE_PLAYER -> Player.class;
            default -> Collection.class;
        };
    }

    public EntitySelector getEntitySelector() {
        return this.selector;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ENTITY_SELECTOR;
    }

    @Override
    public <CommandListenerWrapper> T parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return (T)nms.getEntitySelector(cmdCtx, key, this.selector);
    }

    public List<String> getEntityNames(Object argument) {
        return switch (this.selector) {
            case EntitySelector.MANY_ENTITIES -> {
                List entities = (List)argument;
                ArrayList<String> entityNames = new ArrayList<String>();
                for (Entity entity : entities) {
                    entityNames.add(entity.getName());
                }
                yield entityNames;
            }
            case EntitySelector.MANY_PLAYERS -> {
                List players = (List)argument;
                ArrayList<String> playerNames = new ArrayList<String>();
                for (Player player : players) {
                    playerNames.add(player.getName());
                }
                yield playerNames;
            }
            case EntitySelector.ONE_ENTITY -> {
                Entity entity = (Entity)argument;
                yield List.of(entity.getName());
            }
            case EntitySelector.ONE_PLAYER -> {
                Player player = (Player)argument;
                yield List.of(player.getName());
            }
            default -> throw new IllegalStateException("Invalid selector " + this.selector.name());
        };
    }

    public static enum EntitySelector {
        ONE_ENTITY,
        ONE_PLAYER,
        MANY_ENTITIES,
        MANY_PLAYERS;

    }
}

