/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Message;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.Tooltip;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;

public class StringTooltip
implements IStringTooltip {
    private final String suggestion;
    private final Message tooltip;

    @Deprecated(forRemoval=true)
    public static StringTooltip of(String suggestion, String tooltip) {
        return StringTooltip.ofString(suggestion, tooltip);
    }

    public static StringTooltip ofString(String suggestion, String tooltip) {
        return StringTooltip.ofMessage(suggestion, Tooltip.messageFromString(tooltip));
    }

    public static StringTooltip ofMessage(String suggestion, Message tooltip) {
        return tooltip == null ? StringTooltip.none(suggestion) : new StringTooltip(suggestion, tooltip);
    }

    public static StringTooltip ofBaseComponents(String suggestion, BaseComponent ... tooltip) {
        return StringTooltip.ofMessage(suggestion, Tooltip.messageFromBaseComponents(tooltip));
    }

    public static StringTooltip ofAdventureComponent(String suggestion, Component tooltip) {
        return StringTooltip.ofMessage(suggestion, Tooltip.messageFromAdventureComponent(tooltip));
    }

    public static StringTooltip none(String suggestion) {
        return new StringTooltip(suggestion, null);
    }

    public static Collection<StringTooltip> none(String ... suggestions) {
        return StringTooltip.generate(String::toString, (String s, T t) -> StringTooltip.none(s), suggestions);
    }

    public static Collection<StringTooltip> none(Collection<String> suggestions) {
        return StringTooltip.generate(String::toString, (String s, T t) -> StringTooltip.none(s), suggestions);
    }

    public static Collection<StringTooltip> generateStrings(Function<String, String> tooltipGenerator, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofString, suggestions);
    }

    public static Collection<StringTooltip> generateStrings(Function<String, String> tooltipGenerator, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofString, suggestions);
    }

    public static Collection<StringTooltip> generateMessages(Function<String, Message> tooltipGenerator, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofMessage, suggestions);
    }

    public static Collection<StringTooltip> generateMessages(Function<String, Message> tooltipGenerator, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofMessage, suggestions);
    }

    public static Collection<StringTooltip> generateBaseComponents(Function<String, BaseComponent[]> tooltipGenerator, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofBaseComponents, suggestions);
    }

    public static Collection<StringTooltip> generateBaseComponents(Function<String, BaseComponent[]> tooltipGenerator, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofBaseComponents, suggestions);
    }

    public static Collection<StringTooltip> generateAdventureComponents(Function<String, Component> tooltipGenerator, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofAdventureComponent, suggestions);
    }

    public static Collection<StringTooltip> generateAdventureComponents(Function<String, Component> tooltipGenerator, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofAdventureComponent, suggestions);
    }

    private static <T> Collection<StringTooltip> generate(Function<String, T> tooltipGenerator, BiFunction<String, T, StringTooltip> tooltipWrapper, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, tooltipWrapper, Arrays.stream(suggestions));
    }

    private static <T> Collection<StringTooltip> generate(Function<String, T> tooltipGenerator, BiFunction<String, T, StringTooltip> tooltipWrapper, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, tooltipWrapper, suggestions.stream());
    }

    private static <T> Collection<StringTooltip> generate(Function<String, T> tooltipGenerator, BiFunction<String, T, StringTooltip> tooltipWrapper, Stream<String> suggestions) {
        Function<String, StringTooltip> builder = suggestion -> (StringTooltip)tooltipWrapper.apply((String)suggestion, (Object)tooltipGenerator.apply((String)suggestion));
        return suggestions.map(builder).toList();
    }

    private StringTooltip(String suggestion, Message tooltip) {
        this.suggestion = suggestion;
        this.tooltip = tooltip;
    }

    @Override
    public String getSuggestion() {
        return this.suggestion;
    }

    @Override
    public Message getTooltip() {
        return this.tooltip;
    }
}

