/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.ItemEnchantmentArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.MobEffectArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.phys.Vec2;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public abstract class NMS_Common
implements NMS<CommandSourceStack> {
    private static NamespacedKey fromResourceLocation(ResourceLocation key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getPath()));
    }

    public final ArgumentType<?> _ArgumentAngle() {
        return AngleArgument.angle();
    }

    public final ArgumentType<?> _ArgumentAxis() {
        return SwizzleArgument.swizzle();
    }

    public abstract ArgumentType<?> _ArgumentBlockPredicate();

    public abstract ArgumentType<?> _ArgumentBlockState();

    public final ArgumentType<?> _ArgumentChat() {
        return MessageArgument.message();
    }

    public final ArgumentType<?> _ArgumentChatComponent() {
        return ComponentArgument.textComponent();
    }

    public final ArgumentType<?> _ArgumentChatFormat() {
        return ColorArgument.color();
    }

    public ArgumentType<?> _ArgumentDimension() {
        return DimensionArgument.dimension();
    }

    public final ArgumentType<?> _ArgumentEnvironment() {
        return DimensionArgument.dimension();
    }

    public ArgumentType<?> _ArgumentEnchantment() {
        return ItemEnchantmentArgument.enchantment();
    }

    public abstract ArgumentType<?> _ArgumentEntity(ArgumentSubType var1);

    public ArgumentType<?> _ArgumentEntitySummon() {
        return EntitySummonArgument.id();
    }

    public final ArgumentType<?> _ArgumentFloatRange() {
        return RangeArgument.floatRange();
    }

    public final ArgumentType<?> _ArgumentIntRange() {
        return RangeArgument.intRange();
    }

    public abstract ArgumentType<?> _ArgumentItemPredicate();

    public abstract ArgumentType<?> _ArgumentItemStack();

    public final ArgumentType<?> _ArgumentMathOperation() {
        return OperationArgument.operation();
    }

    public final ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ResourceLocationArgument.id();
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return MobEffectArgument.effect();
    }

    public final ArgumentType<?> _ArgumentNBTCompound() {
        return CompoundTagArgument.compoundTag();
    }

    public ArgumentType<?> _ArgumentParticle() {
        return ParticleArgument.particle();
    }

    public final ArgumentType<?> _ArgumentPosition() {
        return BlockPosArgument.blockPos();
    }

    public final ArgumentType<?> _ArgumentPosition2D() {
        return ColumnPosArgument.columnPos();
    }

    public final ArgumentType<?> _ArgumentProfile() {
        return GameProfileArgument.gameProfile();
    }

    public final ArgumentType<?> _ArgumentRotation() {
        return RotationArgument.rotation();
    }

    public final ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ObjectiveCriteriaArgument.criteria();
    }

    public final ArgumentType<?> _ArgumentScoreboardObjective() {
        return ObjectiveArgument.objective();
    }

    public final ArgumentType<?> _ArgumentScoreboardSlot() {
        return ScoreboardSlotArgument.displaySlot();
    }

    public final ArgumentType<?> _ArgumentScoreboardTeam() {
        return TeamArgument.team();
    }

    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ScoreHolderArgument.scoreHolder();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ScoreHolderArgument.scoreHolders();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public abstract ArgumentType<?> _ArgumentSyntheticBiome();

    public final ArgumentType<?> _ArgumentTag() {
        return FunctionArgument.functions();
    }

    public final ArgumentType<?> _ArgumentTime() {
        return TimeArgument.time();
    }

    public final ArgumentType<?> _ArgumentUUID() {
        return UuidArgument.uuid();
    }

    public final ArgumentType<?> _ArgumentVec2() {
        return Vec2Argument.vec2();
    }

    public final ArgumentType<?> _ArgumentVec3() {
        return Vec3Argument.vec3();
    }

    public abstract void addToHelpMap(Map<String, HelpTopic> var1);

    public abstract String[] compatibleVersions();

    public abstract String convert(ItemStack var1);

    public abstract String convert(ParticleData<?> var1);

    public final String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    public final String convert(Sound sound) {
        return sound.getKey().toString();
    }

    private SimpleFunctionWrapper convertFunction(CommandFunction commandFunction) {
        ToIntFunction<CommandSourceStack> appliedObj = css -> this.getMinecraftServer().getFunctions().execute(commandFunction, css);
        CommandFunction.Entry[] cArr = commandFunction.getEntries();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_Common.fromResourceLocation(commandFunction.getId()), appliedObj, result);
    }

    public abstract void createDispatcherFile(File var1, CommandDispatcher<CommandSourceStack> var2) throws IOException;

    public abstract HelpTopic generateHelpTopic(String var1, String var2, String var3, String var4);

    public final org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ResourceLocationArgument.getAdvancement(cmdCtx, (String)key).bukkit;
    }

    public final Component getAdventureChat(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return PaperComponents.gsonSerializer().deserialize((Object)Component.Serializer.toJson((net.minecraft.network.chat.Component)MessageArgument.getMessage(cmdCtx, (String)key)));
    }

    public abstract Component getAdventureChatComponent(CommandContext<CommandSourceStack> var1, String var2);

    public final float getAngle(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return AngleArgument.getAngle(cmdCtx, (String)key);
    }

    public final EnumSet<Axis> getAxis(CommandContext<CommandSourceStack> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = SwizzleArgument.getSwizzle(cmdCtx, (String)key);
        for (Direction.Axis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> Axis.X;
                case Direction.Axis.Y -> Axis.Y;
                case Direction.Axis.Z -> Axis.Z;
            });
        }
        return set;
    }

    public abstract Object getBiome(CommandContext<CommandSourceStack> var1, String var2, ArgumentSubType var3) throws CommandSyntaxException;

    public abstract Predicate<Block> getBlockPredicate(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public abstract BlockData getBlockState(CommandContext<CommandSourceStack> var1, String var2);

    public CommandDispatcher<CommandSourceStack> getBrigadierDispatcher() {
        return this.getMinecraftServer().vanillaCommandDispatcher.getDispatcher();
    }

    public final BaseComponent[] getChat(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)Component.Serializer.toJson((net.minecraft.network.chat.Component)MessageArgument.getMessage(cmdCtx, (String)key)));
    }

    public final ChatColor getChatColor(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ChatColor.getByChar((char)ColorArgument.getColor(cmdCtx, (String)key).code);
    }

    public final BaseComponent[] getChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ComponentSerializer.parse((String)Component.Serializer.toJson((net.minecraft.network.chat.Component)ComponentArgument.getComponent(cmdCtx, (String)key)));
    }

    public abstract CommandSourceStack getCLWFromCommandSender(CommandSender var1);

    public final CommandSender getCommandSenderFromCSS(CommandSourceStack css) {
        try {
            return css.getBukkitSender();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public abstract World getDimension(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public abstract World.Environment getEnvironment(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public Enchantment getEnchantment(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return Enchantment.getByKey((NamespacedKey)NMS_Common.fromResourceLocation(Registry.ENCHANTMENT.getKey((Object)ItemEnchantmentArgument.getEnchantment(cmdCtx, (String)key))));
    }

    public abstract Object getEntitySelector(CommandContext<CommandSourceStack> var1, String var2, ArgumentSubType var3) throws CommandSyntaxException;

    public abstract EntityType getEntityType(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public final FloatRange getFloatRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        MinMaxBounds.Doubles range = RangeArgument.Floats.getRange(cmdCtx, (String)key);
        double low = range.getMin() == null ? -3.4028234663852886E38 : (Double)range.getMin();
        double high = range.getMax() == null ? 3.4028234663852886E38 : (Double)range.getMax();
        return new FloatRange((float)low, (float)high);
    }

    public abstract FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public final SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return this.convertFunction((CommandFunction)this.getMinecraftServer().getFunctions().get(new ResourceLocation(key.getNamespace(), key.getKey())).get());
    }

    public final Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ResourceLocation resourceLocation : this.getMinecraftServer().getFunctions().getFunctionNames()) {
            result.add(NMS_Common.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public final IntegerRange getIntRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        MinMaxBounds.Ints range = RangeArgument.Ints.getRange(cmdCtx, (String)key);
        int low = range.getMin() == null ? Integer.MIN_VALUE : (Integer)range.getMin();
        int high = range.getMax() == null ? Integer.MAX_VALUE : (Integer)range.getMax();
        return new IntegerRange(low, high);
    }

    public abstract ItemStack getItemStack(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public abstract Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public abstract Location2D getLocation2DBlock(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public Location2D getLocation2DPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec2 vecPos = Vec2Argument.getVec2(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)vecPos.x, (double)vecPos.y);
    }

    public abstract Location getLocationBlock(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public abstract Location getLocationPrecise(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public abstract LootTable getLootTable(CommandContext<CommandSourceStack> var1, String var2);

    public final MathOperation getMathOperation(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        OperationArgument.getOperation(cmdCtx, (String)key);
        return MathOperation.fromString((String)CommandAPIHandler.getRawArgumentInput(cmdCtx, (String)key));
    }

    public NamespacedKey getMinecraftKey(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return NMS_Common.fromResourceLocation(ResourceLocationArgument.getId(cmdCtx, (String)key));
    }

    public abstract MinecraftServer getMinecraftServer();

    public final <NBTContainer> Object getNBTCompound(CommandContext<CommandSourceStack> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(CompoundTagArgument.getCompoundTag(cmdCtx, (String)key));
    }

    public final String getObjective(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ObjectiveArgument.getObjective(cmdCtx, (String)key).getName();
    }

    public final String getObjectiveCriteria(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ObjectiveCriteriaArgument.getCriteria(cmdCtx, (String)key).getName();
    }

    public final OfflinePlayer getOfflinePlayer(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)((GameProfile)GameProfileArgument.getGameProfiles(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw GameProfileArgument.ERROR_UNKNOWN_PLAYER.create();
        }
        return target;
    }

    public abstract ParticleData<?> getParticle(CommandContext<CommandSourceStack> var1, String var2);

    public final Player getPlayer(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)GameProfileArgument.getGameProfiles(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw GameProfileArgument.ERROR_UNKNOWN_PLAYER.create();
        }
        return target;
    }

    public abstract PotionEffectType getPotionEffect(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public final org.bukkit.inventory.Recipe getRecipe(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Recipe recipe = ResourceLocationArgument.getRecipe(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_Common.fromResourceLocation(recipe.getId()), recipe.toBukkitRecipe());
    }

    public final Rotation getRotation(CommandContext<CommandSourceStack> cmdCtx, String key) {
        Vec2 rotation = RotationArgument.getRotation(cmdCtx, (String)key).getRotation((CommandSourceStack)cmdCtx.getSource());
        return new Rotation(rotation.x, rotation.y);
    }

    public final ScoreboardSlot getScoreboardSlot(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return new ScoreboardSlot(ScoreboardSlotArgument.getDisplaySlot(cmdCtx, (String)key));
    }

    public final Collection<String> getScoreHolderMultiple(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(cmdCtx, (String)key);
    }

    public final String getScoreHolderSingle(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ScoreHolderArgument.getName(cmdCtx, (String)key);
    }

    public abstract CommandSender getSenderForCommand(CommandContext<CommandSourceStack> var1, boolean var2);

    public abstract SimpleCommandMap getSimpleCommandMap();

    public abstract Object getSound(CommandContext<CommandSourceStack> var1, String var2, ArgumentSubType var3);

    public SuggestionProvider<CommandSourceStack> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                ServerFunctionManager functionData = this.getMinecraftServer().getFunctions();
                SharedSuggestionProvider.suggestResource((Iterable)functionData.getTagNames(), (SuggestionsBuilder)builder, (String)"#");
                return SharedSuggestionProvider.suggestResource((Iterable)functionData.getFunctionNames(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> net.minecraft.commands.synchronization.SuggestionProviders.ALL_RECIPES;
            case SuggestionProviders.SOUNDS -> net.minecraft.commands.synchronization.SuggestionProviders.AVAILABLE_SOUNDS;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource(this.getMinecraftServer().getAdvancements().getAllAdvancements().stream().map(Advancement::getId), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)this.getMinecraftServer().getLootTables().getIds(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> net.minecraft.commands.synchronization.SuggestionProviders.SUMMONABLE_ENTITIES;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public abstract SimpleFunctionWrapper[] getTag(NamespacedKey var1);

    public final Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ResourceLocation resourceLocation : this.getMinecraftServer().getFunctions().getFunctionNames()) {
            result.add(NMS_Common.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public final String getTeam(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return TeamArgument.getTeam(cmdCtx, (String)key).getName();
    }

    public final int getTime(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    public final UUID getUUID(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return UuidArgument.getUuid(cmdCtx, (String)key);
    }

    public abstract World getWorldForCSS(CommandSourceStack var1);

    public abstract boolean isVanillaCommandWrapper(Command var1);

    public abstract void reloadDataPacks();

    public abstract void resendPackets(Player var1);
}

