/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.WorldArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentWorldTests
extends TestBase {
    ArgumentWorldTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithWorldArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new WorldArgument("world")})).executesPlayer((player, args) -> results.set((World)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        WorldMock world = this.server.addSimpleWorld("my_world");
        WorldMock world_nether = this.server.addSimpleWorld("my_world_nether");
        WorldMock world_the_end = this.server.addSimpleWorld("my_world_the_end");
        this.server.dispatchCommand((CommandSender)player2, "test my_world");
        Assertions.assertEquals((Object)world, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test my_world_nether");
        Assertions.assertEquals((Object)world_nether, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test my_world_the_end");
        Assertions.assertEquals((Object)world_the_end, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test world_doesnt_exist", "Unknown dimension 'minecraft:world_doesnt_exist'");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithWorldArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new WorldArgument("world")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.server.addSimpleWorld("my_world");
        this.server.addSimpleWorld("my_world_nether");
        this.server.addSimpleWorld("my_world_the_end");
        Assertions.assertEquals(List.of("minecraft:my_world", "minecraft:my_world_nether", "minecraft:my_world_the_end", "minecraft:world"), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of("minecraft:my_world", "minecraft:my_world_nether", "minecraft:my_world_the_end"), this.server.getSuggestions((CommandSender)player, "test my_"));
    }
}

