/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.SoundArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Arrays;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentSoundTests
extends TestBase {
    ArgumentSoundTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithSoundArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new SoundArgument("sound")})).executesPlayer((player, args) -> results.set((Sound)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test entity.enderman.death");
        Assertions.assertEquals((Object)Sound.ENTITY_ENDERMAN_DEATH, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:entity.enderman.death");
        Assertions.assertEquals((Object)Sound.ENTITY_ENDERMAN_DEATH, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test unknownsound");
        Assertions.assertEquals(null, results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithSoundArgumentAllSounds() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new SoundArgument("sound")})).executesPlayer((player, args) -> results.set((Sound)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (Sound sound : MockPlatform.getInstance().getSounds()) {
            this.server.dispatchCommand((CommandSender)player2, "test " + String.valueOf(sound.getKey()));
            Assertions.assertEquals((Object)sound, results.get());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithSoundArgumentNamespaced() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new SoundArgument.NamespacedKey("sound")})).executesPlayer((player, args) -> results.set((NamespacedKey)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test entity.enderman.death");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"entity.enderman.death"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:entity.enderman.death");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"entity.enderman.death"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test unknownsound");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"unknownsound"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test mynamespace:unknownsound");
        Assertions.assertEquals((Object)new NamespacedKey("mynamespace", "unknownsound"), results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithSoundArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new SoundArgument("Sound")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getSounds()).map(s -> s.getKey().toString()).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getSounds()).map(s -> s.getKey().toString()).filter(s -> s.startsWith("minecraft:s")).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test minecraft:s"));
    }
}

