/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.RecipeArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentRecipeTests
extends TestBase {
    ArgumentRecipeTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithRecipeArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new RecipeArgument("recipe")})).executesPlayer((player, args) -> results.set((Recipe)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test diamond_pickaxe");
        Assertions.assertEquals((Object)new ItemStack(Material.DIAMOND_PICKAXE), (Object)((Recipe)results.get()).getResult());
        this.assertCommandFailsWith((CommandSender)player2, "test unknownrecipe", "Unknown recipe: minecraft:unknownrecipe");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithRecipeArgumentKeyed() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new RecipeArgument("recipe")})).executesPlayer((player, args) -> results.set((Keyed)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (NamespacedKey str : MockPlatform.getInstance().getAllRecipes()) {
            if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
                try {
                    this.server.dispatchCommand((CommandSender)player2, "test " + str.toString());
                    Assertions.assertEquals((Object)str, (Object)((Keyed)results.get()).getKey());
                }
                catch (NullPointerException e) {
                    Assertions.assertEquals((Object)"Cannot invoke \"org.bukkit.Material.isLegacy()\" because \"this.type\" is null", (Object)e.getMessage());
                    System.err.println("Error in testing " + String.valueOf(str) + " recipe: (Null recipe)");
                }
                catch (IllegalArgumentException e) {
                    Assertions.assertEquals((Object)"Cannot have null choice", (Object)e.getMessage());
                    System.err.println("Error in testing " + String.valueOf(str) + " recipe: (Null choice)");
                }
                continue;
            }
            this.server.dispatchCommand((CommandSender)player2, "test " + str.toString());
            Assertions.assertEquals((Object)str, (Object)((Keyed)results.get()).getKey());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithRecipeArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new RecipeArgument("recipe")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(MockPlatform.getInstance().getAllRecipes().stream().map(k -> k.toString()).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(MockPlatform.getInstance().getAllRecipes().stream().map(k -> k.toString()).filter(s -> s.startsWith("minecraft:s")).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test minecraft:s"));
    }
}

