/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.FloatArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.LongArgument;
import dev.jorel.commandapi.exceptions.InvalidRangeException;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentPrimitiveTests
extends TestBase {
    ArgumentPrimitiveTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithBooleanArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new BooleanArgument("value")})).executesPlayer((player, args) -> results.set(Boolean.valueOf((Boolean)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test true");
        Assertions.assertEquals((Object)true, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test false");
        Assertions.assertEquals((Object)false, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test aaaaa", "Invalid boolean, expected 'true' or 'false' but found 'aaaaa' at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithIntegerArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("value")})).executesPlayer((player, args) -> results.set(Integer.valueOf((Integer)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((int)10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test -10");
        Assertions.assertEquals((int)-10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 0");
        Assertions.assertEquals((int)0, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 2147483647");
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test -2147483648");
        Assertions.assertEquals((int)Integer.MIN_VALUE, (Integer)((Integer)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 123hello", "Expected whitespace to end one argument, but found trailing data at position 8: test 123<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test hello123", "Expected integer at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 2147483648", "Invalid integer '2147483648' at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithBoundedIntegerArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("value", 10)})).executesPlayer((player, args) -> results.set(Integer.valueOf((Integer)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((int)10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 20");
        Assertions.assertEquals((int)20, (Integer)((Integer)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 0", "Integer must not be less than 10, found 0 at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithDoubleBoundedIntegerArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("value", 10, 20)})).executesPlayer((player, args) -> results.set(Integer.valueOf((Integer)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((int)10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 15");
        Assertions.assertEquals((int)15, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 20");
        Assertions.assertEquals((int)20, (Integer)((Integer)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 0", "Integer must not be less than 10, found 0 at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 30", "Integer must not be more than 20, found 30 at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithFloatArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FloatArgument("value")})).executesPlayer((player, args) -> results.set(Float.valueOf(((Float)args.get(0)).floatValue())))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10.0");
        Assertions.assertEquals((float)10.0f, (Float)((Float)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test -10.0");
        Assertions.assertEquals((float)-10.0f, (Float)((Float)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 0.0");
        Assertions.assertEquals((float)0.0f, (Float)((Float)results.get()));
        String floatMaxValue = String.format(Locale.ENGLISH, "%f", Float.valueOf(Float.MAX_VALUE));
        this.server.dispatchCommand((CommandSender)player2, "test " + floatMaxValue);
        Assertions.assertEquals((float)Float.MAX_VALUE, (Float)((Float)results.get()));
        String floatMinValue = String.format(Locale.ENGLISH, "%f", Float.valueOf(-3.4028235E38f));
        this.server.dispatchCommand((CommandSender)player2, "test " + floatMinValue);
        Assertions.assertEquals((float)-3.4028235E38f, (Float)((Float)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 123hello", "Expected whitespace to end one argument, but found trailing data at position 8: test 123<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test hello123", "Expected float at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithFloatBoundedArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FloatArgument("value", 10.0f, 20.0f)})).executesPlayer((player, args) -> results.set((Float)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10.0");
        Assertions.assertEquals((float)10.0f, (Float)((Float)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 15.0");
        Assertions.assertEquals((float)15.0f, (Float)((Float)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 20.0");
        Assertions.assertEquals((float)20.0f, (Float)((Float)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 0", "Float must not be less than 10.0, found 0.0 at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 30", "Float must not be more than 20.0, found 30.0 at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithDoubleArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("value")})).executesPlayer((player, args) -> results.set(Double.valueOf((Double)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10.0");
        Assertions.assertEquals((double)10.0, (Double)((Double)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test -10.0");
        Assertions.assertEquals((double)-10.0, (Double)((Double)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 0.0");
        Assertions.assertEquals((double)0.0, (Double)((Double)results.get()));
        String doubleMaxValue = String.format(Locale.ENGLISH, "%f", Double.MAX_VALUE);
        this.server.dispatchCommand((CommandSender)player2, "test " + doubleMaxValue);
        Assertions.assertEquals((double)Double.MAX_VALUE, (Double)((Double)results.get()));
        String doubleMinValue = String.format(Locale.ENGLISH, "%f", -1.7976931348623157E308);
        this.server.dispatchCommand((CommandSender)player2, "test " + doubleMinValue);
        Assertions.assertEquals((double)-1.7976931348623157E308, (Double)((Double)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 123hello", "Expected whitespace to end one argument, but found trailing data at position 8: test 123<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test hello123", "Expected double at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithDoubleBoundedArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("value", 10.0, 20.0)})).executesPlayer((player, args) -> results.set(Double.valueOf((Double)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10.0");
        Assertions.assertEquals((double)10.0, (Double)((Double)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 15.0");
        Assertions.assertEquals((double)15.0, (Double)((Double)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 20.0");
        Assertions.assertEquals((double)20.0, (Double)((Double)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 0", "Double must not be less than 10.0, found 0.0 at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 30", "Double must not be more than 20.0, found 30.0 at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithLongArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LongArgument("value")})).executesPlayer((player, args) -> results.set(Long.valueOf((Long)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((long)10L, (Long)((Long)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test -10");
        Assertions.assertEquals((long)-10L, (Long)((Long)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 0");
        Assertions.assertEquals((long)0L, (Long)((Long)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 9223372036854775807");
        Assertions.assertEquals((long)Long.MAX_VALUE, (Long)((Long)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test -9223372036854775808");
        Assertions.assertEquals((long)Long.MIN_VALUE, (Long)((Long)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 123hello", "Expected whitespace to end one argument, but found trailing data at position 8: test 123<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test hello123", "Expected long at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 9223372036854775808", "Invalid long '9223372036854775808' at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithBoundedLongArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LongArgument("value", 10L)})).executesPlayer((player, args) -> results.set(Long.valueOf((Long)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((long)10L, (Long)((Long)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 20");
        Assertions.assertEquals((long)20L, (Long)((Long)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 0", "Long must not be less than 10, found 0 at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithDoubleBoundedLongArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LongArgument("value", 10L, 20L)})).executesPlayer((player, args) -> results.set(Long.valueOf((Long)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((long)10L, (Long)((Long)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 15");
        Assertions.assertEquals((long)15L, (Long)((Long)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 20");
        Assertions.assertEquals((long)20L, (Long)((Long)results.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test 0", "Long must not be less than 10, found 0 at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 30", "Long must not be more than 20, found 30 at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void exceptionTestWithIntegerArgumentInvalid() {
        Assertions.assertThrows(InvalidRangeException.class, () -> new IntegerArgument("value", 20, 10));
    }

    @Test
    void exceptionTestWithLongArgumentInvalid() {
        Assertions.assertThrows(InvalidRangeException.class, () -> new LongArgument("value", 20L, 10L));
    }

    @Test
    void exceptionTestWithFloatArgumentInvalid() {
        Assertions.assertThrows(InvalidRangeException.class, () -> new FloatArgument("value", 20.0f, 10.0f));
    }

    @Test
    void exceptionTestWithDoubleArgumentInvalid() {
        Assertions.assertThrows(InvalidRangeException.class, () -> new DoubleArgument("value", 20.0, 10.0));
    }

    @Test
    void suggestionTestWithBooleanArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new BooleanArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("false", "true"), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of("false"), this.server.getSuggestions((CommandSender)player, "test f"));
        Assertions.assertEquals(List.of("true"), this.server.getSuggestions((CommandSender)player, "test t"));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test x"));
    }

    @Test
    void suggestionTestWithIntegerArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithLongArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new LongArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithFloatArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FloatArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithDoubleArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

