/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ParticleArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.ParticleData;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentParticle_1_17_Tests
extends TestBase {
    ArgumentParticle_1_17_Tests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Assumptions.assumeTrue((boolean)this.version.lessThan(MCVersion.V1_20_3));
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private void assertBlockLocationCoordsEquals(Location loc1, Location loc2) {
        Assertions.assertEquals((double)loc1.getBlockX(), (double)loc2.getBlockX(), (double)1.0E-4);
        Assertions.assertEquals((double)loc1.getBlockY(), (double)loc2.getBlockY(), (double)1.0E-4);
        Assertions.assertEquals((double)loc1.getBlockZ(), (double)loc2.getBlockZ(), (double)1.0E-4);
    }

    @Test
    void executionTestWithParticleArgumentShriek() {
        Assumptions.assumeTrue((boolean)this.version.greaterThanOrEqualTo(MCVersion.V1_19));
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test shriek 10");
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.valueOf((String)"SHRIEK"), (Object)result.particle());
        Assertions.assertEquals((int)10, (Integer)((Integer)result.data()));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentSculkCharge() {
        Assumptions.assumeTrue((boolean)this.version.greaterThanOrEqualTo(MCVersion.V1_19));
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test sculk_charge 2");
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.valueOf((String)"SCULK_CHARGE"), (Object)result.particle());
        Assertions.assertEquals((float)2.0f, (Float)((Float)result.data()));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentVibration() {
        Assumptions.assumeTrue((boolean)this.version.greaterThanOrEqualTo(MCVersion.V1_19));
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test vibration 5.0 64.0 0.0 200");
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.VIBRATION, (Object)result.particle());
        this.assertBlockLocationCoordsEquals(player2.getLocation(), ((Vibration)result.data()).getOrigin());
        this.assertBlockLocationCoordsEquals(new Location(player2.getWorld(), 5.0, 64.0, 0.0), ((Vibration.Destination.BlockDestination)((Vibration)result.data()).getDestination()).getLocation());
        Assertions.assertEquals((int)200, (int)((Vibration)result.data()).getArrivalTime());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentDustTransition() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test dust_color_transition 1.0 0.0 0.0 3.0 0.0 0.0 1.0");
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.DUST_COLOR_TRANSITION, (Object)result.particle());
        Assertions.assertEquals((Object)Color.RED, (Object)((Particle.DustTransition)result.data()).getColor());
        Assertions.assertEquals((Object)Color.BLUE, (Object)((Particle.DustTransition)result.data()).getToColor());
        Assertions.assertEquals((float)3.0f, (float)((Particle.DustTransition)result.data()).getSize());
        this.assertNoMoreResults(results);
    }
}

