/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import com.saicone.rtag.Rtag;
import com.saicone.rtag.RtagMirror;
import com.saicone.rtag.tag.TagCompound;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.NBTCompoundArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ArgumentNBTCompoundRtagTests
extends TestBase {
    ArgumentNBTCompoundRtagTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp(Map.class, o -> TagCompound.getValue((RtagMirror)Rtag.INSTANCE, (Object)o));
        try {
            Object oldServer = MockPlatform.getField(Bukkit.class, (String)"server", null);
            String craftServerVersion = switch (this.version) {
                case MCVersion.V1_16_5 -> "v1_16_R3";
                case MCVersion.V1_17 -> "v1_17_R1";
                case MCVersion.V1_18 -> "v1_18_R1";
                case MCVersion.V1_19_2 -> "v1_19_R1";
                case MCVersion.V1_19_4 -> "v1_19_R3";
                case MCVersion.V1_20 -> "v1_20_R1";
                case MCVersion.V1_20_2 -> "v1_20_R2";
                case MCVersion.V1_20_3 -> "v1_20_R3";
                case MCVersion.V1_20_5 -> "v1_20_R4";
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this.version));
            };
            Object craftServer = Mockito.mock(Class.forName("org.bukkit.craftbukkit." + craftServerVersion + ".CraftServer"));
            MockPlatform.setField(Bukkit.class, (String)"server", null, (Object)craftServer);
            Rtag.INSTANCE.getClass();
            MockPlatform.setField(Bukkit.class, (String)"server", null, (Object)oldServer);
        }
        catch (ReflectiveOperationException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithNBTCompoundArgumentEmpty() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {}");
        Assertions.assertEquals(Map.of(), results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentBoolean() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:true}");
        Assertions.assertEquals((Object)1, ((Map)results.get()).get("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:false}");
        Assertions.assertEquals((Object)0, ((Map)results.get()).get("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentNumbers() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:2b}");
        Assertions.assertEquals((Object)2, ((Map)results.get()).get("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:200s}");
        Assertions.assertEquals((Object)200, ((Map)results.get()).get("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:2000000}");
        Assertions.assertEquals((Object)2000000, ((Map)results.get()).get("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:20000000000l}");
        Assertions.assertEquals((Object)20000000000L, ((Map)results.get()).get("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:2.3f}");
        Assertions.assertEquals((Object)Float.valueOf(2.3f), ((Map)results.get()).get("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:2.3d}");
        Assertions.assertEquals((Object)2.3, ((Map)results.get()).get("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentNumberArrays() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:[B;2b,3b,4b]}");
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])((byte[])((Map)results.get()).get("val")));
        this.server.dispatchCommand((CommandSender)player2, "test {val:[I;200,300,400]}");
        Assertions.assertArrayEquals((int[])new int[]{200, 300, 400}, (int[])((int[])((Map)results.get()).get("val")));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentNumberLists() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:[200,300,400]}");
        Assertions.assertEquals(List.of(Integer.valueOf(200), Integer.valueOf(300), Integer.valueOf(400)), ((Map)results.get()).get("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:[3000000000l,4000000000l,5000000000l]}");
        Assertions.assertEquals(List.of(Long.valueOf(3000000000L), Long.valueOf(4000000000L), Long.valueOf(5000000000L)), ((Map)results.get()).get("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentStrings() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:\"Hello, world!\"}");
        Assertions.assertEquals((Object)"Hello, world!", ((Map)results.get()).get("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentCompound() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val1:{val2:2}}");
        Assertions.assertEquals(Map.of("val2", 2), ((Map)results.get()).get("val1"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentMultiple() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((Map)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val1:10,val2:20}");
        Map result = (Map)results.get();
        Assertions.assertEquals((Object)10, result.get("val1"));
        Assertions.assertEquals((Object)20, result.get("val2"));
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithNBTCompoundArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test {"));
    }
}

