/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.ItemStackArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ArgumentMultiLiteralTests
extends TestBase {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void commandBuildingTestWithMultiLiteralArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("command1").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literal1", new String[]{"option1", "option2", "option3"}), new MultiLiteralArgument("literal2", new String[]{"option1", "option2", "option3"})})).executesPlayer(P_EXEC)).register();
        ((CommandTree)new CommandTree("command2").then(new MultiLiteralArgument("literal1", new String[]{"option1", "option2", "option3"}).then((AbstractArgumentTree)new MultiLiteralArgument("literal2", new String[]{"option1", "option2", "option3"}).executesPlayer(P_EXEC)))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("command3").withArguments((AbstractArgument[])new Argument[]{(Argument)new MultiLiteralArgument("literal1", new String[]{"option1", "option2"}).combineWith((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literal2", new String[]{"option1", "option2"}), new MultiLiteralArgument("literal3", new String[]{"option1", "option2"})})})).executesPlayer(P_EXEC)).register();
        ((CommandTree)new CommandTree("command4").then((AbstractArgumentTree)((Argument)new MultiLiteralArgument("literal1", new String[]{"option1", "option2"}).combineWith((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literal2", new String[]{"option1", "option2"}), new MultiLiteralArgument("literal3", new String[]{"option1", "option2"})})).executesPlayer(P_EXEC))).register();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"command1\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"option1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option3\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            }\n          }\n        },\n        \"option2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option3\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            }\n          }\n        },\n        \"option3\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option3\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            }\n          }\n        }\n      }\n    },\n    \"command2\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"option1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option3\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            }\n          }\n        },\n        \"option2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option3\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            }\n          }\n        },\n        \"option3\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            },\n            \"option3\": {\n              \"type\": \"literal\",\n              \"executable\": true\n            }\n          }\n        }\n      }\n    },\n    \"command3\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"option1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        }\n      }\n    },\n    \"command4\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"option1\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        },\n        \"option2\": {\n          \"type\": \"literal\",\n          \"children\": {\n            \"option1\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            },\n            \"option2\": {\n              \"type\": \"literal\",\n              \"children\": {\n                \"option1\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                },\n                \"option2\": {\n                  \"type\": \"literal\",\n                  \"executable\": true\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
    }

    @Test
    void executionTestWithMultiLiteralArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literals", new String[]{"literal", "literal1", "literal2"})})).executesPlayer((player, args) -> results.set((String)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test literal");
        Assertions.assertEquals((Object)"literal", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test literal1");
        Assertions.assertEquals((Object)"literal1", results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test literal3", "Incorrect argument for command at position 5: test <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithMultiLiteralArgumentNodeName() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literals", new String[]{"literal", "literal1", "literal2"})})).executesPlayer((player, args) -> results.set((String)args.get("literals")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test literal");
        Assertions.assertEquals((Object)"literal", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test literal1");
        Assertions.assertEquals((Object)"literal1", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithMultipleMultiLiteralArguments() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literals1", new String[]{"lit1", "lit2"})})).withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literals2", new String[]{"lit1", "lit3"})})).executes((player, args) -> {
            results.set((String)args.getUnchecked("literals1"));
            results.set((String)args.getUnchecked("literals2"));
        }, new ExecutorType[0])).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test lit1 lit1");
        Assertions.assertEquals((Object)"lit1", results.get());
        Assertions.assertEquals((Object)"lit1", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test lit1 lit3");
        Assertions.assertEquals((Object)"lit1", results.get());
        Assertions.assertEquals((Object)"lit3", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test lit2 lit1");
        Assertions.assertEquals((Object)"lit2", results.get());
        Assertions.assertEquals((Object)"lit1", results.get());
        this.server.dispatchCommand((CommandSender)player2, "test lit2 lit3");
        Assertions.assertEquals((Object)"lit2", results.get());
        Assertions.assertEquals((Object)"lit3", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithSubcommands() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("hello").withArguments((AbstractArgument[])new Argument[]{new ItemStackArgument("hello")})).executesPlayer(info -> results.set(info.args().get("hello")))))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("bye").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("bye")})).executesPlayer(info -> results.set(info.args().get("bye")))))).register();
        PlayerMock player = this.server.addPlayer();
        ItemStack item = new ItemStack(Material.STICK);
        this.server.dispatchCommand((CommandSender)player, "test hello minecraft:stick");
        Assertions.assertEquals((Object)item, results.get());
        this.server.dispatchCommand((CommandSender)player, "test bye 5");
        Assertions.assertEquals((Object)5, results.get());
    }

    @Test
    void executionTestWithArrayConstructor() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument(new String[]{"lit1", "lit2", "lit3"})})).executesPlayer(info -> results.set((String)info.args().get(0)))).register();
        PlayerMock player = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player, "test lit1");
        Assertions.assertEquals((Object)"lit1", results.get());
        this.server.dispatchCommand((CommandSender)player, "test lit2");
        Assertions.assertEquals((Object)"lit2", results.get());
        this.server.dispatchCommand((CommandSender)player, "test lit3");
        Assertions.assertEquals((Object)"lit3", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithMultiLiteralArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("literals", new String[]{"literal", "literal1", "literal2"})})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("literal", "literal1", "literal2"), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

