/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.MathOperationArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.MathOperation;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentMathOperationTests
extends TestBase {
    ArgumentMathOperationTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithMathOperationArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MathOperationArgument("operation")})).executesPlayer((player, args) -> results.set((MathOperation)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test +=");
        Assertions.assertEquals((Object)MathOperation.ADD, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test =");
        Assertions.assertEquals((Object)MathOperation.ASSIGN, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test /=");
        Assertions.assertEquals((Object)MathOperation.DIVIDE, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test >");
        Assertions.assertEquals((Object)MathOperation.MAX, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test <");
        Assertions.assertEquals((Object)MathOperation.MIN, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test %=");
        Assertions.assertEquals((Object)MathOperation.MOD, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test *=");
        Assertions.assertEquals((Object)MathOperation.MULTIPLY, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test -=");
        Assertions.assertEquals((Object)MathOperation.SUBTRACT, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test ><");
        Assertions.assertEquals((Object)MathOperation.SWAP, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test invalid", "Invalid operation");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithMathOperationArgumentArgumentApplication() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("value1")})).withArguments((AbstractArgument[])new Argument[]{new MathOperationArgument("operation")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("value2")})).executesPlayer((player, args) -> {
            int value1 = (Integer)args.get("value1");
            int value2 = (Integer)args.get("value2");
            MathOperation operation = (MathOperation)args.get("operation");
            results.set(operation.apply(value1, value2));
        })).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 1 += 1");
        Assertions.assertEquals((int)2, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 1 = 2");
        Assertions.assertEquals((int)2, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 10 /= 5");
        Assertions.assertEquals((int)2, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 5 /= 10");
        Assertions.assertEquals((int)0, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 10 > 3");
        Assertions.assertEquals((int)10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 3 > 10");
        Assertions.assertEquals((int)10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 10 < 3");
        Assertions.assertEquals((int)3, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 3 < 10");
        Assertions.assertEquals((int)3, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 10 %= 7");
        Assertions.assertEquals((int)3, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 7 %= 10");
        Assertions.assertEquals((int)7, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 10 *= 10");
        Assertions.assertEquals((int)100, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 20 -= 10");
        Assertions.assertEquals((int)10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 10 -= 20");
        Assertions.assertEquals((int)-10, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 1 >< 2");
        Assertions.assertEquals((int)2, (Integer)((Integer)results.get()));
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithMathOperationArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MathOperationArgument("operation")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("%=", "*=", "+=", "-=", "/=", "<", "=", ">", "><"), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of("><"), this.server.getSuggestions((CommandSender)player, "test >"));
    }
}

