/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.AdvancementArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentAdvancementTests
extends TestBase {
    ArgumentAdvancementTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithAdvancementArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdvancementArgument("advancement")})).executesPlayer((player, args) -> results.set((Advancement)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.addAdvancement(NamespacedKey.minecraft((String)"adventure/adventuring_time"));
        this.server.dispatchCommand((CommandSender)player2, "test adventure/adventuring_time");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"adventure/adventuring_time"), (Object)((Advancement)results.get()).getKey());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:adventure/adventuring_time");
        Assertions.assertEquals((Object)NamespacedKey.minecraft((String)"adventure/adventuring_time"), (Object)((Advancement)results.get()).getKey());
        this.assertCommandFailsWith((CommandSender)player2, "test namespace:group/unknown_advancement", "Unknown advancement: namespace:group/unknown_advancement");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithAdvancementArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdvancementArgument("advancement")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        List<NamespacedKey> advancements = List.of(NamespacedKey.minecraft((String)"adventure/root"), NamespacedKey.minecraft((String)"adventure/voluntary_exile"), NamespacedKey.minecraft((String)"adventure/spyglass_at_parrot"), NamespacedKey.minecraft((String)"adventure/kill_a_mob"), NamespacedKey.minecraft((String)"adventure/trade"), NamespacedKey.minecraft((String)"adventure/honey_block_slide"), NamespacedKey.minecraft((String)"adventure/ol_betsy"), NamespacedKey.minecraft((String)"adventure/lightning_rod_with_villager_no_fire"), NamespacedKey.minecraft((String)"adventure/fall_from_world_height"), NamespacedKey.minecraft((String)"adventure/avoid_vibration"), NamespacedKey.minecraft((String)"adventure/sleep_in_bed"), NamespacedKey.minecraft((String)"adventure/hero_of_the_village"), NamespacedKey.minecraft((String)"adventure/spyglass_at_ghast"), NamespacedKey.minecraft((String)"adventure/throw_trident"), NamespacedKey.minecraft((String)"adventure/kill_mob_near_sculk_catalyst"), NamespacedKey.minecraft((String)"adventure/shoot_arrow"), NamespacedKey.minecraft((String)"adventure/kill_all_mobs"), NamespacedKey.minecraft((String)"adventure/totem_of_undying"), NamespacedKey.minecraft((String)"adventure/summon_iron_golem"), NamespacedKey.minecraft((String)"adventure/trade_at_world_height"), NamespacedKey.minecraft((String)"adventure/two_birds_one_arrow"), NamespacedKey.minecraft((String)"adventure/whos_the_pillager_now"), NamespacedKey.minecraft((String)"adventure/arbalistic"), NamespacedKey.minecraft((String)"adventure/adventuring_time"), NamespacedKey.minecraft((String)"adventure/play_jukebox_in_meadows"), NamespacedKey.minecraft((String)"adventure/walk_on_powder_snow_with_leather_boots"), NamespacedKey.minecraft((String)"adventure/spyglass_at_dragon"), NamespacedKey.minecraft((String)"adventure/very_very_frightening"), NamespacedKey.minecraft((String)"adventure/sniper_duel"), NamespacedKey.minecraft((String)"adventure/bullseye"));
        this.server.addAdvancements(advancements);
        Assertions.assertEquals(advancements.stream().map(NamespacedKey::toString).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(advancements.stream().map(NamespacedKey::toString).filter(key -> key.startsWith("minecraft:adventure/a")).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test adventure/a"));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test x"));
    }
}

