/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIVersionHandler;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.PaperImplementations;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.executors.PlayerCommandExecutor;
import dev.jorel.commandapi.test.CommandAPIServerMock;
import dev.jorel.commandapi.test.Main;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.opentest4j.AssertionFailedError;

public abstract class TestBase {
    public CommandAPIServerMock server;
    public JavaPlugin plugin;
    public MCVersion version;
    public static final PlayerCommandExecutor P_EXEC = (player, args) -> {};

    public TestBase() {
        if (CommandAPIVersionHandler.IS_MOJANG_MAPPED) {
            SafeVarHandle.USING_MOJANG_MAPPINGS = true;
        }
        this.version = CommandAPIVersionHandler.getVersion();
    }

    public <NBTContainer> void setUp(Class<NBTContainer> nbtContainerClass, Function<Object, NBTContainer> nbtContainerConstructor) {
        Main.nbtContainerClass = nbtContainerClass;
        Main.nbtContainerConstructor = nbtContainerConstructor;
        this.setUp(Main.class);
    }

    public void setUp() {
        this.setUp(Main.class);
    }

    public <T extends JavaPlugin> void setUp(Class<T> pluginClass) {
        this.server = (CommandAPIServerMock)MockBukkit.mock((ServerMock)new CommandAPIServerMock());
        this.plugin = MockBukkit.load(pluginClass);
    }

    public void tearDown() {
        if (this.server != null) {
            Bukkit.getScheduler().cancelTasks((Plugin)this.plugin);
            if (this.plugin != null) {
                this.plugin.onDisable();
            }
            MockBukkit.unmock();
        }
        this.server = null;
        this.plugin = null;
        MockPlatform.unload();
    }

    public void enableServer() {
        Assertions.assertTrue((boolean)CommandAPI.canRegister(), (String)"Server was already enabled! Cannot enable twice!");
        TestBase.disablePaperImplementations();
        Bukkit.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        Assertions.assertDoesNotThrow(() -> this.server.getScheduler().performOneTick());
        Assertions.assertFalse((boolean)CommandAPI.canRegister());
    }

    private void resetAllPotions() {
        PotionEffectType[] arr = (PotionEffectType[])MockPlatform.getFieldAs(PotionEffectType.class, (String)"byId", null, PotionEffectType[].class);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = null;
        }
        ((Map)MockPlatform.getFieldAs(PotionEffectType.class, (String)"byName", null, Map.class)).clear();
        Map byKey = (Map)MockPlatform.getFieldAs(PotionEffectType.class, (String)"byName", null, Map.class);
        if (byKey != null) {
            byKey.clear();
        }
        MockPlatform.setField(PotionEffectType.class, (String)"acceptingNew", null, (Object)true);
    }

    public <T> void assertStoresResult(CommandSender sender, String command, Mut<T> queue, T expected) {
        Assertions.assertDoesNotThrow(() -> Assertions.assertTrue((boolean)this.server.dispatchThrowableCommand(sender, command), (String)"Expected command dispatch to return true, but it gave false"));
        Assertions.assertEquals(expected, (Object)Assertions.assertDoesNotThrow(queue::get, (String)("Expected to find <" + String.valueOf(expected) + "> in queue, but nothing was present")));
    }

    @Deprecated
    public void assertInvalidSyntax(CommandSender sender, String command) {
        Assertions.assertThrows(CommandSyntaxException.class, () -> Assertions.assertTrue((boolean)this.server.dispatchThrowableCommand(sender, command)));
    }

    public <T extends Throwable> T assertThrowsWithMessage(Class<T> expectedType, String message, Executable executable) {
        Throwable thrown = Assertions.assertThrows(expectedType, (Executable)executable);
        Assertions.assertEquals((Object)message, (Object)thrown.getMessage());
        return (T)thrown;
    }

    public void assertCommandFailsWith(CommandSender sender, String command, String message) {
        CommandSyntaxException exception = (CommandSyntaxException)Assertions.assertThrows(CommandSyntaxException.class, () -> this.server.dispatchThrowableCommand(sender, command));
        Assertions.assertEquals((Object)message, (Object)exception.getMessage());
    }

    public void assertNotCommandFailsWith(CommandSender sender, String command, String message) {
        CommandSyntaxException exception = (CommandSyntaxException)Assertions.assertThrows(CommandSyntaxException.class, () -> this.server.dispatchThrowableCommand(sender, command));
        Assertions.assertNotEquals((Object)message, (Object)exception.getMessage());
    }

    public void assertNoMoreResults(Mut<?> mut) {
        Assertions.assertThrows(NoSuchElementException.class, () -> mut.get(), (String)"Expected there to be no results left, but at least one was found");
    }

    public String getDispatcherString() {
        try {
            return Files.readString(new File(this.plugin.getDataFolder(), "command_registration.json").toPath());
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    public void registerDummyCommands(CommandMap commandMap, String ... commandName) {
        commandMap.registerAll("minecraft", Arrays.stream(commandName).map(name -> new Command((String)name){

            public boolean execute(@NotNull CommandSender commandSender, @NotNull String s, @NotNull String[] strings) {
                return true;
            }
        }).collect(Collectors.toList()));
    }

    public <T> void compareLists(Collection<T> list1, Collection<T> list2) {
        LinkedHashSet<T> s1 = new LinkedHashSet<T>(list1);
        LinkedHashSet<T> s2 = new LinkedHashSet<T>(list2);
        LinkedHashSet<T> s1_2 = new LinkedHashSet<T>(list1);
        LinkedHashSet<T> s2_2 = new LinkedHashSet<T>(list2);
        s1.removeAll(s2);
        s2_2.removeAll(s1_2);
        System.out.println("List 1 has the following extra items: " + String.valueOf(s1));
        System.out.println("List 2 has the following extra items: " + String.valueOf(s2_2));
    }

    public static void disablePaperImplementations() {
        MockPlatform.setField(PaperImplementations.class, (String)"isPaperPresent", (Object)MockPlatform.get().getPaper(), (Object)false);
    }

    public Suggestion mkSuggestion(String text, String tooltip) {
        return new Suggestion(StringRange.at((int)0), text, (Message)new LiteralMessage(tooltip));
    }

    public boolean suggestionEquals(Suggestion suggestion1, Suggestion suggestion2) {
        return suggestion1.getText().equals(suggestion2.getText()) && suggestion1.getTooltip().getString().equals(suggestion2.getTooltip().getString());
    }

    public void assertSuggestionListEquals(List<Suggestion> expected, List<Suggestion> actual) {
        if (expected.size() != actual.size()) {
            throw new AssertionFailedError("List " + String.valueOf(expected) + " and " + String.valueOf(actual) + " have differing lengths");
        }
        for (int i = 0; i < expected.size(); ++i) {
            if (this.suggestionEquals(expected.get(i), actual.get(i))) continue;
            throw new AssertionFailedError("Expected: <" + String.valueOf(expected) + "> but was: <" + String.valueOf(actual) + ">");
        }
    }

    public void assertNoSuggestions(CommandSender sender, String command) {
        List<Suggestion> suggestions = this.server.getSuggestionsWithTooltips(sender, command);
        if (suggestions.size() != 0) {
            throw new AssertionFailedError("Expected no suggestions, but found <" + String.valueOf(suggestions) + ">");
        }
    }

    public void assertCommandSuggests(CommandSender sender, String command, String ... expected) {
        this.assertCommandSuggests(sender, command, List.of(expected));
    }

    public void assertCommandSuggests(CommandSender sender, String command, List<String> expected) {
        Assertions.assertEquals(expected, this.server.getSuggestions(sender, command));
    }

    public void assertCommandSuggestsTooltips(CommandSender sender, String command, Suggestion ... expected) {
        this.assertCommandSuggestsTooltips(sender, command, List.of(expected));
    }

    public void assertCommandSuggestsTooltips(CommandSender sender, String command, List<Suggestion> expected) {
        this.assertSuggestionListEquals(expected, this.server.getSuggestionsWithTooltips(sender, command));
    }
}

