/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CommandPermissionTests
extends TestBase {
    CommandPermissionTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithPermissionOnCommand() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withPermission("permission.node")).executesPlayer((player, args) -> results.set(true))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.assertCommandFailsWith((CommandSender)player2, "test", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        player2.addAttachment((Plugin)this.plugin, "permission.node", true);
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player2, "test"));
        Assertions.assertTrue((boolean)((Boolean)results.get()));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithPermissionOnArgument() {
        Mut results1 = Mut.of();
        Mut results2 = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("test").executesPlayer((player, args) -> results1.set(true))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("str").withPermission("permission.node")})).executesPlayer((player, args) -> results2.set(true))).register();
        PlayerMock player2 = this.server.addPlayer();
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player2, "test"));
        Assertions.assertTrue((boolean)((Boolean)results1.get()));
        this.assertCommandFailsWith((CommandSender)player2, "test hello", "Incorrect argument for command at position 5: test <--[HERE]");
        player2.addAttachment((Plugin)this.plugin, "permission.node", true);
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player2, "test"));
        Assertions.assertTrue((boolean)((Boolean)results1.get()));
        Assertions.assertTrue((boolean)this.server.dispatchCommand((CommandSender)player2, "test hello"));
        Assertions.assertTrue((boolean)((Boolean)results2.get()));
        this.assertNoMoreResults(results1);
        this.assertNoMoreResults(results2);
    }
}

