/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.command.ConsoleCommandSenderMock;
import be.seeseemelk.mockbukkit.entity.SimpleEntityMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class CommandExecutionTests
extends TestBase {
    private final Map<ExecutorType, Supplier<CommandSender>> executorTypeToMockSender = new LinkedHashMap<ExecutorType, Supplier<CommandSender>>();

    CommandExecutionTests() {
        this.executorTypeToMockSender.put(ExecutorType.PLAYER, () -> this.server.setupMockedCraftPlayer());
        this.executorTypeToMockSender.put(ExecutorType.ENTITY, () -> new SimpleEntityMock((ServerMock)this.server));
        this.executorTypeToMockSender.put(ExecutorType.CONSOLE, ConsoleCommandSenderMock::new);
        this.executorTypeToMockSender.put(ExecutorType.BLOCK, () -> (CommandSender)Mockito.mock(BlockCommandSender.class));
        this.executorTypeToMockSender.put(ExecutorType.PROXY, () -> (CommandSender)Mockito.mock(NativeProxyCommandSender.class));
        this.executorTypeToMockSender.put(ExecutorType.REMOTE, () -> (CommandSender)Mockito.mock(RemoteConsoleCommandSender.class));
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private void testAllCommands(Function<String, Consumer<CommandSender>> shouldSucceed, Function<String, Consumer<CommandSender>> shouldFail, List<String> commandNames, ExecutorType ... types) {
        for (String name : commandNames) {
            try {
                this.assertOnlyDefinedExecutorTypesSucceed(shouldSucceed.apply(name), shouldFail.apply(name), types);
            }
            catch (Throwable e) {
                Assertions.fail((String)("Unexpected error while running command with name \"" + name + "\""), (Throwable)e);
            }
        }
    }

    private void assertOnlyDefinedExecutorTypesSucceed(Consumer<CommandSender> shouldSucceed, Consumer<CommandSender> shouldFail, ExecutorType ... types) {
        List<ExecutorType> typesList = Arrays.asList(types);
        for (Map.Entry<ExecutorType, Supplier<CommandSender>> executorType : this.executorTypeToMockSender.entrySet()) {
            try {
                (typesList.contains(executorType.getKey()) ? shouldSucceed : shouldFail).accept(executorType.getValue().get());
            }
            catch (Throwable e) {
                Assertions.fail((String)("Unexpected error while running command with executor type \"" + String.valueOf(executorType.getKey()) + "\""), (Throwable)e);
            }
        }
    }

    @Test
    void testPlayerExecution() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executesPlayer(info -> results.set((Player)info.sender()))).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executesPlayer((player, args) -> results.set(player))).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executesPlayer(info -> {
            results.set((Player)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executesPlayer((player, args) -> {
            results.set(player);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, (Player)sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.PLAYER);
        this.assertNoMoreResults(results);
    }

    @Test
    void testEntityExecution() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executesEntity(info -> results.set((Entity)info.sender()))).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executesEntity((entity, args) -> results.set(entity))).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executesEntity(info -> {
            results.set((Entity)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executesEntity((entity, args) -> {
            results.set(entity);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, (Entity)sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.ENTITY);
        this.assertNoMoreResults(results);
    }

    @Test
    void testConsoleExecution() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executesConsole(info -> results.set((ConsoleCommandSender)info.sender()))).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executesConsole((console, args) -> results.set(console))).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executesConsole(info -> {
            results.set((ConsoleCommandSender)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executesConsole((console, args) -> {
            results.set(console);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, (ConsoleCommandSender)sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.CONSOLE);
        this.assertNoMoreResults(results);
    }

    @Test
    void testBlockExecution() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executesCommandBlock(info -> results.set((BlockCommandSender)info.sender()))).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executesCommandBlock((block, args) -> results.set(block))).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executesCommandBlock(info -> {
            results.set((BlockCommandSender)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executesCommandBlock((block, args) -> {
            results.set(block);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, (BlockCommandSender)sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.BLOCK);
    }

    @Test
    void testProxyExecution() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executesProxy(info -> results.set((NativeProxyCommandSender)info.sender()))).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executesProxy((proxy, args) -> results.set(proxy))).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executesProxy(info -> {
            results.set((NativeProxyCommandSender)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executesProxy((proxy, args) -> {
            results.set(proxy);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, (NativeProxyCommandSender)sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.PROXY);
        this.assertNoMoreResults(results);
    }

    @Test
    void testRemoteConsoleExecution() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executesRemoteConsole(info -> results.set((RemoteConsoleCommandSender)info.sender()))).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executesRemoteConsole((console, args) -> results.set(console))).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executesRemoteConsole(info -> {
            results.set((RemoteConsoleCommandSender)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executesRemoteConsole((console, args) -> {
            results.set(console);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, (RemoteConsoleCommandSender)sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.REMOTE);
        this.assertNoMoreResults(results);
    }

    @Test
    void testNativeExecution() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executesNative(info -> results.set((NativeProxyCommandSender)info.sender()))).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executesNative((proxy, args) -> results.set(proxy))).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executesNative(info -> {
            results.set((NativeProxyCommandSender)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executesNative((proxy, args) -> {
            results.set(proxy);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> {
            this.server.dispatchCommand((CommandSender)sender, (String)name);
            NativeProxyCommandSender nativeSender = (NativeProxyCommandSender)results.get();
            Assertions.assertEquals((Object)sender, (Object)nativeSender.getCaller());
        }, name -> sender -> Assertions.fail((String)("All command senders should be accepted to a NATIVE sender. " + sender.getClass().getSimpleName().toLowerCase() + " was not.")), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.PLAYER, ExecutorType.ENTITY, ExecutorType.CONSOLE, ExecutorType.BLOCK, ExecutorType.PROXY, ExecutorType.REMOTE);
        this.assertNoMoreResults(results);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3})
    void testAllExecution(int mode) {
        ExecutorType[] executorTypeArray;
        switch (mode) {
            case 0: {
                executorTypeArray = null;
                break;
            }
            case 1: {
                executorTypeArray = new ExecutorType[]{};
                break;
            }
            case 2: {
                ExecutorType[] executorTypeArray2 = new ExecutorType[1];
                executorTypeArray = executorTypeArray2;
                executorTypeArray2[0] = ExecutorType.ALL;
                break;
            }
            case 3: {
                ExecutorType[] executorTypeArray3 = new ExecutorType[6];
                executorTypeArray3[0] = ExecutorType.PLAYER;
                executorTypeArray3[1] = ExecutorType.ENTITY;
                executorTypeArray3[2] = ExecutorType.CONSOLE;
                executorTypeArray3[3] = ExecutorType.BLOCK;
                executorTypeArray3[4] = ExecutorType.PROXY;
                executorTypeArray = executorTypeArray3;
                executorTypeArray3[5] = ExecutorType.REMOTE;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected switch value " + mode));
            }
        }
        ExecutorType[] types = executorTypeArray;
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executes(info -> results.set((CommandSender)info.sender()), types)).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executes((sender, args) -> results.set(sender), types)).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executes(info -> {
            results.set((CommandSender)info.sender());
            return 2;
        }, types)).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executes((sender, args) -> {
            results.set(sender);
            return 2;
        }, types)).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, "normalinfo", results, sender), name -> sender -> Assertions.fail((String)("All command senders should be accepted to an ALL sender. " + sender.getClass().getSimpleName().toLowerCase() + " was not.")), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.PLAYER, ExecutorType.ENTITY, ExecutorType.CONSOLE, ExecutorType.BLOCK, ExecutorType.PROXY, ExecutorType.REMOTE);
        this.assertNoMoreResults(results);
    }

    @Test
    void testExecutesWithTwoTypes() {
        Mut results = Mut.of();
        ((CommandAPICommand)new CommandAPICommand("normalinfo").executes(info -> results.set((CommandSender)info.sender()), new ExecutorType[]{ExecutorType.PLAYER, ExecutorType.CONSOLE})).register();
        ((CommandAPICommand)new CommandAPICommand("normal").executes((sender, args) -> results.set(sender), new ExecutorType[]{ExecutorType.PLAYER, ExecutorType.CONSOLE})).register();
        ((CommandAPICommand)new CommandAPICommand("resultinginfo").executes(info -> {
            results.set((CommandSender)info.sender());
            return 2;
        }, new ExecutorType[]{ExecutorType.PLAYER, ExecutorType.CONSOLE})).register();
        ((CommandAPICommand)new CommandAPICommand("resulting").executes((sender, args) -> {
            results.set(sender);
            return 2;
        }, new ExecutorType[]{ExecutorType.PLAYER, ExecutorType.CONSOLE})).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.PLAYER, ExecutorType.CONSOLE);
    }

    @Test
    void testMultipleExecutors() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("normalinfo").executesConsole(info -> results.set((CommandSender)info.sender()))).executesPlayer(info -> results.set((CommandSender)info.sender()))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("normal").executesConsole((console, args) -> results.set(console))).executesPlayer((player, args) -> results.set(player))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("resultinginfo").executesConsole(info -> {
            results.set((CommandSender)info.sender());
            return 2;
        })).executesPlayer(info -> {
            results.set((CommandSender)info.sender());
            return 2;
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("resulting").executesConsole((console, args) -> {
            results.set(console);
            return 2;
        })).executesPlayer((player, args) -> {
            results.set(player);
            return 2;
        })).register();
        this.testAllCommands(name -> sender -> this.assertStoresResult((CommandSender)sender, (String)name, results, sender), name -> sender -> this.assertCommandFailsWith((CommandSender)sender, (String)name, "This command has no implementations for " + sender.getClass().getSimpleName().toLowerCase()), List.of("normal", "normalinfo", "resultinginfo", "resulting"), ExecutorType.PLAYER, ExecutorType.CONSOLE);
    }
}

