/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.wrappers;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SimpleFunctionWrapperTests
extends TestBase {
    SimpleFunctionWrapperTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Assumptions.assumeTrue((boolean)this.version.lessThan(MCVersion.V1_20_3));
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mysay").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executesPlayer(P_EXEC)).register();
        this.server.addPlayer();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testSimpleFunctionWrapperFunctionLookup() {
        NamespacedKey key = NamespacedKey.fromString((String)"ns:myfunc");
        MockPlatform.getInstance().addFunction(key, List.of("mysay hi", "mysay bye"));
        SimpleFunctionWrapper wrapper = SimpleFunctionWrapper.getFunction((NamespacedKey)key);
        Assertions.assertEquals((Object)key, (Object)wrapper.getKey());
        Assertions.assertArrayEquals((Object[])new String[]{"mysay hi", "mysay bye"}, (Object[])wrapper.getCommands());
    }

    @Test
    void testSimpleFunctionWrapperListOfFunctions() {
        List<NamespacedKey> keys = List.of(NamespacedKey.fromString((String)"ns:myfunc1"), NamespacedKey.fromString((String)"namespace:myfunc2"), NamespacedKey.fromString((String)"myfunc3"));
        for (int i = 0; i < keys.size(); ++i) {
            MockPlatform.getInstance().addFunction(keys.get(i), List.of("mysay hi " + i));
        }
        Set functions = SimpleFunctionWrapper.getFunctions();
        Assertions.assertEquals(keys.stream().collect(Collectors.toSet()), (Object)functions);
    }
}

