/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.UUIDArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class ArgumentUUIDTests
extends TestBase {
    ArgumentUUIDTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @RepeatedTest(value=10)
    void executionTestWithUUIDArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new UUIDArgument("uuid")})).executesPlayer((player, args) -> results.set((UUID)args.get("uuid")))).register();
        PlayerMock player2 = this.server.addPlayer();
        UUID randomUUID = UUID.randomUUID();
        this.server.dispatchCommand((CommandSender)player2, "test " + String.valueOf(randomUUID));
        Assertions.assertEquals((Object)randomUUID, results.get());
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.assertCommandFailsWith((CommandSender)player2, "test blah", "Invalid UUID at position 5: test <--[HERE]");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test blah", "Invalid UUID");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithUUIDArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new UUIDArgument("uuid")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

