/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ScoreboardSlotArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentScoreboardSlotTests
extends TestBase {
    ArgumentScoreboardSlotTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithScoreboardSlotArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ScoreboardSlotArgument("slot")})).executesPlayer((player, args) -> results.set((ScoreboardSlot)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        if (this.version.lessThan(MCVersion.V1_20_2)) {
            this.server.dispatchCommand((CommandSender)player2, "test belowName");
            Assertions.assertEquals((Object)ScoreboardSlot.BELOW_NAME, results.get());
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test below_name");
            Assertions.assertEquals((Object)ScoreboardSlot.BELOW_NAME, results.get());
        }
        this.server.dispatchCommand((CommandSender)player2, "test list");
        Assertions.assertEquals((Object)ScoreboardSlot.PLAYER_LIST, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test sidebar");
        Assertions.assertEquals((Object)ScoreboardSlot.SIDEBAR, results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithScoreboardSlotTeamsArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ScoreboardSlotArgument("slot")})).executesPlayer((player, args) -> results.set((ScoreboardSlot)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (ChatColor color : ChatColor.values()) {
            if (!color.isColor()) continue;
            ScoreboardSlot expected = ScoreboardSlot.ofTeamColor((ChatColor)color);
            this.server.dispatchCommand((CommandSender)player2, "test sidebar.team." + color.name().toLowerCase());
            Assertions.assertEquals((Object)expected, results.get());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithScoreboardSlotArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ScoreboardSlotArgument("slot")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        List<String> expectedSuggestions = this.version.lessThan(MCVersion.V1_20_2) ? Stream.concat(Arrays.stream(ChatColor.values()).filter(ChatColor::isColor).map(c -> "sidebar.team." + c.name().toLowerCase()), List.of("belowName", "list", "sidebar").stream()).sorted().toList() : Stream.concat(Arrays.stream(ChatColor.values()).filter(ChatColor::isColor).map(c -> "sidebar.team." + c.name().toLowerCase()), List.of("below_name", "list", "sidebar").stream()).sorted().toList();
        Assertions.assertEquals(expectedSuggestions, this.server.getSuggestions((CommandSender)player, "test "));
    }
}

