/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.RotationArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.Rotation;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentRotationTests
extends TestBase {
    ArgumentRotationTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithRotationArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new RotationArgument("rotation")})).executesPlayer((player, args) -> results.set((Rotation)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 90 180");
        Rotation rotation = (Rotation)results.get();
        Assertions.assertEquals((float)90.0f, (float)rotation.getYaw());
        Assertions.assertEquals((float)180.0f, (float)rotation.getPitch());
        this.server.dispatchCommand((CommandSender)player2, "test 360 360");
        rotation = (Rotation)results.get();
        Assertions.assertEquals((float)360.0f, (float)rotation.getYaw());
        Assertions.assertEquals((float)360.0f, (float)rotation.getPitch());
        this.server.dispatchCommand((CommandSender)player2, "test ~ ~");
        rotation = (Rotation)results.get();
        Assertions.assertEquals((float)0.0f, (float)rotation.getYaw());
        Assertions.assertEquals((float)0.0f, (float)rotation.getPitch());
        player2.setLocation(new Location((World)new WorldMock(), 2.0, 2.0, 2.0, 75.0f, 135.0f));
        this.server.dispatchCommand((CommandSender)player2, "test ~ ~");
        rotation = (Rotation)results.get();
        Assertions.assertEquals((float)75.0f, (float)rotation.getYaw());
        Assertions.assertEquals((float)135.0f, (float)rotation.getPitch());
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithRotationArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new RotationArgument("rotation")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

