/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.FloatRangeArgument;
import dev.jorel.commandapi.arguments.IntegerRangeArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.IntegerRange;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentRangeTests
extends TestBase {
    ArgumentRangeTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithIntegerRangeArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerRangeArgument("value")})).executesPlayer((player, args) -> results.set((IntegerRange)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        IntegerRange testZeroToTen = new IntegerRange(0, 10);
        this.server.dispatchCommand((CommandSender)player2, "test 0..10");
        Assertions.assertEquals((Object)testZeroToTen, results.get());
        IntegerRange testMinusTenToZero = new IntegerRange(-10, 0);
        this.server.dispatchCommand((CommandSender)player2, "test -10..0");
        Assertions.assertEquals((Object)testMinusTenToZero, results.get());
        IntegerRange testTenToTen = new IntegerRange(10, 10);
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((Object)testTenToTen, results.get());
        IntegerRange testMinIntToMaxInt = new IntegerRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.server.dispatchCommand((CommandSender)player2, "test -2147483648..2147483647");
        Assertions.assertEquals((Object)testMinIntToMaxInt, results.get());
        IntegerRange testMinIntToMaxIntWithoutLower = IntegerRange.integerRangeLessThanOrEq((int)Integer.MAX_VALUE);
        this.server.dispatchCommand((CommandSender)player2, "test ..2147483647");
        Assertions.assertEquals((Object)testMinIntToMaxIntWithoutLower, results.get());
        IntegerRange testMinIntToMaxIntWithoutUpper = IntegerRange.integerRangeGreaterThanOrEq((int)Integer.MIN_VALUE);
        this.server.dispatchCommand((CommandSender)player2, "test -2147483648..");
        Assertions.assertEquals((Object)testMinIntToMaxIntWithoutUpper, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test -2147483648..2147483648", "Invalid integer '2147483648' at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test -2147483649..2147483647", "Invalid integer '-2147483649' at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test hello123..10", "Expected value or range of values at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 123hello..10", "Expected whitespace to end one argument, but found trailing data at position 8: test 123<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithFloatRangeArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FloatRangeArgument("value")})).executesPlayer((player, args) -> results.set((FloatRange)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        String floatMinValue = String.format(Locale.ENGLISH, "%f", Float.valueOf(-3.4028235E38f));
        String floatMaxValue = String.format(Locale.ENGLISH, "%f", Float.valueOf(Float.MAX_VALUE));
        FloatRange testZeroToTen = new FloatRange(0.0f, 10.0f);
        this.server.dispatchCommand((CommandSender)player2, "test 0.0..10.0");
        Assertions.assertEquals((Object)testZeroToTen, results.get());
        FloatRange testMinusTenToZero = new FloatRange(-10.0f, 0.0f);
        this.server.dispatchCommand((CommandSender)player2, "test -10.0..0.0");
        Assertions.assertEquals((Object)testMinusTenToZero, results.get());
        FloatRange testTenToTen = new FloatRange(10.0f, 10.0f);
        this.server.dispatchCommand((CommandSender)player2, "test 10.0");
        Assertions.assertEquals((Object)testTenToTen, results.get());
        FloatRange testMinIntToMaxInt = new FloatRange(-3.4028235E38f, Float.MAX_VALUE);
        String floatMinToMax = "test " + floatMinValue + ".." + floatMaxValue;
        this.server.dispatchCommand((CommandSender)player2, floatMinToMax);
        Assertions.assertEquals((Object)testMinIntToMaxInt, results.get());
        FloatRange testMinIntToMaxIntWithoutLower = FloatRange.floatRangeLessThanOrEq((float)Float.MAX_VALUE);
        String floatUntilMax = "test .." + floatMaxValue;
        this.server.dispatchCommand((CommandSender)player2, floatUntilMax);
        Assertions.assertEquals((Object)testMinIntToMaxIntWithoutLower, results.get());
        FloatRange testMinIntToMaxIntWithoutUpper = FloatRange.floatRangeGreaterThanOrEq((float)-3.4028235E38f);
        String floatFromMin = "test " + floatMinValue + "..";
        this.server.dispatchCommand((CommandSender)player2, floatFromMin);
        Assertions.assertEquals((Object)testMinIntToMaxIntWithoutUpper, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test hello123..10.0", "Expected value or range of values at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 123hello..10.0", "Expected whitespace to end one argument, but found trailing data at position 8: test 123<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithIntegerRangeArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new IntegerRangeArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithFloatRangeArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FloatRangeArgument("value")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

