/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.MapArgumentBuilder;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.arguments.StringParser;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class ArgumentMapTests
extends TestBase {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void exceptionTestWithMapArgument() {
        CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer(P_EXEC);
        Assertions.assertDoesNotThrow(() -> command.register());
        command.withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")});
        Assertions.assertThrows(GreedyArgumentException.class, () -> ((CommandAPICommand)command).register());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MapArgumentBuilder("map", ':', null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MapArgumentBuilder("map", ':', ""));
        Assertions.assertDoesNotThrow(() -> new MapArgumentBuilder("map", ':', " "));
    }

    @Test
    void executionTestWithMapArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        LinkedHashMap<String, String> expectedMap = new LinkedHashMap<String, String>();
        expectedMap.put("key1", "value1");
        this.assertStoresResult((CommandSender)player2, "test key1:value1", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"key1\":\"value1\"", results, expectedMap);
        expectedMap.put("key2", "value2");
        this.assertStoresResult((CommandSender)player2, "test key1:value1 key2:value2", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"key1\":\"value1\" \"key2\":\"value2\"", results, expectedMap);
        expectedMap.put("key3", "value3");
        this.assertStoresResult((CommandSender)player2, "test key1:value1 key2:value2 key3:value3", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"key1\":\"value1\" \"key2\":\"value2\" \"key3\":\"value3\"", results, expectedMap);
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key1:value2", "Could not parse command: Duplicate keys are not allowed! at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 \"key1\":value2", "Could not parse command: Duplicate keys are not allowed! at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key1", "Could not parse command: Duplicate keys are not allowed! at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key2:value1", "Could not parse command: Duplicate values are not allowed! at position 17: ...lue1 key2:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key2:\"value1\"", "Could not parse command: Duplicate values are not allowed! at position 17: ...lue1 key2:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key2:", "Could not parse command: Expected a value after the delimiter at position 17: ...lue1 key2:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 \"key2\":", "Could not parse command: Expected a value after the delimiter at position 19: ...e1 \"key2\":<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 ", "Could not parse command: Expected a key after the separator at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:\"value1\" ", "Could not parse command: Expected a key after the separator at position 14: ...:\"value1\" <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key2", "Could not parse command: Delimiter \":\" required after writing a key at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 \"key2\"", "Could not parse command: Delimiter \":\" required after writing a key at position 18: ...ue1 \"key2\"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 \"key2\"=value2", "Could not parse command: Delimiter \":\" required after writing a key at position 18: ...ue1 \"key2\"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:\"value1\",key2=value2", "Could not parse command: Separator \" \" required after writing a value at position 13: ...1:\"value1\"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 \"key2", "Could not parse command: A quoted key must end with a quotation mark at position 13: ...1:value1 \"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key2:\"value2", "Could not parse command: A quoted value must end with a quotation mark at position 18: ...ue1 key2:\"<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithSpecialCharacters() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.assertStoresResult((CommandSender)player2, "test \\\"HelloWorld\":value", results, Map.of("\"HelloWorld\"", "value"));
        this.assertStoresResult((CommandSender)player2, "test \"\\\"HelloWorld\\\"\":value", results, Map.of("\"HelloWorld\"", "value"));
        this.assertStoresResult((CommandSender)player2, "test key:\\\"HelloWorld\"", results, Map.of("key", "\"HelloWorld\""));
        this.assertStoresResult((CommandSender)player2, "test key:\"\\\"HelloWorld\\\"\"", results, Map.of("key", "\"HelloWorld\""));
        this.assertCommandFailsWith((CommandSender)player2, "test \"key1\\\":value1 \"key2\":value2", "Could not parse command: Delimiter \":\" required after writing a key at position 16: ...\":value1 \"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:\"value1\\\" key2:\"value2\"", "Could not parse command: Separator \" \" required after writing a value at position 21: ...1\\\" key2:\"<--[HERE]");
        this.assertStoresResult((CommandSender)player2, "test ke\\\\y:value", results, Map.of("ke\\y", "value"));
        this.assertStoresResult((CommandSender)player2, "test \"ke\\\\y\":value", results, Map.of("ke\\y", "value"));
        this.assertStoresResult((CommandSender)player2, "test key:val\\\\ue", results, Map.of("key", "val\\ue"));
        this.assertStoresResult((CommandSender)player2, "test key:val\\\\ue", results, Map.of("key", "val\\ue"));
        this.assertStoresResult((CommandSender)player2, "test ke\\:y1:value1 key2:value2", results, Map.of("ke:y1", "value1", "key2", "value2"));
        this.assertStoresResult((CommandSender)player2, "test \"ke:y1\":value1 key2:value2", results, Map.of("ke:y1", "value1", "key2", "value2"));
        this.assertStoresResult((CommandSender)player2, "test key1:val\\ ue1 key2:value2", results, Map.of("key1", "val ue1", "key2", "value2"));
        this.assertStoresResult((CommandSender)player2, "test key1:\"val ue1\" key2:value2", results, Map.of("key1", "val ue1", "key2", "value2"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNonSpecialCharacters() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (char c = ' '; c < '\u007f'; c = (char)((char)(c + 1))) {
            if (c == '\"' || c == '\\' || c == ':' || c == ' ') continue;
            this.assertStoresResult((CommandSender)player2, "test " + c + ":" + c, results, Map.of(String.valueOf(c), String.valueOf(c)));
            this.assertStoresResult((CommandSender)player2, "test \"" + c + "\":\"" + c + "\"", results, Map.of(String.valueOf(c), String.valueOf(c)));
        }
        this.assertNoMoreResults(results);
    }

    @RepeatedTest(value=10)
    void executionTestWithPlayerNameKeys() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        String possibleChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        StringBuilder playerNameBuilder = new StringBuilder();
        for (int i = 0; i < ThreadLocalRandom.current().nextInt(3, 17); ++i) {
            playerNameBuilder.append(possibleChars.charAt(ThreadLocalRandom.current().nextInt(0, possibleChars.length())));
        }
        String playerName = playerNameBuilder.toString();
        this.assertStoresResult((CommandSender)player2, "test " + playerName + ":\"value\"", results, Map.of(playerName, "value"));
        this.assertStoresResult((CommandSender)player2, "test \"" + playerName + "\":\"value\"", results, Map.of(playerName, "value"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithLongTerminators() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", ':', ",  ").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        LinkedHashMap<String, String> expectedMap = new LinkedHashMap<String, String>();
        expectedMap.put("key1", "value1");
        this.assertStoresResult((CommandSender)player2, "test key1:value1", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"key1\":\"value1\"", results, expectedMap);
        expectedMap.put("key2", "value2");
        this.assertStoresResult((CommandSender)player2, "test key1:value1,  key2:value2", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"key1\":\"value1\",  \"key2\":\"value2\"", results, expectedMap);
        expectedMap.put("key3", "value3");
        this.assertStoresResult((CommandSender)player2, "test key1:value1,  key2:value2,  key3:value3", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"key1\":\"value1\",  \"key2\":\"value2\",  \"key3\":\"value3\"", results, expectedMap);
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1,  key2", "Could not parse command: Delimiter \":\" required after writing a key at position 14: ...:value1,  <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1,  \"key2\"", "Could not parse command: Delimiter \":\" required after writing a key at position 20: ...1,  \"key2\"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1,  \"key2\"=value2", "Could not parse command: Delimiter \":\" required after writing a key at position 20: ...1,  \"key2\"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:\"value1\",key2:value2", "Could not parse command: Separator \",  \" required after writing a value at position 13: ...1:\"value1\"<--[HERE]");
        this.assertStoresResult((CommandSender)player2, "test a-b-c:a, b, and c,  key2:value2", results, Map.of("a-b-c", "a, b, and c", "key2", "value2"));
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1,  key2--", "Could not parse command: Delimiter \":\" required after writing a key at position 14: ...:value1,  <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1,  \"key2\"--", "Could not parse command: Delimiter \":\" required after writing a key at position 20: ...1,  \"key2\"<--[HERE]");
        this.assertStoresResult((CommandSender)player2, "test key1:value1,", results, Map.of("key1", "value1,"));
        this.assertCommandFailsWith((CommandSender)player2, "test key1:\"value1\",", "Could not parse command: Separator \",  \" required after writing a value at position 13: ...1:\"value1\"<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithCustomMappers() {
        Mut results = Mut.of();
        StringParser customMapper = s -> {
            int i = Integer.parseInt(s);
            if (i < 0 || i > 255) {
                throw CommandAPI.failWithString((String)"Must be between 0 and 255");
            }
            return i;
        };
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(customMapper).withValueMapper(customMapper).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        LinkedHashMap<Integer, Integer> expectedMap = new LinkedHashMap<Integer, Integer>();
        expectedMap.put(0, 10);
        this.assertStoresResult((CommandSender)player2, "test 0:10", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"0\":\"10\"", results, expectedMap);
        expectedMap.put(20, 100);
        this.assertStoresResult((CommandSender)player2, "test 0:10 20:100", results, expectedMap);
        this.assertStoresResult((CommandSender)player2, "test \"0\":\"10\" \"20\":\"100\"", results, expectedMap);
        this.assertCommandFailsWith((CommandSender)player2, "test key:100", "Could not parse command: Invalid key (key): cannot be converted to a key at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test \"key\":100", "Could not parse command: Invalid key (key): cannot be converted to a key at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 100:value", "Could not parse command: Invalid value (value): cannot be converted to a value at position 4: 100:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 100:\"value\"", "Could not parse command: Invalid value (value): cannot be converted to a value at position 4: 100:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 1000:0", "Could not parse command: Must be between 0 and 255 at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test -10:0", "Could not parse command: Must be between 0 and 255 at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test \"1000\":0", "Could not parse command: Must be between 0 and 255 at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test \"-10\":0", "Could not parse command: Must be between 0 and 255 at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 0:1000", "Could not parse command: Must be between 0 and 255 at position 2: 0:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 0:-10", "Could not parse command: Must be between 0 and 255 at position 2: 0:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 0:\"1000\"", "Could not parse command: Must be between 0 and 255 at position 2: 0:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test 0:\"-10\"", "Could not parse command: Must be between 0 and 255 at position 2: 0:<--[HERE]");
    }

    @Test
    void executionTestWithFloatKey() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(Float::valueOf).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 3.5:\"Hello World\" 12.25:\"This is a test!\"");
        LinkedHashMap<Float, String> testMap = new LinkedHashMap<Float, String>();
        testMap.put(Float.valueOf(3.5f), "Hello World");
        testMap.put(Float.valueOf(12.25f), "This is a test!");
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test 3.5:\"Hello World\" 12.25:\"This is a test!\" 6.25:\"And this is a third value!\"");
        testMap.put(Float.valueOf(6.25f), "And this is a third value!");
        Assertions.assertEquals(testMap, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test 3,5:\"Hello world!\"", "Could not parse command: Invalid key (3,5): cannot be converted to a key at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithLists() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withKeyList(List.of("key1", "key2", "key3")).withValueList(List.of("value1", "value2", "value3")).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key1:value2", "Could not parse command: Duplicate keys are not allowed! at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 \"key1\":value2", "Could not parse command: Duplicate keys are not allowed! at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key1", "Could not parse command: Duplicate keys are not allowed! at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key2:value1", "Could not parse command: Duplicate values are not allowed! at position 17: ...lue1 key2:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key2:\"value1\"", "Could not parse command: Duplicate values are not allowed! at position 17: ...lue1 key2:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key4:value2", "Could not parse command: Invalid key: key4 at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 \"key4\":value2", "Could not parse command: Invalid key: key4 at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key4", "Could not parse command: Invalid key: key4 at position 12: ...y1:value1 <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key2:value4", "Could not parse command: Invalid value: value4 at position 17: ...lue1 key2:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key2:\"value4\"", "Could not parse command: Invalid value: value4 at position 17: ...lue1 key2:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test key1:value1 key2", "Could not parse command: Delimiter \":\" required after writing a key at position 12: ...y1:value1 <--[HERE]");
    }

    @Test
    void executionTestWithDuplicateValues() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList(true).build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.assertStoresResult((CommandSender)player2, "test key1:value key2:value", results, Map.of("key1", "value", "key2", "value"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithDuplicateValuesAndList() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withValueList(List.of("value1", "value2", "value3"), true).build()})).executesPlayer((player, args) -> results.set((Map)args.getUnchecked("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.assertStoresResult((CommandSender)player2, "test key1:value1 key2:value1", results, Map.of("key1", "value1", "key2", "value1"));
        this.assertCommandFailsWith((CommandSender)player2, "test key1:value1 key2:value4", "Could not parse command: Invalid value: value4 at position 17: ...lue1 key2:<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithMapArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertNoSuggestions((CommandSender)player, "test ");
        this.assertCommandSuggests((CommandSender)player, "test \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test a", "a:");
        this.assertCommandSuggests((CommandSender)player, "test ab", "ab:");
        this.assertCommandSuggests((CommandSender)player, "test abc", "abc:");
        this.assertCommandSuggests((CommandSender)player, "test \"a", "\"a\":");
        this.assertCommandSuggests((CommandSender)player, "test \"ab", "\"ab\":");
        this.assertCommandSuggests((CommandSender)player, "test \"abc", "\"abc\":");
        this.assertCommandSuggests((CommandSender)player, "test \"abc\"", ":");
        this.assertNoSuggestions((CommandSender)player, "test \"abc\"=");
        this.assertNoSuggestions((CommandSender)player, "test abc:");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"", "\"\" ");
        this.assertCommandSuggests((CommandSender)player, "test abc:a", "a ");
        this.assertCommandSuggests((CommandSender)player, "test abc:ab", "ab ");
        this.assertCommandSuggests((CommandSender)player, "test abc:abc", "abc ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"a", "\"a\" ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"ab", "\"ab\" ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"abc", "\"abc\" ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"abc\"", " ");
        this.assertNoSuggestions((CommandSender)player, "test abc:\"abc\",");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 a", "a:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 ab", "ab:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc", "abc:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 \"a", "\"a\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 \"ab", "\"ab\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 \"abc", "\"abc\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 \"abc\"", ":");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 \"abc\"=");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 abc:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:\"", "\"\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:a", "a ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:ab", "ab ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:abc", "abc ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:\"a", "\"a\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:\"ab", "\"ab\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:\"abc", "\"abc\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 abc:\"abc\"", " ");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 abc:\"abc\",");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 k2:v2 ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 a", "a:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 ab", "ab:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc", "abc:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 \"a", "\"a\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 \"ab", "\"ab\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 \"abc", "\"abc\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 \"abc\"", ":");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 k2:v2 \"abc\"=");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 k2:v2 abc:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:\"", "\"\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:a", "a ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:ab", "ab ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:abc", "abc ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:\"a", "\"a\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:\"ab", "\"ab\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:\"abc", "\"abc\" ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1 k2:v2 abc:\"abc\"", " ");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1 k2:v2 abc:\"abc\",");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1 key1:value2");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1 \"key1\":value2");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1 key2:value1 a");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1 key2:\"value1\" a");
    }

    @Test
    void suggestionTestWithSpecialCharacters() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandSuggests((CommandSender)player, "test \\\"a\"b", "\\\"a\"b:");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\"a\\\"b", "\"\\\"a\\\"b\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\"a\\\"b\"", ":");
        this.assertCommandSuggests((CommandSender)player, "test abc:\\\"a\"b", "\\\"a\"b ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"\\\"a\\\"b", "\"\\\"a\\\"b\" ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"\\\"a\\\"b\"", " ");
        this.assertNoSuggestions((CommandSender)player, "test \"key1\\\":value1 \"key2\":value2");
        this.assertNoSuggestions((CommandSender)player, "test key1:\"value1\\\" key2:\"value2\"");
        this.assertCommandSuggests((CommandSender)player, "test \\\\a\\\\b", "\\\\a\\\\b:");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\a\\\\b", "\"\\\\a\\\\b\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\a\\\\b\"", ":");
        this.assertCommandSuggests((CommandSender)player, "test abc:\\\\a\\\\b", "\\\\a\\\\b ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"\\\\a\\\\b", "\"\\\\a\\\\b\" ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"\\\\a\\\\b\"", " ");
        this.assertCommandSuggests((CommandSender)player, "test \\", "\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\\", "\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\\\\", "\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\\\\\\", "\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test a\\", "a\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test a\\\\", "a\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test a\\\\\\", "a\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test a\\\\\\\\", "a\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\\a\\", "\\\\a\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\\a\\\\", "\\\\a\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\\a\\\\\\", "\\\\a\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\\a\\\\\\\\", "\\\\a\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\"a\\", "\\\"a\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\"a\\\\", "\\\"a\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\"a\\\\\\", "\\\"a\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \\\"a\\\\\\\\", "\\\"a\\\\\\\\:");
        this.assertCommandSuggests((CommandSender)player, "test \"\\", "\"\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\", "\"\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\\\", "\"\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\\\\\", "\"\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"a\\", "\"a\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"a\\\\", "\"a\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"a\\\\\\", "\"a\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"a\\\\\\\\", "\"a\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\a\\", "\"\\\\a\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\a\\\\", "\"\\\\a\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\a\\\\\\", "\"\\\\a\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\\a\\\\\\\\", "\"\\\\a\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\"a\\", "\"\\\"a\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\"a\\\\", "\"\\\"a\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\"a\\\\\\", "\"\\\"a\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test \"\\\"a\\\\\\\\", "\"\\\"a\\\\\\\\\":");
        this.assertCommandSuggests((CommandSender)player, "test key:\\", "\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\\", "\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\\\\", "\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\\\\\\", "\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:a\\", "a\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:a\\\\", "a\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:a\\\\\\", "a\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:a\\\\\\\\", "a\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\\a\\", "\\\\a\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\\a\\\\", "\\\\a\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\\a\\\\\\", "\\\\a\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\\a\\\\\\\\", "\\\\a\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\"a\\", "\\\"a\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\"a\\\\", "\\\"a\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\"a\\\\\\", "\\\"a\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\\\"a\\\\\\\\", "\\\"a\\\\\\\\ ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\", "\"\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\\", "\"\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\\\\", "\"\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\\\\\\", "\"\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"a\\", "\"a\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"a\\\\", "\"a\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"a\\\\\\", "\"a\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"a\\\\\\\\", "\"a\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\\a\\", "\"\\\\a\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\\a\\\\", "\"\\\\a\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\\a\\\\\\", "\"\\\\a\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\\a\\\\\\\\", "\"\\\\a\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\"a\\", "\"\\\"a\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\"a\\\\", "\"\\\"a\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\"a\\\\\\", "\"\\\"a\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"\\\"a\\\\\\\\", "\"\\\"a\\\\\\\\\" ");
        this.assertCommandSuggests((CommandSender)player, "test ke\\:y", "ke\\:y:");
        this.assertCommandSuggests((CommandSender)player, "test \"ke:y", "\"ke:y\":");
        this.assertCommandSuggests((CommandSender)player, "test \"ke:y\"", ":");
        this.assertCommandSuggests((CommandSender)player, "test key:val\\ ue", "val\\ ue ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"val ue", "\"val ue\" ");
        this.assertCommandSuggests((CommandSender)player, "test key:\"val ue\"", " ");
    }

    @Test
    void suggestionTestWithNonSpecialCharacters() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        for (char c = ' '; c < '\u007f'; c = (char)((char)(c + 1))) {
            if (c == '\"' || c == '\\' || c == ':' || c == ' ') continue;
            this.assertCommandSuggests((CommandSender)player, "test " + c, c + ":");
            this.assertCommandSuggests((CommandSender)player, "test key:" + c, c + " ");
            this.assertCommandSuggests((CommandSender)player, "test \"" + c, "\"" + c + "\":");
            this.assertCommandSuggests((CommandSender)player, "test key:\"" + c, "\"" + c + "\" ");
        }
    }

    @Test
    void suggestionTestWithLongTerminators() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", ':', ",  ").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertNoSuggestions((CommandSender)player, "test ");
        this.assertCommandSuggests((CommandSender)player, "test \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test abc", "abc:");
        this.assertCommandSuggests((CommandSender)player, "test \"abc", "\"abc\":");
        this.assertCommandSuggests((CommandSender)player, "test \"abc\"", ":");
        this.assertNoSuggestions((CommandSender)player, "test \"abc\"===");
        this.assertNoSuggestions((CommandSender)player, "test abc:");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"", "\"\",  ");
        this.assertCommandSuggests((CommandSender)player, "test abc:abc", "abc,  ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"abc", "\"abc\",  ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"abc\"", ",  ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"abc\"=", ",  ");
        this.assertCommandSuggests((CommandSender)player, "test abc:\"abc\"==", ",  ");
        this.assertNoSuggestions((CommandSender)player, "test abc:\"abc\"===");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1,  ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  abc", "abc:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  \"abc", "\"abc\":");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  \"abc\"", ":");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1,  \"abc\"===");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1,  abc:");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  abc:\"", "\"\",  ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  abc:abc", "abc,  ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  abc:\"abc", "\"abc\",  ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  abc:\"abc\"", ",  ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  abc:\"abc\"=", ",  ");
        this.assertCommandSuggests((CommandSender)player, "test k1:v1,  abc:\"abc\"==", ",  ");
        this.assertNoSuggestions((CommandSender)player, "test k1:v1,  abc:\"abc\"===");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1,  key1:value2");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1,  \"key1\":value2");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1,  key2:value1,  a");
        this.assertNoSuggestions((CommandSender)player, "test key1:value1,  key2:\"value1\",  a");
    }

    @Test
    void suggestionTestWithCustomMappers() {
        StringParser customMapper = s -> {
            int i = Integer.parseInt(s);
            if (i < 0 || i > 255) {
                throw CommandAPI.failWithString((String)"Must be between 0 and 255");
            }
            return i;
        };
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(customMapper).withValueMapper(customMapper).withoutKeyList().withoutValueList().build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandSuggests((CommandSender)player, "test 0:10 \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test 0:10 20:100 \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test \"0\":\"10\" \"", "\"\":");
        this.assertCommandSuggests((CommandSender)player, "test \"0\":\"10\" \"20\":\"100\" \"", "\"\":");
        this.assertNoSuggestions((CommandSender)player, "test key:100");
        this.assertNoSuggestions((CommandSender)player, "test \"key\":100");
        this.assertNoSuggestions((CommandSender)player, "test 100:value 1");
        this.assertNoSuggestions((CommandSender)player, "test 100:\"value\" 1");
        this.assertNoSuggestions((CommandSender)player, "test 1000:0");
        this.assertNoSuggestions((CommandSender)player, "test -10:0");
        this.assertNoSuggestions((CommandSender)player, "test \"1000\":0");
        this.assertNoSuggestions((CommandSender)player, "test \"-10\":0");
        this.assertNoSuggestions((CommandSender)player, "test 0:1000 1");
        this.assertNoSuggestions((CommandSender)player, "test 0:-10 1");
        this.assertNoSuggestions((CommandSender)player, "test 0:\"1000\" 1");
        this.assertNoSuggestions((CommandSender)player, "test 0:\"-10\" 1");
    }

    @Test
    void suggestionTestWithLists() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withKeyList(List.of("alpha", "alphabet", "bear", "bearing", "charlie")).withValueList(List.of("alpha", "alphabet", "bear", "bearing", "candy")).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandSuggests((CommandSender)player, "test ", "alpha", "alphabet", "bear", "bearing", "charlie");
        this.assertCommandSuggests((CommandSender)player, "test \"", "\"alpha\"", "\"alphabet\"", "\"bear\"", "\"bearing\"", "\"charlie\"");
        this.assertCommandSuggests((CommandSender)player, "test a", "alpha", "alphabet");
        this.assertCommandSuggests((CommandSender)player, "test b", "bear", "bearing");
        this.assertCommandSuggests((CommandSender)player, "test c", "charlie");
        this.assertCommandSuggests((CommandSender)player, "test \"a", "\"alpha\"", "\"alphabet\"");
        this.assertCommandSuggests((CommandSender)player, "test \"b", "\"bear\"", "\"bearing\"");
        this.assertCommandSuggests((CommandSender)player, "test \"c", "\"charlie\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha", "alpha:", "alphabet");
        this.assertCommandSuggests((CommandSender)player, "test bear", "bear:", "bearing");
        this.assertCommandSuggests((CommandSender)player, "test charlie", "charlie:");
        this.assertCommandSuggests((CommandSender)player, "test \"alpha", "\"alpha\":", "\"alphabet\"");
        this.assertCommandSuggests((CommandSender)player, "test \"bear", "\"bear\":", "\"bearing\"");
        this.assertCommandSuggests((CommandSender)player, "test \"charlie", "\"charlie\":");
        this.assertCommandSuggests((CommandSender)player, "test \"alpha\"", ":");
        this.assertNoSuggestions((CommandSender)player, "test \"alpha\"=");
        this.assertCommandSuggests((CommandSender)player, "test alpha:", "alpha", "alphabet", "bear", "bearing", "candy");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"", "\"alpha\"", "\"alphabet\"", "\"bear\"", "\"bearing\"", "\"candy\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:a", "alpha", "alphabet");
        this.assertCommandSuggests((CommandSender)player, "test alpha:b", "bear", "bearing");
        this.assertCommandSuggests((CommandSender)player, "test alpha:c", "candy");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"a", "\"alpha\"", "\"alphabet\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"b", "\"bear\"", "\"bearing\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"c", "\"candy\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha", "alpha ", "alphabet");
        this.assertCommandSuggests((CommandSender)player, "test alpha:bear", "bear ", "bearing");
        this.assertCommandSuggests((CommandSender)player, "test alpha:candy", "candy ");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"alpha", "\"alpha\" ", "\"alphabet\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"bear", "\"bear\" ", "\"bearing\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"candy", "\"candy\" ");
        this.assertCommandSuggests((CommandSender)player, "test alpha:\"alpha\"", " ");
        this.assertNoSuggestions((CommandSender)player, "test alpha:\"alpha\"=");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha ", "alphabet", "bear", "bearing", "charlie");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha \"", "\"alphabet\"", "\"bear\"", "\"bearing\"", "\"charlie\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha bear:", "alphabet", "bear", "bearing", "candy");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha bear:\"", "\"alphabet\"", "\"bear\"", "\"bearing\"", "\"candy\"");
        this.assertCommandSuggests((CommandSender)player, "test alphabet:alphabet ", "alpha", "bear", "bearing", "charlie");
        this.assertCommandSuggests((CommandSender)player, "test alphabet:alphabet \"", "\"alpha\"", "\"bear\"", "\"bearing\"", "\"charlie\"");
        this.assertCommandSuggests((CommandSender)player, "test alphabet:alphabet alpha:", "alpha", "bear", "bearing", "candy");
        this.assertCommandSuggests((CommandSender)player, "test alphabet:alphabet alpha:\"", "\"alpha\"", "\"bear\"", "\"bearing\"", "\"candy\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha alphabet:alphabet ", "bear", "bearing", "charlie");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha alphabet:alphabet \"", "\"bear\"", "\"bearing\"", "\"charlie\"");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha alphabet:alphabet bear:", "bear", "bearing", "candy");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alpha alphabet:alphabet bear:\"", "\"bear\"", "\"bearing\"", "\"candy\"");
        this.assertNoSuggestions((CommandSender)player, "test alpha:alpha alpha:alphabet");
        this.assertNoSuggestions((CommandSender)player, "test alpha:alpha \"alpha\":alphabet");
        this.assertNoSuggestions((CommandSender)player, "test alpha:alpha alphabet:alpha b");
        this.assertNoSuggestions((CommandSender)player, "test alpha:alpha alphabet:\"alpha\" b");
        this.assertNoSuggestions((CommandSender)player, "test key:");
        this.assertNoSuggestions((CommandSender)player, "test \"key\":");
        this.assertNoSuggestions((CommandSender)player, "test alpha:value b");
        this.assertNoSuggestions((CommandSender)player, "test alpha:\"value\" b");
    }

    @Test
    void suggestionTestWithDuplicateValues() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList(true).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandSuggests((CommandSender)player, "test key1:value key2:value a", "a:");
    }

    @Test
    void suggestionTestWithDuplicateValuesAndList() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withValueList(List.of("value1", "value2", "value3"), true).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandSuggests((CommandSender)player, "test k1:value1 k2:value2 k3:value3 k4:", "value1", "value2", "value3");
    }

    @Test
    void suggestionTestWithSpecialCharactersAndList() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withKeyList(List.of("a:b", "a b", "a\\b", "a\"b", "\"ab")).withValueList(List.of("a:b", "a b", "a\\b", "a\"b", "\"ab")).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandSuggests((CommandSender)player, "test ", "\"a:b\"", "\\\"ab", "a b", "a\"b", "a\\\\b");
        this.assertCommandSuggests((CommandSender)player, "test a b:", "\"a b\"", "\\\"ab", "a\"b", "a:b", "a\\\\b");
        this.assertCommandSuggests((CommandSender)player, "test a", "a b", "a\"b", "a\\:b", "a\\\\b");
        this.assertCommandSuggests((CommandSender)player, "test a b:a", "a\"b", "a:b", "a\\ b", "a\\\\b");
        this.assertCommandSuggests((CommandSender)player, "test \"a", "\"a b\"", "\"a:b\"", "\"a\\\"b\"", "\"a\\\\b\"");
        this.assertCommandSuggests((CommandSender)player, "test a b:\"a", "\"a b\"", "\"a:b\"", "\"a\\\"b\"", "\"a\\\\b\"");
    }

    @Test
    void suggestionTestWithLongTerminatorsAndLists() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", ':', ",  ").withKeyMapper(s -> s).withValueMapper(s -> s).withKeyList(List.of("alpha", "alphabet", "bear", "bearing", "charlie", "a-b-c")).withValueList(List.of("alpha", "alphabet", "bear", "bearing", "candy", "a, b, c")).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandSuggests((CommandSender)player, "test alphab", "alpha:", "alphabet");
        this.assertCommandSuggests((CommandSender)player, "test alpha:alphab", "alpha,  ", "alphabet");
        this.assertCommandSuggests((CommandSender)player, "test a", "a-b-c", "alpha", "alphabet");
        this.assertCommandSuggests((CommandSender)player, "test alpha:a", "a, b, c", "alpha", "alphabet");
    }
}

