/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ListArgumentBuilder;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentListTests
extends TestBase {
    ArgumentListTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithListArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildGreedy()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list cat, wolf, axolotl");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list cat, wolf, axolotl, wolf", "Duplicate arguments are not allowed at position 20: ... axolotl, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list axolotl, wolf, chicken, cat", "Item is not allowed in list at position 15: ...tl, wolf, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListArgumentWithDuplicates() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").allowDuplicates(true).withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildGreedy()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list cat, wolf, axolotl");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "list cat, wolf, axolotl, cat, wolf");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl", "cat", "wolf"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list cat, wolf, axolotl, chicken, cat", "Item is not allowed in list at position 20: ... axolotl, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListArgumentWithConstantList() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(List.of("cat", "wolf", "axolotl")).withStringMapper().buildGreedy()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list cat, wolf, axolotl");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list cat, wolf, axolotl, wolf", "Duplicate arguments are not allowed at position 20: ... axolotl, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list axolotl, wolf, chicken, cat", "Item is not allowed in list at position 15: ...tl, wolf, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListArgumentWithConstantListArray() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(new Object[]{"cat", "wolf", "axolotl"}).withStringMapper().buildGreedy()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list cat, wolf, axolotl");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list cat, wolf, axolotl, wolf", "Duplicate arguments are not allowed at position 20: ... axolotl, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list axolotl, wolf, chicken, cat", "Item is not allowed in list at position 15: ...tl, wolf, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListArgumentWithFunctionList() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(info -> List.of("cat", "wolf", "axolotl", ((CommandSender)info.sender()).getName())).withStringMapper().buildGreedy()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list cat, wolf, axolotl");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "list axolotl, wolf, APlayer");
        Assertions.assertEquals(List.of("axolotl", "wolf", "APlayer"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list cat, wolf, axolotl, wolf", "Duplicate arguments are not allowed at position 20: ... axolotl, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list axolotl, wolf, chicken, cat", "Item is not allowed in list at position 15: ...tl, wolf, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListTextArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildText()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list \"cat, wolf, axolotl\"");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list \"cat, wolf, axolotl, wolf\"", "Duplicate arguments are not allowed at position 20: ... axolotl, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list \"axolotl, wolf, chicken, cat\"", "Item is not allowed in list at position 15: ...tl, wolf, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListTextArgumentWithDuplicates() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").allowDuplicates(true).withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildText()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list \"cat, wolf, axolotl\"");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "list \"cat, wolf, axolotl, cat, wolf\"");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl", "cat", "wolf"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list \"cat, wolf, axolotl, chicken, cat\"", "Item is not allowed in list at position 20: ... axolotl, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListTextArgumentWithConstantList() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(List.of("cat", "wolf", "axolotl")).withStringMapper().buildText()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list \"cat, wolf, axolotl\"");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list \"cat, wolf, axolotl, wolf\"", "Duplicate arguments are not allowed at position 20: ... axolotl, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list \"axolotl, wolf, chicken, cat\"", "Item is not allowed in list at position 15: ...tl, wolf, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListTextArgumentWithFunctionList() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(info -> List.of("cat", "wolf", "axolotl", ((CommandSender)info.sender()).getName())).withStringMapper().buildText()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list \"cat, wolf, axolotl\"");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "list \"axolotl, wolf, APlayer\"");
        Assertions.assertEquals(List.of("axolotl", "wolf", "APlayer"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list \"cat, wolf, axolotl, wolf\"", "Duplicate arguments are not allowed at position 20: ... axolotl, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list \"axolotl, wolf, chicken, cat\"", "Item is not allowed in list at position 15: ...tl, wolf, <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListTextArgumentAfterListTextArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(player -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildText()})).withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("morevalues", ", ").withList(player -> List.of("pumpkin", "melon", "cake")).withStringMapper().buildText()})).executesPlayer((player, args) -> {
            results.set((List)args.get(0));
            results.set((List)args.get(1));
        })).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list \"cat, wolf, axolotl\" \"pumpkin, melon\"");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        Assertions.assertEquals(List.of("pumpkin", "melon"), results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListArgumentWithNonStringMapper() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(() -> List.of(Material.DIRT, Material.GRASS_BLOCK, Material.DIAMOND)).withMapper(material -> material.getKey().getKey()).buildGreedy()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list dirt, grass_block");
        Assertions.assertEquals(List.of(Material.DIRT, Material.GRASS_BLOCK), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list dirt, dirt", "Duplicate arguments are not allowed at position 6: dirt, <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list iron_ingot", "Item is not allowed in list at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithListArgumentWithDefaultDelimiter() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values").withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildGreedy()})).executesPlayer((player, args) -> results.set((List)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "list cat wolf axolotl");
        Assertions.assertEquals(List.of("cat", "wolf", "axolotl"), results.get());
        this.assertCommandFailsWith((CommandSender)player2, "list cat wolf axolotl wolf", "Duplicate arguments are not allowed at position 17: ...f axolotl <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "list axolotl wolf chicken cat", "Item is not allowed in list at position 13: ...lotl wolf <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithListArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values").withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildGreedy()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("axolotl", "cat", "wolf"), this.server.getSuggestions((CommandSender)player, "list "));
        Assertions.assertEquals(List.of("axolotl", "wolf"), this.server.getSuggestions((CommandSender)player, "list cat "));
    }

    @Test
    void suggestionTestWithListArgumentWithDuplicates() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values").allowDuplicates(true).withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildGreedy()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("axolotl", "cat", "wolf"), this.server.getSuggestions((CommandSender)player, "list "));
        Assertions.assertEquals(List.of("axolotl", "cat", "wolf"), this.server.getSuggestions((CommandSender)player, "list cat "));
    }

    @Test
    void suggestionTestWithListArgumentDelimiter() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values", ", ").withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildGreedy()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("cat, "), this.server.getSuggestions((CommandSender)player, "list cat"));
    }

    @Test
    void suggestionTestWithListArgumentText() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("values").withList(() -> List.of("cat", "wolf", "axolotl")).withStringMapper().buildText()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("axolotl", "wolf"), this.server.getSuggestions((CommandSender)player, "list \"cat "));
    }
}

