/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ItemStackArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Disabled due to MockBukkit 1.20 issue. See https://github.com/MockBukkit/MockBukkit/issues/862 for more information")
class ArgumentItemStackTests
extends TestBase {
    ArgumentItemStackTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithItemStackArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ItemStackArgument("item")})).executesPlayer((player, args) -> results.set((ItemStack)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test dirt");
        Assertions.assertEquals((Object)new ItemStack(Material.DIRT), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:stone{Count:3b}");
        ItemStack actual = (ItemStack)results.get();
        Assertions.assertEquals((Object)Material.STONE, (Object)actual.getType());
        Assertions.assertEquals((int)3, (int)actual.getAmount());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:diamond_sword{Enchantments:[{id:\"minecraft:sharpness\",lvl:1s}]}");
        actual = (ItemStack)results.get();
        Assertions.assertEquals((Object)Material.DIAMOND_SWORD, (Object)actual.getType());
        Assertions.assertEquals((int)1, (int)actual.getAmount());
        Assertions.assertEquals((int)1, (int)actual.getEnchantmentLevel(Enchantment.DAMAGE_ALL));
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:leather_chestplate{display:{Name:'{\"text\":\"Tunic of Destiny\",\"color\":\"blue\"}',Lore:['{\"text\":\"A magical blue tunic\"}','{\"text\":\"worn by the gods...\"}'],color:3949738}}");
        actual = (ItemStack)results.get();
        ItemMeta actualMeta = actual.getItemMeta();
        Assertions.assertEquals((Object)Material.LEATHER_CHESTPLATE, (Object)actual.getType());
        Assertions.assertEquals((int)1, (int)actual.getAmount());
        Assertions.assertEquals((Object)(String.valueOf(ChatColor.BLUE) + "Tunic of Destiny"), (Object)actualMeta.getDisplayName());
        Assertions.assertEquals(List.of("A magical blue tunic", "worn by the gods..."), (Object)actualMeta.getLore());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:diamond_pickaxe{HideFlags:15}");
        actual = (ItemStack)results.get();
        Assertions.assertEquals((Object)Material.DIAMOND_PICKAXE, (Object)actual.getType());
        Assertions.assertEquals((int)1, (int)actual.getAmount());
        Assertions.assertTrue((boolean)actual.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS));
        Assertions.assertTrue((boolean)actual.getItemMeta().hasItemFlag(ItemFlag.HIDE_ATTRIBUTES));
        Assertions.assertTrue((boolean)actual.getItemMeta().hasItemFlag(ItemFlag.HIDE_UNBREAKABLE));
        Assertions.assertTrue((boolean)actual.getItemMeta().hasItemFlag(ItemFlag.HIDE_DESTROYS));
        this.server.dispatchCommand((CommandSender)player2, "test firework_rocket{Fireworks:{Explosions:[{Type:3b,Flicker:1b,Colors:[I;4312372],FadeColors:[I;11743532]}],Flight:1b}}");
        actual = (ItemStack)results.get();
        actualMeta = actual.getItemMeta();
        Assertions.assertEquals((Object)Material.FIREWORK_ROCKET, (Object)actual.getType());
        Assertions.assertEquals((int)1, (int)actual.getAmount());
        Assertions.assertInstanceOf(FireworkMeta.class, (Object)actualMeta);
        FireworkMeta fireworkMeta = (FireworkMeta)actualMeta;
        Assertions.assertEquals((int)1, (int)fireworkMeta.getEffectsSize());
        Assertions.assertEquals((int)1, (int)fireworkMeta.getPower());
        Assertions.assertTrue((boolean)((FireworkEffect)fireworkMeta.getEffects().get(0)).hasFlicker());
        Assertions.assertEquals((Object)FireworkEffect.Type.CREEPER, (Object)((FireworkEffect)fireworkMeta.getEffects().get(0)).getType());
        Assertions.assertEquals((Object)Color.fromRGB((int)4312372), ((FireworkEffect)fireworkMeta.getEffects().get(0)).getColors().get(0));
        Assertions.assertEquals((Object)Color.fromRGB((int)11743532), ((FireworkEffect)fireworkMeta.getEffects().get(0)).getFadeColors().get(0));
        this.assertCommandFailsWith((CommandSender)player2, "test item_that_doesnt_exist", "Unknown item 'minecraft:item_that_doesnt_exist' at position 5: test <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test dirt{invalid_nbt}", "Expected ':' at position 21: ...nvalid_nbt<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithItemStackArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ItemStackArgument("item")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals((Object)MockPlatform.getInstance().getAllItemNames(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(MockPlatform.getInstance().getAllItemNames().stream().filter(s -> s.contains(":a") || s.contains("_a")).toList(), this.server.getSuggestions((CommandSender)player, "test a"));
        Assertions.assertEquals(List.of("{"), this.server.getSuggestions((CommandSender)player, "test dirt"));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test dirt{"));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test dirt{}"));
    }
}

