/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ItemStackPredicateArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentItemStackPredicateTests
extends TestBase {
    ArgumentItemStackPredicateTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithItemStackPredicateArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ItemStackPredicateArgument("predicate")})).executesPlayer((player, args) -> results.set((Predicate)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        if (this.version.lessThan(MCVersion.V1_20_5)) {
            this.server.dispatchCommand((CommandSender)player2, "test dirt");
            Assertions.assertTrue((boolean)((Predicate)results.get()).test(new ItemStack(Material.DIRT)));
        } else {
            this.server.dispatchCommand((CommandSender)player2, "test #axes");
            Assertions.assertTrue((boolean)((Predicate)results.get()).test(new ItemStack(Material.DIAMOND_AXE)));
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithItemStackPredicateArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ItemStackPredicateArgument("predicate")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        ArrayList<String> itemPredicateNames = new ArrayList<String>(MockPlatform.getInstance().getAllItemNames());
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            itemPredicateNames.add(0, "#");
            itemPredicateNames.add(1, "*");
        }
        Assertions.assertEquals(itemPredicateNames, this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(itemPredicateNames.stream().filter(s -> s.contains(":a") || s.contains("_a")).toList(), this.server.getSuggestions((CommandSender)player, "test a"));
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            Assertions.assertEquals(List.of("["), this.server.getSuggestions((CommandSender)player, "test dirt"));
        } else {
            Assertions.assertEquals(List.of("{"), this.server.getSuggestions((CommandSender)player, "test dirt"));
        }
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test dirt["));
        } else {
            Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test dirt{"));
        }
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test dirt[]"));
        } else {
            Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test dirt{}"));
        }
    }
}

