/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.EnchantmentArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Arrays;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentEnchantmentTests
extends TestBase {
    ArgumentEnchantmentTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Assumptions.assumeTrue((boolean)this.version.lessThan(MCVersion.V1_20_3));
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithEnchantmentArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EnchantmentArgument("enchantment")})).executesPlayer((player, args) -> results.set((Enchantment)args.get("enchantment")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test sharpness");
        Assertions.assertEquals((Object)Enchantment.DAMAGE_ALL, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:sharpness");
        Assertions.assertEquals((Object)Enchantment.DAMAGE_ALL, results.get());
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_19_4)) {
            this.assertCommandFailsWith((CommandSender)player2, "test blah", "Can't find element 'minecraft:blah' of type 'minecraft:enchantment'");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test blah", "Unknown enchantment: minecraft:blah");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithEnchantmentArgumentAllEnchantments() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EnchantmentArgument("enchantment")})).executesPlayer((player, args) -> results.set((Enchantment)args.get("enchantment")))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (Enchantment enchantment : MockPlatform.getInstance().getEnchantments()) {
            this.server.dispatchCommand((CommandSender)player2, "test " + enchantment.getKey().getKey());
            Assertions.assertEquals((Object)enchantment, results.get());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithEnchantmentArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EnchantmentArgument("enchantment")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getEnchantments()).map(e -> e.getKey()).map(NamespacedKey::toString).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test minecraft:"));
        Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getEnchantments()).map(e -> e.getKey()).filter(s -> s.toString().contains(":p") || s.toString().contains("_p")).map(NamespacedKey::toString).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test p"));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test x"));
    }
}

