/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.CustomArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.WorldInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ArgumentCustomTests
extends TestBase {
    ArgumentCustomTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    public Argument<World> customWorldArgument(String nodeName) {
        return (Argument)new CustomArgument((Argument)new StringArgument(nodeName), info -> {
            World world = Bukkit.getWorld((String)info.input());
            if (world == null) {
                throw CustomArgument.CustomArgumentException.fromMessageBuilder((CustomArgument.MessageBuilder)new CustomArgument.MessageBuilder("Unknown world: ").appendArgInput());
            }
            return world;
        }).replaceSuggestions(ArgumentSuggestions.strings(info -> (String[])Bukkit.getWorlds().stream().map(WorldInfo::getName).toArray(String[]::new)));
    }

    public Argument<World> customArgumentThatThrowsException(String nodeName) {
        return new CustomArgument((Argument)new StringArgument(nodeName), info -> {
            throw new RuntimeException("\ud83d\udc7b Spoopy Exception \ud83d\udc7b");
        });
    }

    @Test
    void executionTestWithCustomWorldArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{this.customWorldArgument("world")})).executesPlayer((player, args) -> results.set((World)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        WorldMock world1 = this.server.addSimpleWorld("world1");
        this.server.addSimpleWorld("world2");
        this.server.addSimpleWorld("world3");
        this.assertCommandFailsWith((CommandSender)player2, "test unknownworld", "Unknown world: unknownworld");
        this.server.dispatchCommand((CommandSender)player2, "test world1");
        Assertions.assertEquals((Object)world1, results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithCustomArgumentThatThrowsException() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{this.customArgumentThatThrowsException("world")})).executesPlayer((player, args) -> results.set((World)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.assertCommandFailsWith((CommandSender)player2, "test world", "Error in executing command test world - world<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithCustomWorldArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{this.customWorldArgument("world")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.server.addSimpleWorld("world1");
        this.server.addSimpleWorld("world2");
        this.server.addSimpleWorld("world3");
        Assertions.assertEquals(List.of("world", "world1", "world2", "world3"), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void instantiationTestWithLiteralCustomArgument() {
        LiteralArgument literalArgument = new LiteralArgument("world");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CustomArgument((Argument)literalArgument, info -> 1));
        MultiLiteralArgument multiLiteralArgument = new MultiLiteralArgument("node", List.of("hello", "world"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CustomArgument((Argument)multiLiteralArgument, info -> 1));
    }

    @Test
    void instantiationTestWithCustomArgumentException() {
        String result = "result";
        CommandContext context = (CommandContext)Mockito.mock(CommandContext.class);
        Mockito.when((Object)context.getInput()).thenReturn((Object)"input");
        Assertions.assertDoesNotThrow(() -> CustomArgument.CustomArgumentException.fromString((String)"hello").toCommandSyntax("result", context));
        BaseComponent[] baseComponents = new ComponentBuilder("hello").create();
        Assertions.assertDoesNotThrow(() -> CustomArgument.CustomArgumentException.fromBaseComponents((BaseComponent[])baseComponents).toCommandSyntax("result", context));
        TextComponent adventureComponent = Component.text((String)"hello");
        Assertions.assertDoesNotThrow(() -> ArgumentCustomTests.lambda$instantiationTestWithCustomArgumentException$12((Component)adventureComponent, context));
        Assertions.assertThrows(IllegalStateException.class, () -> CustomArgument.CustomArgumentException.fromString(null).toCommandSyntax("result", context));
        Assertions.assertThrows(IllegalStateException.class, () -> CustomArgument.CustomArgumentException.fromBaseComponents(null).toCommandSyntax("result", context));
        Assertions.assertThrows(IllegalStateException.class, () -> CustomArgument.CustomArgumentException.fromAdventureComponent(null).toCommandSyntax("result", context));
    }

    private static /* synthetic */ CommandSyntaxException lambda$instantiationTestWithCustomArgumentException$12(Component adventureComponent, CommandContext context) throws Throwable {
        return CustomArgument.CustomArgumentException.fromAdventureComponent((Component)adventureComponent).toCommandSyntax("result", context);
    }
}

